/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor;

import java.lang.reflect.Field;
import java.sql.Types;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.internal.CoreMessageLogger;
import org.jboss.logging.Logger;

public class JdbcTypeNameMapper {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, JdbcTypeNameMapper.class.getName());
    private static Map<Integer, String> JDBC_TYPE_MAP = JdbcTypeNameMapper.buildJdbcTypeMap();

    private static Map<Integer, String> buildJdbcTypeMap() {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        Field[] fields = Types.class.getFields();
        if (fields == null) {
            throw new HibernateException("Unexpected problem extracting JDBC type mapping codes from java.sql.Types");
        }
        for (Field field : fields) {
            try {
                int code = field.getInt(null);
                String old = map.put(code, field.getName());
                if (old == null) continue;
                LOG.JavaSqlTypesMappedSameCodeMultipleTimes(code, old, field.getName());
            }
            catch (IllegalAccessException e) {
                throw new HibernateException("Unable to access JDBC type mapping [" + field.getName() + "]", e);
            }
        }
        return Collections.unmodifiableMap(map);
    }

    public static String getTypeName(Integer code) {
        String name = JDBC_TYPE_MAP.get(code);
        if (name == null) {
            return "UNKNOWN(" + code + ")";
        }
        return name;
    }
}

