/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.service;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.hibernate.cfg.Environment;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.integrator.spi.IntegratorService;
import org.hibernate.integrator.spi.ServiceContributingIntegrator;
import org.hibernate.internal.jaxb.Origin;
import org.hibernate.internal.jaxb.SourceType;
import org.hibernate.internal.jaxb.cfg.JaxbHibernateConfiguration;
import org.hibernate.internal.util.Value;
import org.hibernate.internal.util.config.ConfigurationException;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.BootstrapServiceRegistry;
import org.hibernate.service.Service;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.StandardServiceInitiators;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.hibernate.service.internal.BootstrapServiceRegistryImpl;
import org.hibernate.service.internal.JaxbProcessor;
import org.hibernate.service.internal.ProvidedService;
import org.hibernate.service.internal.StandardServiceRegistryImpl;
import org.hibernate.service.spi.BasicServiceInitiator;
import org.jboss.logging.Logger;

public class ServiceRegistryBuilder {
    private static final Logger log = Logger.getLogger(ServiceRegistryBuilder.class);
    public static final String DEFAULT_CFG_RESOURCE_NAME = "hibernate.cfg.xml";
    private final Map settings;
    private final List<BasicServiceInitiator> initiators = ServiceRegistryBuilder.standardInitiatorList();
    private final List<ProvidedService> providedServices = new ArrayList<ProvidedService>();
    private final BootstrapServiceRegistry bootstrapServiceRegistry;
    private Value<JaxbProcessor> jaxbProcessorHolder = new Value<1>(new Value.DeferredInitializer<JaxbProcessor>(){

        @Override
        public JaxbProcessor initialize() {
            return new JaxbProcessor(ServiceRegistryBuilder.this.bootstrapServiceRegistry.getService(ClassLoaderService.class));
        }
    });

    public ServiceRegistryBuilder() {
        this(new BootstrapServiceRegistryImpl());
    }

    public ServiceRegistryBuilder(BootstrapServiceRegistry bootstrapServiceRegistry) {
        this.settings = Environment.getProperties();
        this.bootstrapServiceRegistry = bootstrapServiceRegistry;
    }

    private static List<BasicServiceInitiator> standardInitiatorList() {
        ArrayList<BasicServiceInitiator> initiators = new ArrayList<BasicServiceInitiator>();
        initiators.addAll(StandardServiceInitiators.LIST);
        return initiators;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ServiceRegistryBuilder loadProperties(String resourceName) {
        InputStream stream = this.bootstrapServiceRegistry.getService(ClassLoaderService.class).locateResourceStream(resourceName);
        try {
            Properties properties = new Properties();
            properties.load(stream);
            this.settings.putAll(properties);
        }
        catch (IOException e) {
            try {
                throw new ConfigurationException("Unable to apply settings from properties file [" + resourceName + "]", e);
            }
            catch (Throwable throwable) {
                try {
                    stream.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    log.debug((Object)String.format("Unable to close properties file [%s] stream", resourceName), e2);
                }
                throw throwable;
            }
        }
        try {
            stream.close();
            return this;
        }
        catch (IOException e) {
            log.debug((Object)String.format("Unable to close properties file [%s] stream", resourceName), e);
            return this;
        }
    }

    public ServiceRegistryBuilder configure() {
        return this.configure(DEFAULT_CFG_RESOURCE_NAME);
    }

    public ServiceRegistryBuilder configure(String resourceName) {
        InputStream stream = this.bootstrapServiceRegistry.getService(ClassLoaderService.class).locateResourceStream(resourceName);
        JaxbHibernateConfiguration configurationElement = this.jaxbProcessorHolder.getValue().unmarshal(stream, new Origin(SourceType.RESOURCE, resourceName));
        for (JaxbHibernateConfiguration.JaxbSessionFactory.JaxbProperty xmlProperty : configurationElement.getSessionFactory().getProperty()) {
            this.settings.put(xmlProperty.getName(), xmlProperty.getValue());
        }
        return this;
    }

    public ServiceRegistryBuilder applySetting(String settingName, Object value) {
        this.settings.put(settingName, value);
        return this;
    }

    public ServiceRegistryBuilder applySettings(Map settings) {
        this.settings.putAll(settings);
        return this;
    }

    public ServiceRegistryBuilder addInitiator(BasicServiceInitiator initiator) {
        this.initiators.add(initiator);
        return this;
    }

    public ServiceRegistryBuilder addService(Class serviceRole, Service service) {
        this.providedServices.add(new ProvidedService<Service>(serviceRole, service));
        return this;
    }

    public ServiceRegistry buildServiceRegistry() {
        HashMap settingsCopy = new HashMap();
        settingsCopy.putAll(this.settings);
        Environment.verifyProperties(settingsCopy);
        ConfigurationHelper.resolvePlaceHolders(settingsCopy);
        for (Integrator integrator : this.bootstrapServiceRegistry.getService(IntegratorService.class).getIntegrators()) {
            if (!ServiceContributingIntegrator.class.isInstance(integrator)) continue;
            ((ServiceContributingIntegrator)ServiceContributingIntegrator.class.cast(integrator)).prepareServices(this);
        }
        return new StandardServiceRegistryImpl(this.bootstrapServiceRegistry, this.initiators, this.providedServices, settingsCopy);
    }

    public static void destroy(ServiceRegistry serviceRegistry) {
        ((StandardServiceRegistryImpl)serviceRegistry).destroy();
    }
}

