/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.map.species.fields;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import lcsb.mapviewer.model.map.MiriamData;
import lcsb.mapviewer.model.map.MiriamType;
import lcsb.mapviewer.model.map.species.Phenotype;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="associated_phenotype_element_table")
public class AssociatedElement {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="idDb", unique=true, nullable=false)
    private int id;
    private MiriamType source = MiriamType.UNKNOWN;
    @Cascade(value={CascadeType.ALL})
    @OneToOne
    private MiriamData data;
    @ManyToOne
    private Phenotype phenotype;

    public AssociatedElement() {
    }

    public AssociatedElement(AssociatedElement ae) {
        this.source = ae.source;
        this.data = new MiriamData(ae.getData());
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public MiriamType getSource() {
        return this.source;
    }

    public void setSource(MiriamType source) {
        this.source = source;
    }

    public MiriamData getData() {
        return this.data;
    }

    public void setData(MiriamData data) {
        this.data = data;
    }

    public Phenotype getPhenotype() {
        return this.phenotype;
    }

    public void setPhenotype(Phenotype phenotype) {
        this.phenotype = phenotype;
    }
}

