/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.map.species;

import java.util.Comparator;
import lcsb.mapviewer.common.comparator.BooleanComparator;
import lcsb.mapviewer.common.comparator.IntegerComparator;
import lcsb.mapviewer.common.comparator.StringComparator;
import lcsb.mapviewer.common.exception.InvalidClassException;
import lcsb.mapviewer.model.map.ElementComparator;
import lcsb.mapviewer.model.map.species.AntisenseRna;
import lcsb.mapviewer.model.map.species.AntisenseRnaComparator;
import lcsb.mapviewer.model.map.species.ComplexSpecies;
import lcsb.mapviewer.model.map.species.ComplexSpeciesComparator;
import lcsb.mapviewer.model.map.species.Degraded;
import lcsb.mapviewer.model.map.species.DegradedComparator;
import lcsb.mapviewer.model.map.species.Drug;
import lcsb.mapviewer.model.map.species.DrugComparator;
import lcsb.mapviewer.model.map.species.Gene;
import lcsb.mapviewer.model.map.species.GeneComparator;
import lcsb.mapviewer.model.map.species.Ion;
import lcsb.mapviewer.model.map.species.IonComparator;
import lcsb.mapviewer.model.map.species.Phenotype;
import lcsb.mapviewer.model.map.species.PhenotypeComparator;
import lcsb.mapviewer.model.map.species.Protein;
import lcsb.mapviewer.model.map.species.ProteinComparator;
import lcsb.mapviewer.model.map.species.Rna;
import lcsb.mapviewer.model.map.species.RnaComparator;
import lcsb.mapviewer.model.map.species.SimpleMolecule;
import lcsb.mapviewer.model.map.species.SimpleMoleculeComparator;
import lcsb.mapviewer.model.map.species.Species;
import lcsb.mapviewer.model.map.species.Unknown;
import lcsb.mapviewer.model.map.species.UnknownComparator;
import org.apache.log4j.Logger;

public class SpeciesComparator
implements Comparator<Species> {
    private static Logger logger = Logger.getLogger(SpeciesComparator.class);
    private AntisenseRnaComparator antisenseRnaComparator;
    private ComplexSpeciesComparator complexSpeciesComparator;
    private DegradedComparator degradedComparator;
    private DrugComparator drugComparator;
    private GeneComparator geneComparator;
    private IonComparator ionComparator;
    private PhenotypeComparator phenotypeComparator;
    private ProteinComparator proteinComparator;
    private RnaComparator rnaComparator;
    private SimpleMoleculeComparator simpleMoleculeComparator;
    private UnknownComparator unknownComparator;
    private double epsilon;

    public SpeciesComparator(double epsilon) {
        this.epsilon = epsilon;
        this.antisenseRnaComparator = new AntisenseRnaComparator(epsilon);
        this.complexSpeciesComparator = new ComplexSpeciesComparator(epsilon);
        this.degradedComparator = new DegradedComparator(epsilon);
        this.drugComparator = new DrugComparator(epsilon);
        this.geneComparator = new GeneComparator(epsilon);
        this.ionComparator = new IonComparator(epsilon);
        this.phenotypeComparator = new PhenotypeComparator(epsilon);
        this.proteinComparator = new ProteinComparator(epsilon);
        this.rnaComparator = new RnaComparator(epsilon);
        this.simpleMoleculeComparator = new SimpleMoleculeComparator(epsilon);
        this.unknownComparator = new UnknownComparator(epsilon);
    }

    public SpeciesComparator() {
        this(1.0E-6);
    }

    @Override
    public int compare(Species arg0, Species arg1) {
        if (arg0 == null) {
            if (arg1 == null) {
                return 0;
            }
            return 1;
        }
        if (arg1 == null) {
            return -1;
        }
        if (arg0.getClass().equals(arg1.getClass())) {
            if (arg0 instanceof AntisenseRna) {
                return this.antisenseRnaComparator.compare((AntisenseRna)arg0, (AntisenseRna)arg1);
            }
            if (arg0 instanceof ComplexSpecies) {
                return this.complexSpeciesComparator.compare((ComplexSpecies)arg0, (ComplexSpecies)arg1);
            }
            if (arg0 instanceof Degraded) {
                return this.degradedComparator.compare((Degraded)arg0, (Degraded)arg1);
            }
            if (arg0 instanceof Drug) {
                return this.drugComparator.compare((Drug)arg0, (Drug)arg1);
            }
            if (arg0 instanceof Gene) {
                return this.geneComparator.compare((Gene)arg0, (Gene)arg1);
            }
            if (arg0 instanceof Ion) {
                return this.ionComparator.compare((Ion)arg0, (Ion)arg1);
            }
            if (arg0 instanceof Phenotype) {
                return this.phenotypeComparator.compare((Phenotype)arg0, (Phenotype)arg1);
            }
            if (arg0 instanceof Protein) {
                return this.proteinComparator.compare((Protein)arg0, (Protein)arg1);
            }
            if (arg0 instanceof Rna) {
                return this.rnaComparator.compare((Rna)arg0, (Rna)arg1);
            }
            if (arg0 instanceof SimpleMolecule) {
                return this.simpleMoleculeComparator.compare((SimpleMolecule)arg0, (SimpleMolecule)arg1);
            }
            if (arg0 instanceof Unknown) {
                return this.unknownComparator.compare((Unknown)arg0, (Unknown)arg1);
            }
            throw new InvalidClassException("Don't know how to compare classes: " + arg0.getClass());
        }
        logger.debug("class different: " + arg0.getClass() + ", " + arg1.getClass());
        return -1;
    }

    public int internalCompare(Species arg0, Species arg1) {
        ElementComparator elementComparator = new ElementComparator(this.epsilon);
        StringComparator stringComparator = new StringComparator();
        IntegerComparator integerComparator = new IntegerComparator();
        BooleanComparator booleanComparator = new BooleanComparator();
        int result = elementComparator.internalCompare(arg0, arg1);
        if (result != 0) {
            return result;
        }
        if (stringComparator.compare(arg0.getIdSpecies(), arg1.getIdSpecies()) != 0) {
            logger.debug("Id species different: " + arg0.getIdSpecies() + ", " + arg1.getIdSpecies());
            return stringComparator.compare(arg0.getIdSpecies(), arg1.getIdSpecies());
        }
        if (stringComparator.compare(arg0.getMetaId(), arg1.getMetaId()) != 0) {
            logger.debug("MetaId different: " + arg0.getMetaId() + ", " + arg1.getMetaId());
            return stringComparator.compare(arg0.getMetaId(), arg1.getMetaId());
        }
        if (integerComparator.compare(arg0.getInitialAmount(), arg1.getInitialAmount()) != 0) {
            logger.debug("Initial amount different: " + arg0.getInitialAmount() + ", " + arg1.getInitialAmount());
            return integerComparator.compare(arg0.getInitialAmount(), arg1.getInitialAmount());
        }
        if (integerComparator.compare(arg0.getCharge(), arg1.getCharge()) != 0) {
            logger.debug("Charge different: " + arg0.getCharge() + ", " + arg1.getCharge());
            return integerComparator.compare(arg0.getCharge(), arg1.getCharge());
        }
        if (integerComparator.compare(arg0.getInitialConcentration(), arg1.getInitialConcentration()) != 0) {
            logger.debug("Initial concentration different: " + arg0.getInitialConcentration() + ", " + arg1.getInitialConcentration());
            return integerComparator.compare(arg0.getInitialConcentration(), arg1.getInitialConcentration());
        }
        if (booleanComparator.compare(arg0.hasOnlySubstanceUnits(), arg1.hasOnlySubstanceUnits()) != 0) {
            logger.debug("OnlySubstanceUnits different: " + arg0.hasOnlySubstanceUnits() + ", " + arg1.hasOnlySubstanceUnits());
            return booleanComparator.compare(arg0.hasOnlySubstanceUnits(), arg1.hasOnlySubstanceUnits());
        }
        if (arg0.getPositionToCompartment() != null || arg1.getPositionToCompartment() != null) {
            Integer pos0 = null;
            Integer pos1 = null;
            if (arg0.getPositionToCompartment() != null) {
                pos0 = arg0.getPositionToCompartment().ordinal();
            }
            if (arg1.getPositionToCompartment() != null) {
                pos1 = arg1.getPositionToCompartment().ordinal();
            }
            if (integerComparator.compare(pos0, pos1) != 0) {
                logger.debug("PositionToCompartment different: \"" + (Object)((Object)arg0.getPositionToCompartment()) + "\", \"" + (Object)((Object)arg1.getPositionToCompartment()) + "\"");
                return integerComparator.compare(pos0, pos1);
            }
        }
        if (booleanComparator.compare(arg0.isHypothetical(), arg1.isHypothetical()) != 0) {
            logger.debug("Hypothetical different: \"" + arg0.isHypothetical() + "\", \"" + arg1.isHypothetical() + "\"");
            return booleanComparator.compare(arg0.isHypothetical(), arg1.isHypothetical());
        }
        return 0;
    }
}

