/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.map.species;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import lcsb.mapviewer.common.comparator.IntegerComparator;
import lcsb.mapviewer.common.comparator.StringComparator;
import lcsb.mapviewer.common.comparator.StringSetComparator;
import lcsb.mapviewer.common.exception.InvalidClassException;
import lcsb.mapviewer.model.map.species.Protein;
import lcsb.mapviewer.model.map.species.SpeciesComparator;
import lcsb.mapviewer.model.map.species.fields.ModificationResidue;
import org.apache.log4j.Logger;

public class ProteinComparator
implements Comparator<Protein> {
    private Logger logger = Logger.getLogger(ProteinComparator.class);
    private double epsilon;

    public ProteinComparator(double epsilon) {
        this.epsilon = epsilon;
    }

    public ProteinComparator() {
        this(1.0E-6);
    }

    @Override
    public int compare(Protein arg0, Protein arg1) {
        if (arg0 == null) {
            if (arg1 == null) {
                return 0;
            }
            return 1;
        }
        if (arg1 == null) {
            return -1;
        }
        if (arg0.getClass().equals(arg1.getClass())) {
            if (arg0 instanceof Protein) {
                return this.internalCompare(arg0, arg1);
            }
            throw new InvalidClassException("Don't know how to compare classes: " + arg0.getClass());
        }
        return -1;
    }

    private int internalCompare(Protein arg0, Protein arg1) {
        SpeciesComparator speciesComparator = new SpeciesComparator(this.epsilon);
        int result = speciesComparator.internalCompare(arg0, arg1);
        if (result != 0) {
            return result;
        }
        StringComparator stringComparator = new StringComparator();
        IntegerComparator integerComparator = new IntegerComparator();
        StringSetComparator stringSetComparator = new StringSetComparator();
        if (integerComparator.compare(arg0.getHomodimer(), arg1.getHomodimer()) != 0) {
            this.logger.debug("homodimer different: " + arg0.getHomodimer() + ", " + arg1.getHomodimer());
            return integerComparator.compare(arg0.getHomodimer(), arg1.getHomodimer());
        }
        if (stringComparator.compare(arg0.getStructuralState(), arg1.getStructuralState()) != 0) {
            this.logger.debug("structural state different: " + arg0.getStructuralState() + ", " + arg1.getStructuralState());
            return stringComparator.compare(arg0.getStructuralState(), arg1.getStructuralState());
        }
        HashSet<String> set1 = new HashSet<String>();
        HashSet<String> set2 = new HashSet<String>();
        for (ModificationResidue region : arg0.getModificationResidues()) {
            set1.add(region.toString());
        }
        for (ModificationResidue region : arg1.getModificationResidues()) {
            set2.add(region.toString());
        }
        if (stringSetComparator.compare((Set<String>)set1, (Set<String>)set2) != 0) {
            this.logger.debug("modification residues different");
            return stringSetComparator.compare((Set<String>)set1, (Set<String>)set2);
        }
        return 0;
    }
}

