/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.map.species;

import java.util.Comparator;
import lcsb.mapviewer.common.comparator.IntegerComparator;
import lcsb.mapviewer.common.comparator.StringComparator;
import lcsb.mapviewer.common.exception.InvalidArgumentException;
import lcsb.mapviewer.common.exception.InvalidClassException;
import lcsb.mapviewer.model.map.Element;
import lcsb.mapviewer.model.map.ElementComparator;
import lcsb.mapviewer.model.map.agregator.Compartment;
import lcsb.mapviewer.model.map.species.ComplexSpecies;
import lcsb.mapviewer.model.map.species.Species;
import lcsb.mapviewer.model.map.species.SpeciesComparator;
import org.apache.log4j.Logger;

public class ComplexSpeciesComparator
implements Comparator<ComplexSpecies> {
    private Logger logger = Logger.getLogger(ComplexSpeciesComparator.class);
    private double epsilon;

    public ComplexSpeciesComparator(double epsilon) {
        this.epsilon = epsilon;
    }

    public ComplexSpeciesComparator() {
        this(1.0E-6);
    }

    @Override
    public int compare(ComplexSpecies arg0, ComplexSpecies arg1) {
        if (arg0 == null) {
            if (arg1 == null) {
                return 0;
            }
            return 1;
        }
        if (arg1 == null) {
            return -1;
        }
        if (arg0.getClass().equals(arg1.getClass())) {
            if (arg0 instanceof ComplexSpecies) {
                return this.internalCompare(arg0, arg1);
            }
            throw new InvalidClassException("Don't know how to compare classes: " + arg0.getClass());
        }
        return -1;
    }

    private int internalCompare(ComplexSpecies arg0, ComplexSpecies arg1) {
        boolean found;
        ElementComparator elementComparator = new ElementComparator(this.epsilon);
        SpeciesComparator speciesComparator = new SpeciesComparator(this.epsilon);
        int result = speciesComparator.internalCompare(arg0, arg1);
        if (result != 0) {
            return result;
        }
        IntegerComparator integerComparator = new IntegerComparator();
        StringComparator stringComparator = new StringComparator();
        if (integerComparator.compare(arg0.getHomodimer(), arg1.getHomodimer()) != 0) {
            this.logger.debug("Homodimer different: " + arg0.getHomodimer() + ", " + arg1.getHomodimer());
            return integerComparator.compare(arg0.getHomodimer(), arg1.getHomodimer());
        }
        if (integerComparator.compare(arg0.getElements().size(), arg1.getElements().size()) != 0) {
            this.logger.debug("Species size different: " + arg0.getElements().size() + ", " + arg1.getElements().size());
            return integerComparator.compare(arg0.getElements().size(), arg1.getElements().size());
        }
        if (stringComparator.compare(arg0.getStructuralState(), arg1.getStructuralState()) != 0) {
            this.logger.debug("Species structuralState different: " + arg0.getStructuralState() + ", " + arg1.getStructuralState());
            return stringComparator.compare(arg0.getStructuralState(), arg1.getStructuralState());
        }
        for (Element element : arg0.getElements()) {
            found = false;
            if (element instanceof Species) {
                for (Element element1 : arg1.getElements()) {
                    if (!(element1 instanceof Species) || !((Species)element).getIdSpecies().equals(((Species)element1).getIdSpecies())) continue;
                    if (elementComparator.compare(element, element1) != 0) {
                        this.logger.debug("Species different: " + ((Species)element).getIdSpecies());
                        return elementComparator.compare(element, element1);
                    }
                    found = true;
                }
            } else if (element instanceof Compartment) {
                for (Element element1 : arg1.getElements()) {
                    if (!(element1 instanceof Compartment) || !((Compartment)element).getCompartmentId().equals(((Compartment)element1).getCompartmentId())) continue;
                    if (elementComparator.compare(element, element1) != 0) {
                        this.logger.debug("Compartment different: " + ((Compartment)element).getCompartmentId());
                        return elementComparator.compare(element, element1);
                    }
                    found = true;
                }
            } else {
                for (Element element1 : arg1.getElements()) {
                    if (elementComparator.compare(element, element1) != 0) continue;
                    found = true;
                }
                throw new InvalidArgumentException();
            }
            if (found) continue;
            if (element instanceof Species) {
                this.logger.debug("Cannot find element: " + ((Species)element).getIdSpecies() + " in:");
                for (Element el : arg1.getElements()) {
                    this.logger.debug(((Species)el).getIdSpecies());
                }
            }
            return -1;
        }
        for (Element element : arg1.getElements()) {
            found = false;
            if (element instanceof Species) {
                for (Element element1 : arg0.getElements()) {
                    if (!(element1 instanceof Species) || !((Species)element).getIdSpecies().equals(((Species)element1).getIdSpecies()) || elementComparator.compare(element, element1) != 0) continue;
                    found = true;
                }
            } else if (element instanceof Compartment) {
                for (Element element1 : arg0.getElements()) {
                    if (!(element1 instanceof Compartment) || !((Compartment)element).getCompartmentId().equals(((Compartment)element1).getCompartmentId()) || elementComparator.compare(element, element1) != 0) continue;
                    found = true;
                }
            } else {
                for (Element element1 : arg0.getElements()) {
                    if (elementComparator.compare(element, element1) != 0) continue;
                    found = true;
                }
            }
            if (found) continue;
            if (element instanceof Species) {
                this.logger.debug("Cannot find element: " + ((Species)element).getIdSpecies());
            }
            return 1;
        }
        return 0;
    }
}

