/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.map.reaction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import lcsb.mapviewer.common.exception.InvalidArgumentException;
import lcsb.mapviewer.model.map.reaction.AbstractNode;
import lcsb.mapviewer.model.map.reaction.Modifier;
import lcsb.mapviewer.model.map.reaction.Product;
import lcsb.mapviewer.model.map.reaction.Reactant;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@DiscriminatorValue(value="GENERIC_OPERATOR_NODE")
public abstract class NodeOperator
extends AbstractNode {
    private static Logger logger = Logger.getLogger(NodeOperator.class);
    @Cascade(value={CascadeType.ALL})
    @OneToMany(fetch=FetchType.EAGER, mappedBy="nodeOperatorForInput")
    @OrderBy(value="id")
    private List<AbstractNode> inputs = new ArrayList<AbstractNode>();
    @Cascade(value={CascadeType.ALL})
    @OneToMany(fetch=FetchType.EAGER, mappedBy="nodeOperatorForOutput")
    @OrderBy(value="id")
    private List<AbstractNode> outputs = new ArrayList<AbstractNode>();

    public NodeOperator() {
    }

    public NodeOperator(NodeOperator operator) {
        super(operator);
        for (AbstractNode node : operator.getInputs()) {
            this.addInput(node);
        }
        for (AbstractNode node : operator.getOutputs()) {
            this.addOutput(node);
        }
    }

    public void addInput(AbstractNode node) {
        node.setNodeOperatorForInput(this);
        if (this.inputs.contains(node)) {
            throw new InvalidArgumentException("Node already on the list: " + node);
        }
        this.inputs.add(node);
    }

    public void addInputs(Collection<AbstractNode> newInputs) {
        for (AbstractNode input : newInputs) {
            this.addInput(input);
        }
    }

    public boolean isReactantOperator() {
        for (AbstractNode node : this.inputs) {
            if (node instanceof Reactant) {
                return true;
            }
            if (!(node instanceof NodeOperator) || !((NodeOperator)node).isReactantOperator()) continue;
            return true;
        }
        return false;
    }

    public void addOutput(AbstractNode node) {
        node.setNodeOperatorForOutput(this);
        if (this.outputs.contains(node)) {
            throw new InvalidArgumentException("Node already on the list: " + node);
        }
        this.outputs.add(node);
    }

    public boolean isProductOperator() {
        for (AbstractNode node : this.outputs) {
            if (node instanceof Product) {
                return true;
            }
            if (!(node instanceof NodeOperator) || !((NodeOperator)node).isProductOperator()) continue;
            return true;
        }
        return false;
    }

    public abstract String getOperatorText();

    public boolean isModifierOperator() {
        for (AbstractNode node : this.inputs) {
            if (node instanceof Modifier) {
                return true;
            }
            if (!(node instanceof NodeOperator) || !((NodeOperator)node).isProductOperator()) continue;
            return true;
        }
        return false;
    }

    public void addOutputs(Set<AbstractNode> newOutputs) {
        for (AbstractNode output : newOutputs) {
            this.addOutput(output);
        }
    }

    public List<AbstractNode> getInputs() {
        return this.inputs;
    }

    public void setInputs(List<AbstractNode> inputs) {
        this.inputs = inputs;
    }

    public List<AbstractNode> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(List<AbstractNode> outputs) {
        this.outputs = outputs;
    }
}

