/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.map.reaction;

import java.util.Comparator;
import lcsb.mapviewer.common.exception.InvalidClassException;
import lcsb.mapviewer.model.graphics.PolylineDataComparator;
import lcsb.mapviewer.model.map.reaction.AbstractNode;
import lcsb.mapviewer.model.map.reaction.NodeOperator;
import lcsb.mapviewer.model.map.reaction.NodeOperatorComparator;
import lcsb.mapviewer.model.map.reaction.ReactionNode;
import lcsb.mapviewer.model.map.reaction.ReactionNodeComparator;
import org.apache.log4j.Logger;

public class AbstractNodeComparator
implements Comparator<AbstractNode> {
    private Logger logger = Logger.getLogger(AbstractNodeComparator.class);
    private double epsilon;

    public AbstractNodeComparator(double epsilon) {
        this.epsilon = epsilon;
    }

    public AbstractNodeComparator() {
        this(1.0E-6);
    }

    @Override
    public int compare(AbstractNode arg0, AbstractNode arg1) {
        if (arg0 == null) {
            if (arg1 == null) {
                return 0;
            }
            return 1;
        }
        if (arg1 == null) {
            return -1;
        }
        if (arg0.getClass().equals(arg1.getClass())) {
            if (arg0 instanceof NodeOperator) {
                NodeOperatorComparator nodeOperatorComparator = new NodeOperatorComparator(this.epsilon);
                return nodeOperatorComparator.compare((NodeOperator)arg0, (NodeOperator)arg1);
            }
            if (arg0 instanceof ReactionNode) {
                ReactionNodeComparator reactionNodeComparator = new ReactionNodeComparator(this.epsilon);
                return reactionNodeComparator.compare((ReactionNode)arg0, (ReactionNode)arg1);
            }
            throw new InvalidClassException("Don't know how to compare classes: " + arg0.getClass());
        }
        return -1;
    }

    protected int internalCompare(AbstractNode arg0, AbstractNode arg1) {
        PolylineDataComparator pdComparator = new PolylineDataComparator(this.epsilon);
        if (pdComparator.compare(arg0.getLine(), arg1.getLine()) != 0) {
            this.logger.debug("Different Lines size: " + arg0.getLine() + ", " + arg1.getLine());
            return pdComparator.compare(arg0.getLine(), arg1.getLine());
        }
        return 0;
    }
}

