/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.map.reaction;

import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import lcsb.mapviewer.model.graphics.PolylineData;
import lcsb.mapviewer.model.map.reaction.NodeOperator;
import lcsb.mapviewer.model.map.reaction.Reaction;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="node_table")
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name="node_type_db", discriminatorType=DiscriminatorType.STRING)
@DiscriminatorValue(value="GENERIC_NODE")
public abstract class AbstractNode {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="idDb", unique=true, nullable=false)
    private int id;
    @ManyToOne
    private NodeOperator nodeOperatorForInput = null;
    @ManyToOne
    private NodeOperator nodeOperatorForOutput = null;
    @ManyToOne
    private Reaction reaction = null;
    @Cascade(value={CascadeType.ALL})
    @OneToOne(fetch=FetchType.EAGER)
    private PolylineData line;

    public AbstractNode() {
    }

    public AbstractNode(AbstractNode node) {
        this.reaction = node.reaction;
        this.line = new PolylineData(node.getLine());
    }

    public Reaction getReaction() {
        return this.reaction;
    }

    public void setReaction(Reaction reaction) {
        this.reaction = reaction;
    }

    public PolylineData getLine() {
        return this.line;
    }

    public void setLine(PolylineData line) {
        this.line = line;
    }

    public abstract AbstractNode copy();

    public NodeOperator getNodeOperatorForInput() {
        return this.nodeOperatorForInput;
    }

    public void setNodeOperatorForInput(NodeOperator nodeOperatorForInput) {
        this.nodeOperatorForInput = nodeOperatorForInput;
    }

    public NodeOperator getNodeOperatorForOutput() {
        return this.nodeOperatorForOutput;
    }

    public void setNodeOperatorForOutput(NodeOperator nodeOperatorForOutput) {
        this.nodeOperatorForOutput = nodeOperatorForOutput;
    }
}

