/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.map.model;

import java.util.Comparator;
import lcsb.mapviewer.common.comparator.StringComparator;
import lcsb.mapviewer.common.exception.InvalidClassException;
import lcsb.mapviewer.model.map.model.AliasSubmodelConnection;
import lcsb.mapviewer.model.map.model.AliasSubmodelConnectionComparator;
import lcsb.mapviewer.model.map.model.ModelComparator;
import lcsb.mapviewer.model.map.model.ModelSubmodelConnection;
import lcsb.mapviewer.model.map.model.ModelSubmodelConnectionComparator;
import lcsb.mapviewer.model.map.model.SubmodelConnection;
import org.apache.log4j.Logger;

public class SubmodelConnectionComparator
implements Comparator<SubmodelConnection> {
    private static Logger logger = Logger.getLogger(SubmodelConnection.class);
    private double epsilon;

    public SubmodelConnectionComparator(double epsilon) {
        this.epsilon = epsilon;
    }

    public SubmodelConnectionComparator() {
        this(1.0E-6);
    }

    public int internalCompare(SubmodelConnection arg0, SubmodelConnection arg1) {
        StringComparator stringComparator = new StringComparator();
        if (arg0 == null) {
            if (arg1 == null) {
                return 0;
            }
            return 1;
        }
        if (arg1 == null) {
            return -1;
        }
        if (stringComparator.compare(arg0.getName(), arg1.getName()) != 0) {
            logger.debug("Name different: " + arg0.getName() + ", " + arg1.getName());
            return stringComparator.compare(arg0.getName(), arg1.getName());
        }
        if (arg0.getType() == null && arg1.getType() != null) {
            logger.debug("Type different: " + (Object)((Object)arg0.getType()) + ", " + (Object)((Object)arg1.getType()));
            return -1;
        }
        if (arg0.getType() != null) {
            if (arg1.getType() == null) {
                logger.debug("Type different: " + (Object)((Object)arg0.getType()) + ", " + (Object)((Object)arg1.getType()));
                return -1;
            }
            if (arg0.getType().compareTo(arg1.getType()) != 0) {
                logger.debug("Type different: " + (Object)((Object)arg0.getType()) + ", " + (Object)((Object)arg1.getType()));
                return arg0.getType().compareTo(arg1.getType());
            }
        }
        ModelComparator modelComparator = new ModelComparator(this.epsilon);
        if (arg0.getSubmodel() != null && arg1.getSubmodel() != null) {
            int status = modelComparator.compare(arg0.getSubmodel().getModel(), arg1.getSubmodel().getModel());
            if (status != 0) {
                logger.debug("Model different: " + arg0.getSubmodel() + ", " + arg1.getSubmodel());
                return status;
            }
        } else {
            if (arg0.getSubmodel() != null) {
                logger.debug("Model different: " + arg0.getSubmodel() + ", " + arg1.getSubmodel());
                return 1;
            }
            if (arg1.getSubmodel() != null) {
                logger.debug("Model different: " + arg0.getSubmodel() + ", " + arg1.getSubmodel());
                return -1;
            }
        }
        return 0;
    }

    @Override
    public int compare(SubmodelConnection arg0, SubmodelConnection arg1) {
        if (arg0 == null) {
            if (arg1 == null) {
                return 0;
            }
            return 1;
        }
        if (arg1 == null) {
            return -1;
        }
        if (arg0.getClass().equals(arg1.getClass())) {
            if (arg0 instanceof ModelSubmodelConnection) {
                ModelSubmodelConnectionComparator comparator = new ModelSubmodelConnectionComparator(this.epsilon);
                return comparator.compare((ModelSubmodelConnection)arg0, (ModelSubmodelConnection)arg1);
            }
            if (arg0 instanceof AliasSubmodelConnection) {
                AliasSubmodelConnectionComparator comparator = new AliasSubmodelConnectionComparator(this.epsilon);
                return comparator.compare((AliasSubmodelConnection)arg0, (AliasSubmodelConnection)arg1);
            }
            throw new InvalidClassException("Don't know how to compare classes: " + arg0.getClass());
        }
        return -1;
    }
}

