/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.map.model;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lcsb.mapviewer.common.exception.InvalidArgumentException;
import lcsb.mapviewer.model.Project;
import lcsb.mapviewer.model.map.Element;
import lcsb.mapviewer.model.map.MiriamData;
import lcsb.mapviewer.model.map.agregator.Compartment;
import lcsb.mapviewer.model.map.layout.Layout;
import lcsb.mapviewer.model.map.layout.alias.Alias;
import lcsb.mapviewer.model.map.layout.alias.AliasGroup;
import lcsb.mapviewer.model.map.layout.alias.ArtifitialCompartmentAlias;
import lcsb.mapviewer.model.map.layout.alias.BlockDiagram;
import lcsb.mapviewer.model.map.layout.alias.CompartmentAlias;
import lcsb.mapviewer.model.map.layout.alias.ComplexAlias;
import lcsb.mapviewer.model.map.layout.alias.SpeciesAlias;
import lcsb.mapviewer.model.map.layout.graphics.Layer;
import lcsb.mapviewer.model.map.model.Model;
import lcsb.mapviewer.model.map.model.ModelData;
import lcsb.mapviewer.model.map.model.ModelSubmodelConnection;
import lcsb.mapviewer.model.map.model.SubmodelConnection;
import lcsb.mapviewer.model.map.reaction.Reaction;
import lcsb.mapviewer.model.map.species.Species;
import org.apache.log4j.Logger;

public class ModelFullIndexed
implements Model {
    private static Logger logger = Logger.getLogger(ModelFullIndexed.class);
    private Map<String, List<SpeciesAlias>> aliasBySpeciesId = new HashMap<String, List<SpeciesAlias>>();
    private Map<String, Alias> aliasByAliasId = new HashMap<String, Alias>();
    private Map<Integer, Alias> aliasByDbId = new HashMap<Integer, Alias>();
    private Map<String, Species> speciesBySpeciesId = new HashMap<String, Species>();
    private Map<String, List<CompartmentAlias>> compartmentsAliasByCompartmentId = new HashMap<String, List<CompartmentAlias>>();
    private Map<String, Compartment> compartmentByCompartmentId = new HashMap<String, Compartment>();
    private Map<String, Reaction> reactionByReactionId = new HashMap<String, Reaction>();
    private Map<Integer, Reaction> reactionByDbId = new HashMap<Integer, Reaction>();
    private ModelData modelData = null;

    public ModelFullIndexed(ModelData model) {
        if (model == null) {
            this.modelData = new ModelData();
        } else {
            this.modelData = model;
            for (Element element : model.getElements()) {
                if (element instanceof Species) {
                    this.speciesBySpeciesId.put(((Species)element).getIdSpecies(), (Species)element);
                    continue;
                }
                if (element instanceof Compartment) {
                    this.compartmentByCompartmentId.put(((Compartment)element).getCompartmentId(), (Compartment)element);
                    continue;
                }
                throw new InvalidArgumentException("Unknown element class: " + element.getClass());
            }
            for (Alias alias : model.getAliases()) {
                List<Alias> list;
                this.aliasByAliasId.put(alias.getAliasId(), alias);
                this.aliasByDbId.put(alias.getId(), alias);
                if (alias instanceof SpeciesAlias) {
                    String idSpecies = ((SpeciesAlias)alias).getSpecies().getIdSpecies();
                    list = this.aliasBySpeciesId.get(idSpecies);
                    if (list == null) {
                        list = new ArrayList<SpeciesAlias>();
                        this.aliasBySpeciesId.put(idSpecies, list);
                    }
                    list.add((SpeciesAlias)alias);
                    continue;
                }
                if (alias instanceof CompartmentAlias) {
                    if (((CompartmentAlias)alias).getCompartment() == null) {
                        logger.warn("Unknown compartment for alias: " + alias.getAliasId());
                        continue;
                    }
                    String compartmentId = ((CompartmentAlias)alias).getCompartment().getCompartmentId();
                    list = this.compartmentsAliasByCompartmentId.get(compartmentId);
                    if (list == null) {
                        list = new ArrayList<SpeciesAlias>();
                        this.compartmentsAliasByCompartmentId.put(compartmentId, list);
                    }
                    list.add((SpeciesAlias)((Object)((CompartmentAlias)alias)));
                    continue;
                }
                throw new InvalidArgumentException("Unknown alias class: " + alias.getClass());
            }
            for (Reaction reaction : model.getReactions()) {
                this.reactionByReactionId.put(reaction.getIdReaction(), reaction);
                this.reactionByDbId.put(reaction.getId(), reaction);
            }
            if (this.getProject() != null) {
                this.getProject().getName();
            }
            for (ModelSubmodelConnection connection : model.getSubmodels()) {
                if (connection.getSubmodel().getModel() != null) continue;
                connection.getSubmodel().setModel(new ModelFullIndexed(connection.getSubmodel()));
            }
            for (Layout layout : this.modelData.getLayouts()) {
                if (layout.getCreator() == null) continue;
                layout.getCreator().getId();
            }
        }
        this.modelData.setModel(this);
    }

    @Override
    public void addAlias(SpeciesAlias al) {
        this.modelData.addAlias(al);
        String idSpecies = null;
        if (al.getSpecies() == null) {
            throw new InvalidArgumentException("Alias " + al.getAliasId() + " does not contain species");
        }
        idSpecies = al.getSpecies().getIdSpecies();
        List<SpeciesAlias> list = this.aliasBySpeciesId.get(idSpecies);
        if (list == null) {
            list = new ArrayList<SpeciesAlias>();
            this.aliasBySpeciesId.put(idSpecies, list);
        }
        list.add(al);
        Alias alias2 = this.aliasByAliasId.get(al.getAliasId());
        if (alias2 == null) {
            this.aliasByAliasId.put(al.getAliasId(), al);
            this.aliasByDbId.put(al.getId(), al);
        } else {
            logger.error("Alias with duplicated id: " + al.getAliasId());
        }
        if (al.getParent() != null) {
            Alias ca;
            if (al.getSpecies().getParent() == null) {
                Alias parentAlias = al.getParent();
                Compartment compartment = null;
                while (!(parentAlias instanceof CompartmentAlias) && compartment == null) {
                    if ((parentAlias = parentAlias.getParent()) != null || (compartment = this.getCompartmentByCompartmentId("default")) != null) continue;
                    throw new InvalidArgumentException("Default compartment does not exist...");
                }
                if (compartment == null) {
                    compartment = ((CompartmentAlias)parentAlias).getCompartment();
                }
                al.getSpecies().setParent(compartment);
            }
            if (al.getParent() instanceof CompartmentAlias) {
                ca = (CompartmentAlias)al.getParent();
                ((CompartmentAlias)ca).addAlias(al);
            } else if (al.getParent() instanceof ComplexAlias) {
                ca = (ComplexAlias)al.getParent();
                ((ComplexAlias)ca).addAlias(al);
            } else {
                throw new InvalidArgumentException("Unknown type of alias parent: " + al.getParent().getClass().getName());
            }
        }
    }

    @Override
    public String getMapVersion() {
        return this.modelData.getMapVersion();
    }

    @Override
    public void setMapVersion(String version) {
        this.modelData.setMapVersion(version);
    }

    @Override
    public Double getWidth() {
        return this.modelData.getWidth();
    }

    @Override
    public void setWidth(Double width) {
        this.modelData.setWidth(width);
    }

    @Override
    public Double getHeight() {
        return this.modelData.getHeight();
    }

    @Override
    public void setHeight(Double height) {
        this.modelData.setHeight(height);
    }

    @Override
    public void setWidth(String text) {
        this.modelData.setWidth(Double.parseDouble(text));
    }

    @Override
    public void setHeight(String text) {
        this.modelData.setHeight(Double.parseDouble(text));
    }

    @Override
    public List<SpeciesAlias> getAliasesBySpeciesId(String speciesId) {
        List<SpeciesAlias> result = this.aliasBySpeciesId.get(speciesId);
        if (result == null) {
            result = new ArrayList<SpeciesAlias>();
        }
        return result;
    }

    @Override
    public Set<Alias> getAliases() {
        return this.modelData.getAliases();
    }

    @Override
    public Alias getAliasByAliasId(String idAlias) {
        return this.aliasByAliasId.get(idAlias);
    }

    @Override
    public void addReaction(Reaction reaction) {
        this.modelData.addReaction(reaction);
        this.reactionByReactionId.put(reaction.getIdReaction(), reaction);
        this.reactionByDbId.put(reaction.getId(), reaction);
    }

    @Override
    public Species getSpeciesBySpeciesId(String speciesId) {
        return this.speciesBySpeciesId.get(speciesId);
    }

    @Override
    public Set<Reaction> getReactions() {
        return this.modelData.getReactions();
    }

    @Override
    public void addCompartmentAlias(CompartmentAlias al) {
        this.modelData.addAlias(al);
        CompartmentAlias alias2 = (CompartmentAlias)this.aliasByAliasId.get(al.getAliasId());
        if (alias2 != null) {
            throw new InvalidArgumentException("Try to add CompartmentAlias with duplicated alias id: " + al.getAliasId());
        }
        this.aliasByAliasId.put(al.getAliasId(), al);
        this.aliasByDbId.put(al.getId(), al);
        if (!(al instanceof ArtifitialCompartmentAlias)) {
            String compartmentId = null;
            if (al.getCompartment() == null) {
                throw new InvalidArgumentException("Alias " + al.getAliasId() + " does not have compartment id");
            }
            compartmentId = al.getCompartment().getCompartmentId();
            List<CompartmentAlias> list = this.compartmentsAliasByCompartmentId.get(compartmentId);
            if (list == null) {
                list = new ArrayList<CompartmentAlias>();
                this.compartmentsAliasByCompartmentId.put(compartmentId, list);
            }
            list.add(al);
        }
    }

    @Override
    public CompartmentAlias getCompartmentAliasByCompartmentAliasId(String id) {
        return (CompartmentAlias)this.aliasByAliasId.get(id);
    }

    @Override
    public List<CompartmentAlias> getCompartmentsAliases() {
        ArrayList<CompartmentAlias> result = new ArrayList<CompartmentAlias>();
        for (Alias alias : this.modelData.getAliases()) {
            if (!(alias instanceof CompartmentAlias)) continue;
            result.add((CompartmentAlias)alias);
        }
        return result;
    }

    @Override
    public List<CompartmentAlias> getCompartmentsAliasByCompartmentId(String id) {
        List<CompartmentAlias> list = this.compartmentsAliasByCompartmentId.get(id);
        if (list == null) {
            list = new ArrayList<CompartmentAlias>();
        }
        return list;
    }

    @Override
    public void addLayer(Layer layer) {
        this.modelData.addLayer(layer);
    }

    @Override
    public Set<Layer> getLayers() {
        return this.modelData.getLayers();
    }

    @Override
    public Compartment getCompartmentByCompartmentId(String id) {
        return this.compartmentByCompartmentId.get(id);
    }

    @Override
    public void addAliases(List<? extends Alias> aliases) {
        for (Alias alias : aliases) {
            if (alias instanceof SpeciesAlias) {
                this.addAlias((SpeciesAlias)alias);
                continue;
            }
            throw new InvalidArgumentException("Invalid class type of alias list: " + alias.getClass().getName());
        }
    }

    @Override
    public void addCompartmentAliases(List<CompartmentAlias> aliases) {
        for (CompartmentAlias alias : aliases) {
            this.addCompartmentAlias(alias);
        }
    }

    @Override
    public void addCompartment(Compartment compartment) {
        this.modelData.addElement(compartment);
        this.compartmentByCompartmentId.put(compartment.getCompartmentId(), compartment);
    }

    @Override
    public void setNotes(String notes) {
        if (notes != null && notes.contains("<html")) {
            throw new InvalidArgumentException("notes cannot contain <html> tag");
        }
        this.modelData.setNotes(notes);
    }

    @Override
    public String getNotes() {
        return this.modelData.getNotes();
    }

    @Override
    public Set<Element> getElements() {
        return this.modelData.getElements();
    }

    @Override
    public void setElements(Set<Element> elements) {
        this.modelData.setElements(elements);
    }

    @Override
    public void setAliases(Set<Alias> aliases) {
        this.modelData.setAliases(aliases);
    }

    @Override
    public Reaction getReactionByReactionId(String idReaction) {
        return this.reactionByReactionId.get(idReaction);
    }

    @Override
    public Project getProject() {
        return this.modelData.getProject();
    }

    @Override
    public void setProject(Project project) {
        this.modelData.setProject(project);
    }

    @Override
    public List<Alias> getAliasesSortedBySize() {
        ArrayList<Alias> sortedAliases = new ArrayList<Alias>();
        sortedAliases.addAll(this.getAliases());
        Collections.sort(sortedAliases, Alias.SIZE_COMPARATOR);
        return sortedAliases;
    }

    @Override
    public List<CompartmentAlias> getSortedCompartmentsAliases() {
        List<CompartmentAlias> result = this.getCompartmentsAliases();
        Collections.sort(result, Alias.SIZE_COMPARATOR);
        return result;
    }

    @Override
    public void removeCompartmentAlias(CompartmentAlias alias) {
        this.modelData.removeAlias(alias);
        this.aliasByAliasId.remove(alias.getAliasId());
        this.aliasByDbId.remove(alias.getId());
        if (alias.getCompartment() != null) {
            this.compartmentsAliasByCompartmentId.remove(alias.getCompartment().getCompartmentId());
        }
        for (CompartmentAlias ca : this.getCompartmentsAliases()) {
            ca.getAliases().remove(alias);
        }
    }

    @Override
    public Reaction getReactionByDbId(Integer dbId) {
        return this.reactionByDbId.get(dbId);
    }

    @Override
    public Alias getAliasByDbId(Integer dbId) {
        return this.aliasByDbId.get(dbId);
    }

    @Override
    public Calendar getCreationDate() {
        return this.modelData.getCreationDate();
    }

    @Override
    public void setCreationDate(Calendar creationDate) {
        this.modelData.setCreationDate(creationDate);
    }

    @Override
    public List<Layout> getLayouts() {
        return this.modelData.getLayouts();
    }

    @Override
    public void setLayouts(List<Layout> layouts) {
        this.modelData.setLayouts(layouts);
    }

    @Override
    public void addLayout(Layout layout) {
        this.modelData.addLayout(layout);
    }

    @Override
    public void setWidth(int width) {
        this.setWidth(Double.valueOf(width));
    }

    @Override
    public void setHeight(int height) {
        this.setHeight(Double.valueOf(height));
    }

    @Override
    public List<Species> getSpeciesByName(String name) {
        ArrayList<Species> result = new ArrayList<Species>();
        for (Element element : this.getElements()) {
            if (!(element instanceof Species) || !((Species)element).getName().equalsIgnoreCase(name)) continue;
            result.add((Species)element);
        }
        return result;
    }

    @Override
    public Set<Element> getElementsByAnnotation(MiriamData miriamData) {
        HashSet<Element> result = new HashSet<Element>();
        for (Element element : this.getElements()) {
            for (MiriamData md : element.getMiriamData()) {
                if (!md.equals(miriamData)) continue;
                result.add(element);
            }
        }
        return result;
    }

    @Override
    public void addReactions(List<Reaction> reactions2) {
        for (Reaction reaction : reactions2) {
            this.addReaction(reaction);
        }
    }

    @Override
    public void addCompartments(List<Compartment> compartments) {
        for (Compartment compartment : compartments) {
            this.addCompartment(compartment);
        }
    }

    @Override
    public Collection<ComplexAlias> getComplexAliases() {
        ArrayList<ComplexAlias> result = new ArrayList<ComplexAlias>();
        for (Alias alias : this.modelData.getAliases()) {
            if (!(alias instanceof ComplexAlias)) continue;
            result.add((ComplexAlias)alias);
        }
        return result;
    }

    @Override
    public Collection<SpeciesAlias> getSpeciesAliases() {
        ArrayList<SpeciesAlias> result = new ArrayList<SpeciesAlias>();
        for (Alias alias : this.modelData.getAliases()) {
            if (!(alias instanceof SpeciesAlias) || alias instanceof ComplexAlias) continue;
            result.add((SpeciesAlias)alias);
        }
        return result;
    }

    @Override
    public void addLayers(Collection<Layer> layers) {
        for (Layer layer : layers) {
            this.addLayer(layer);
        }
    }

    @Override
    public Collection<Compartment> getCompartments() {
        ArrayList<Compartment> result = new ArrayList<Compartment>();
        for (Element element : this.modelData.getElements()) {
            if (!(element instanceof Compartment)) continue;
            result.add((Compartment)element);
        }
        return result;
    }

    @Override
    public Collection<Species> getSpecies() {
        ArrayList<Species> speciesList = new ArrayList<Species>();
        for (Element element : this.getElements()) {
            if (!(element instanceof Species)) continue;
            speciesList.add((Species)element);
        }
        return speciesList;
    }

    @Override
    public List<Alias> getSortedAliases() {
        ArrayList<Alias> result = new ArrayList<Alias>();
        result.addAll(this.getAliases());
        Collections.sort(result, Alias.SIZE_COMPARATOR);
        return result;
    }

    @Override
    public List<Reaction> getSortedReactions() {
        ArrayList<Reaction> result = new ArrayList<Reaction>();
        result.addAll(this.getReactions());
        Collections.sort(result, Reaction.ID_COMPARATOR);
        return result;
    }

    public void removeLayout(Layout dbLayout) {
        this.modelData.removeLayout(dbLayout);
    }

    @Override
    public void addAliasGroup(AliasGroup aliasGroup) {
        this.modelData.addAliasGroup(aliasGroup);
    }

    @Override
    public void addBlockDiagream(BlockDiagram blockDiagram) {
        this.modelData.addBlockDiagream(blockDiagram);
    }

    @Override
    public void removeAlias(Alias alias) {
        this.modelData.removeAlias(alias);
        this.aliasByAliasId.remove(alias.getAliasId());
        this.aliasByDbId.remove(alias.getId());
        if (alias.getParent() != null) {
            Alias ca;
            if (alias.getParent() instanceof CompartmentAlias) {
                ca = (CompartmentAlias)alias.getParent();
                ((CompartmentAlias)ca).removeAlias(alias);
            } else if (alias.getParent() instanceof ComplexAlias) {
                ca = (ComplexAlias)alias.getParent();
                ((ComplexAlias)ca).removeAlias((SpeciesAlias)alias);
            } else {
                throw new InvalidArgumentException("Unknown type of alias parent: " + alias.getParent().getClass().getName());
            }
        }
        if (alias instanceof SpeciesAlias) {
            Alias ca;
            SpeciesAlias al = (SpeciesAlias)alias;
            String idSpecies = al.getSpecies().getIdSpecies();
            List<SpeciesAlias> list = this.aliasBySpeciesId.get(idSpecies);
            if (list != null) {
                list.remove(al);
            }
            if (alias.getCompartmentAlias() != null) {
                ca = alias.getCompartmentAlias();
                ((CompartmentAlias)ca).removeAlias(alias);
            }
            if (al.getComplexAlias() != null) {
                ca = ((SpeciesAlias)alias).getComplexAlias();
                ((ComplexAlias)ca).removeAlias(al);
            }
        } else if (alias instanceof CompartmentAlias) {
            if (!(alias instanceof ArtifitialCompartmentAlias)) {
                String compartmentId = null;
                compartmentId = ((Compartment)alias.getElement()).getCompartmentId();
                List<CompartmentAlias> list = this.compartmentsAliasByCompartmentId.get(compartmentId);
                if (list != null) {
                    list.remove(alias);
                }
            }
        } else {
            throw new InvalidArgumentException("Class not supported: " + alias.getClass());
        }
    }

    @Override
    public void removeElement(Element element) {
        this.modelData.removeElement(element);
        if (element instanceof Compartment) {
            Compartment compartment = (Compartment)element;
            this.compartmentByCompartmentId.put(compartment.getCompartmentId(), compartment);
        } else if (element instanceof Species) {
            Species sp = (Species)element;
            this.speciesBySpeciesId.remove(sp.getIdSpecies());
            this.aliasBySpeciesId.remove(sp.getIdSpecies());
        } else {
            throw new InvalidArgumentException("Class not supported: " + element.getClass());
        }
    }

    @Override
    public void removeReaction(Reaction reaction) {
        this.modelData.removeReaction(reaction);
        this.reactionByReactionId.remove(reaction.getIdReaction());
        this.reactionByDbId.remove(reaction.getId());
    }

    @Override
    public Collection<Alias> getAliasesForElement(Element element) {
        ArrayList<Alias> result = new ArrayList<Alias>();
        if (element instanceof Species) {
            List<SpeciesAlias> tmp = this.aliasBySpeciesId.get(((Species)element).getIdSpecies());
            if (tmp != null) {
                result.addAll(tmp);
            }
        } else if (element instanceof Compartment) {
            List<CompartmentAlias> tmp = this.compartmentsAliasByCompartmentId.get(((Compartment)element).getCompartmentId());
            if (tmp != null) {
                result.addAll(tmp);
            }
        } else {
            throw new InvalidArgumentException();
        }
        return result;
    }

    @Override
    public int getZoomLevels() {
        return this.modelData.getZoomLevels();
    }

    @Override
    public void setZoomLevels(int zoomLevels) {
        this.modelData.setZoomLevels(zoomLevels);
    }

    @Override
    public int getTileSize() {
        return this.modelData.getTileSize();
    }

    @Override
    public void setTileSize(int tileSize) {
        this.modelData.setTileSize(tileSize);
    }

    @Override
    public String getMetaId() {
        return this.modelData.getMetaId();
    }

    @Override
    public void setMetaId(String metaId) {
        this.modelData.setMetaId(metaId);
    }

    @Override
    public String getIdModel() {
        return this.modelData.getIdModel();
    }

    @Override
    public void setIdModel(String idModel) {
        this.modelData.setIdModel(idModel);
    }

    @Override
    public String getNotifyEmail() {
        return this.modelData.getNotifyEmail();
    }

    @Override
    public void setNotifyEmail(String notifyEmail) {
        this.modelData.setNotifyEmail(notifyEmail);
    }

    @Override
    public void addCreationWarning(String warning) {
        this.modelData.addCreationWarning(warning);
    }

    @Override
    public List<String> getCreationWarnings() {
        return this.modelData.getCreationWarnings();
    }

    @Override
    public void addCreationWarnings(List<String> warnings) {
        this.modelData.addCreationWarnings(warnings);
    }

    @Override
    public void addElement(Element element) {
        if (element instanceof Species) {
            this.addSpecies((Species)element);
        } else if (element instanceof Compartment) {
            this.addCompartment((Compartment)element);
        } else {
            throw new InvalidArgumentException("Unknown class type: " + element.getClass());
        }
    }

    @Override
    public void addSpecies(Species species) {
        if (species.getIdSpecies().equals("")) {
            throw new InvalidArgumentException("Species cannot contain empty id (class: " + species.getClass().getName() + ")");
        }
        if (this.speciesBySpeciesId.get(species.getIdSpecies()) != null) {
            throw new InvalidArgumentException("Species with given id (" + species.getIdSpecies() + ") already exist in model");
        }
        this.modelData.addElement(species);
        this.speciesBySpeciesId.put(species.getIdSpecies(), species);
        List<SpeciesAlias> aliasList = this.getAliasesBySpeciesId(species.getIdSpecies());
        if (aliasList != null) {
            for (SpeciesAlias alias2 : aliasList) {
                alias2.setSpecies(species);
            }
        }
    }

    @Override
    public ModelData getModelData() {
        return this.modelData;
    }

    @Override
    public Integer getId() {
        return this.modelData.getId();
    }

    @Override
    public void addSubmodelConnection(ModelSubmodelConnection submodel) {
        this.modelData.addSubmodel(submodel);
        submodel.setParentModel(this);
    }

    @Override
    public Collection<ModelSubmodelConnection> getSubmodelConnections() {
        return this.modelData.getSubmodels();
    }

    @Override
    public String getName() {
        return this.modelData.getName();
    }

    @Override
    public void setName(String name) {
        this.modelData.setName(name);
    }

    @Override
    public Model getSubmodelById(Integer id) {
        if (id == null) {
            return null;
        }
        if (id.equals(this.getId())) {
            return this;
        }
        SubmodelConnection connection = this.getSubmodelConnectionById(id);
        if (connection != null) {
            return connection.getSubmodel().getModel();
        }
        return null;
    }

    @Override
    public Collection<SubmodelConnection> getParentModels() {
        return this.modelData.getParentModels();
    }

    @Override
    public Model getSubmodelByConnectionName(String name) {
        if (name == null) {
            return null;
        }
        for (ModelSubmodelConnection connection : this.getSubmodelConnections()) {
            if (!name.equals(connection.getName())) continue;
            return connection.getSubmodel().getModel();
        }
        return null;
    }

    @Override
    public SubmodelConnection getSubmodelConnectionById(Integer id) {
        for (ModelSubmodelConnection connection : this.getSubmodelConnections()) {
            if (!id.equals(connection.getSubmodel().getId())) continue;
            return connection;
        }
        return null;
    }

    @Override
    public Collection<Compartment> getCompartmentsByCompartmentName(String string) {
        ArrayList<Compartment> result = new ArrayList<Compartment>();
        for (Compartment compartment : this.getCompartments()) {
            if (!compartment.getName().equals(string)) continue;
            result.add(compartment);
        }
        return result;
    }

    @Override
    public Model getSubmodelById(String identifier) {
        if (identifier == null) {
            return null;
        }
        Integer id = Integer.parseInt(identifier);
        for (ModelSubmodelConnection connection : this.getSubmodelConnections()) {
            if (!id.equals(connection.getSubmodel().getId())) continue;
            return connection.getSubmodel().getModel();
        }
        if (id.equals(this.getId())) {
            return this;
        }
        return null;
    }

    @Override
    public Collection<Model> getSubmodels() {
        ArrayList<Model> models = new ArrayList<Model>();
        for (ModelSubmodelConnection connection : this.getSubmodelConnections()) {
            models.add(connection.getSubmodel().getModel());
        }
        return models;
    }

    @Override
    public Model getSubmodelByName(String name) {
        if (name == null) {
            return null;
        }
        for (ModelSubmodelConnection connection : this.getSubmodelConnections()) {
            if (!name.equals(connection.getSubmodel().getName())) continue;
            return connection.getSubmodel().getModel();
        }
        if (name.equals(this.getName())) {
            return this;
        }
        return null;
    }
}

