/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.map.model;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlTransient;
import lcsb.mapviewer.common.exception.InvalidArgumentException;
import lcsb.mapviewer.model.Project;
import lcsb.mapviewer.model.map.Element;
import lcsb.mapviewer.model.map.layout.Layout;
import lcsb.mapviewer.model.map.layout.alias.Alias;
import lcsb.mapviewer.model.map.layout.alias.AliasGroup;
import lcsb.mapviewer.model.map.layout.alias.BlockDiagram;
import lcsb.mapviewer.model.map.layout.graphics.Layer;
import lcsb.mapviewer.model.map.model.Model;
import lcsb.mapviewer.model.map.model.ModelSubmodelConnection;
import lcsb.mapviewer.model.map.model.SubmodelConnection;
import lcsb.mapviewer.model.map.reaction.Reaction;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="model_table")
public class ModelData {
    private static Logger logger = Logger.getLogger(ModelData.class);
    @Cascade(value={CascadeType.ALL})
    @OneToMany(mappedBy="model", orphanRemoval=true)
    private Set<Alias> aliases = new HashSet<Alias>();
    @Cascade(value={CascadeType.ALL})
    @OneToMany(mappedBy="model", orphanRemoval=true)
    private Set<Element> elements = new HashSet<Element>();
    @Cascade(value={CascadeType.ALL})
    @OneToMany(mappedBy="model", orphanRemoval=true)
    private Set<Layer> layers = new HashSet<Layer>();
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="idDb", unique=true, nullable=false)
    private int id;
    @Cascade(value={CascadeType.ALL})
    @OneToMany(mappedBy="model", orphanRemoval=true)
    private Set<Reaction> reactions = new HashSet<Reaction>();
    private String mapVersion = "";
    private Calendar creationDate = Calendar.getInstance();
    private Double width;
    private Double height;
    @Column(name="notes", columnDefinition="TEXT")
    private String notes;
    private String name;
    private String metaId;
    private String idModel;
    private String notifyEmail;
    @Column(columnDefinition="TEXT")
    private String creationWarnings;
    private int zoomLevels;
    private int tileSize;
    @Cascade(value={CascadeType.ALL})
    @OneToMany(fetch=FetchType.EAGER, mappedBy="model", orphanRemoval=true)
    @OrderBy(value="id")
    private List<Layout> layouts = new ArrayList<Layout>();
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private Project project;
    @Transient
    @XmlTransient
    private Model model;
    @Cascade(value={CascadeType.ALL})
    @OneToMany(fetch=FetchType.EAGER, mappedBy="parentModel", orphanRemoval=true)
    private Set<ModelSubmodelConnection> submodels = new HashSet<ModelSubmodelConnection>();
    @Cascade(value={CascadeType.ALL})
    @OneToMany(fetch=FetchType.LAZY, mappedBy="submodel")
    private Set<SubmodelConnection> parentModels = new HashSet<SubmodelConnection>();

    public void addAlias(Alias al) {
        al.setModelData(this);
        this.aliases.add(al);
    }

    public void addReaction(Reaction reaction) {
        reaction.setModelData(this);
        this.reactions.add(reaction);
    }

    public void addLayer(Layer layer) {
        layer.setModel(this);
        this.layers.add(layer);
    }

    public void addAliases(List<? extends Alias> aliases) {
        for (Alias alias : aliases) {
            this.addAlias(alias);
        }
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Set<Element> getElements() {
        return this.elements;
    }

    public void setElements(Set<Element> elements) {
        this.elements = elements;
    }

    public void setAliases(Set<Alias> aliases) {
        this.aliases = aliases;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public Calendar getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Calendar creationDate) {
        this.creationDate = creationDate;
    }

    public List<Layout> getLayouts() {
        return this.layouts;
    }

    public void setLayouts(List<Layout> layouts) {
        this.layouts = layouts;
    }

    public void addLayout(Layout layout) {
        this.layouts.add(layout);
        layout.setModel(this);
    }

    public void setWidth(int width) {
        this.setWidth(Double.valueOf(width));
    }

    public void setHeight(int height) {
        this.setHeight(Double.valueOf(height));
    }

    public void addReactions(List<Reaction> reactions2) {
        for (Reaction reaction : reactions2) {
            this.addReaction(reaction);
        }
    }

    public void addLayers(Collection<Layer> layers) {
        for (Layer layer : layers) {
            this.addLayer(layer);
        }
    }

    public void removeLayout(Layout dbLayout) {
        ArrayList<Layout> toRemove = new ArrayList<Layout>();
        for (Layout layout : this.layouts) {
            if (layout.getId() != dbLayout.getId()) continue;
            toRemove.add(layout);
        }
        if (toRemove.size() == 0) {
            logger.warn("Cannot remove layout: " + dbLayout.getId());
        } else {
            this.layouts.removeAll(toRemove);
        }
    }

    public void addAliasGroup(AliasGroup aliasGroup) {
    }

    public void addBlockDiagream(BlockDiagram blockDiagram) {
    }

    public void removeAlias(Alias alias) {
        if (!this.aliases.contains(alias)) {
            logger.warn("Alias doesn't exist in the map: " + alias.getAliasId());
            return;
        }
        alias.setModelData(null);
        this.aliases.remove(alias);
    }

    public void removeElement(Element element) {
        if (!this.elements.contains(element)) {
            logger.warn("Model doesn't contain element: " + element.getName());
            return;
        }
        this.elements.remove(element);
        element.setModelData(null);
    }

    public void removeReaction(Reaction reaction) {
        if (!this.reactions.contains(reaction)) {
            logger.warn("Reaction doesn't exist in the model: " + reaction.getIdReaction());
            return;
        }
        reaction.setModelData(null);
        this.reactions.remove(reaction);
    }

    public int getZoomLevels() {
        return this.zoomLevels;
    }

    public void setZoomLevels(int zoomLevels) {
        this.zoomLevels = zoomLevels;
    }

    public int getTileSize() {
        return this.tileSize;
    }

    public void setTileSize(int tileSize) {
        this.tileSize = tileSize;
    }

    public String getMetaId() {
        return this.metaId;
    }

    public void setMetaId(String metaId) {
        this.metaId = metaId;
    }

    public String getIdModel() {
        return this.idModel;
    }

    public void setIdModel(String idModel) {
        this.idModel = idModel;
    }

    public String getNotifyEmail() {
        return this.notifyEmail;
    }

    public void setNotifyEmail(String notifyEmail) {
        this.notifyEmail = notifyEmail;
    }

    public void addCreationWarning(String warning) {
        if (warning.trim().contains("\n")) {
            throw new InvalidArgumentException("Warning must be one line of text");
        }
        if (warning.trim().equals("")) {
            return;
        }
        this.creationWarnings = this.creationWarnings == null ? warning.trim() : this.creationWarnings + "\n" + warning.trim();
    }

    public List<String> getCreationWarnings() {
        String[] warnings;
        ArrayList<String> result = new ArrayList<String>();
        if (this.creationWarnings == null) {
            return result;
        }
        for (String string : warnings = this.creationWarnings.split("\n")) {
            result.add(string);
        }
        return result;
    }

    public void addCreationWarnings(List<String> warnings) {
        StringBuilder sb = new StringBuilder("");
        if (this.creationWarnings != null) {
            sb.append(this.creationWarnings);
        }
        for (String string : warnings) {
            if (string.trim().equals("")) continue;
            if (string.contains("\n")) {
                throw new InvalidArgumentException("Warning must be one line of text, but found:\n" + string);
            }
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(string.trim());
        }
        this.creationWarnings = sb.toString();
    }

    public void addElement(Element element) {
        this.elements.add(element);
        element.setModelData(this);
    }

    @XmlTransient
    public Model getModel() {
        if (this.model == null) {
            logger.warn("Model not set in model data.");
        }
        return this.model;
    }

    public void setModel(Model model) {
        this.model = model;
    }

    public Set<Alias> getAliases() {
        return this.aliases;
    }

    public Set<Layer> getLayers() {
        return this.layers;
    }

    public void setLayers(Set<Layer> layers) {
        this.layers = layers;
    }

    public Set<Reaction> getReactions() {
        return this.reactions;
    }

    public void setReactions(Set<Reaction> reactions) {
        this.reactions = reactions;
    }

    public String getMapVersion() {
        return this.mapVersion;
    }

    public void setMapVersion(String mapVersion) {
        this.mapVersion = mapVersion;
    }

    public Double getWidth() {
        return this.width;
    }

    public void setWidth(Double width) {
        this.width = width;
    }

    public Double getHeight() {
        return this.height;
    }

    public void setHeight(Double height) {
        this.height = height;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public void addSubmodel(ModelSubmodelConnection submodel) {
        this.submodels.add(submodel);
        submodel.setParentModel(this);
    }

    public Collection<ModelSubmodelConnection> getSubmodels() {
        return this.submodels;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<SubmodelConnection> getParentModels() {
        return this.parentModels;
    }

    public void setParentModels(Set<SubmodelConnection> parentModels) {
        this.parentModels = parentModels;
    }
}

