/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.map.model;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import lcsb.mapviewer.common.comparator.DoubleComparator;
import lcsb.mapviewer.common.comparator.IntegerComparator;
import lcsb.mapviewer.common.comparator.StringComparator;
import lcsb.mapviewer.common.exception.InvalidClassException;
import lcsb.mapviewer.model.map.Element;
import lcsb.mapviewer.model.map.ElementComparator;
import lcsb.mapviewer.model.map.agregator.Compartment;
import lcsb.mapviewer.model.map.layout.Layout;
import lcsb.mapviewer.model.map.layout.LayoutComparator;
import lcsb.mapviewer.model.map.layout.alias.Alias;
import lcsb.mapviewer.model.map.layout.alias.AliasComparator;
import lcsb.mapviewer.model.map.layout.graphics.Layer;
import lcsb.mapviewer.model.map.layout.graphics.LayerComparator;
import lcsb.mapviewer.model.map.model.Model;
import lcsb.mapviewer.model.map.model.ModelData;
import lcsb.mapviewer.model.map.model.ModelSubmodelConnection;
import lcsb.mapviewer.model.map.model.ModelSubmodelConnectionComparator;
import lcsb.mapviewer.model.map.reaction.Reaction;
import lcsb.mapviewer.model.map.reaction.ReactionComparator;
import lcsb.mapviewer.model.map.species.Species;
import org.apache.log4j.Logger;

public class ModelComparator
implements Comparator<Model> {
    private Logger logger = Logger.getLogger(ModelComparator.class);
    private double epsilon;

    public ModelComparator(double epsilon) {
        this.epsilon = epsilon;
    }

    public ModelComparator() {
        this(1.0E-6);
    }

    @Override
    public int compare(Model arg0, Model arg1) {
        if (arg0 == null) {
            if (arg1 == null) {
                return 0;
            }
            return 1;
        }
        if (arg1 == null) {
            return -1;
        }
        if (arg0.getClass().equals(arg1.getClass())) {
            if (arg0 instanceof Model) {
                return this.internalCompare(arg0, arg1);
            }
            throw new InvalidClassException("Don't know how to compare classes: " + arg0.getClass());
        }
        return -1;
    }

    private int internalCompare(Model arg0, Model arg1) {
        StringComparator stringComparator = new StringComparator();
        DoubleComparator doubleComparator = new DoubleComparator(this.epsilon);
        IntegerComparator integerComparator = new IntegerComparator();
        if (stringComparator.compare(arg0.getIdModel(), arg1.getIdModel()) != 0) {
            this.logger.debug("Id different: " + arg0.getIdModel() + ", " + arg1.getIdModel());
            return stringComparator.compare(arg0.getIdModel(), arg1.getIdModel());
        }
        if (stringComparator.compare(arg0.getName(), arg1.getName()) != 0) {
            this.logger.debug("Name different: " + arg0.getName() + ", " + arg1.getName());
            return stringComparator.compare(arg0.getName(), arg1.getName());
        }
        if (stringComparator.compare(arg0.getMetaId(), arg1.getMetaId()) != 0) {
            this.logger.debug("MetaId different: " + arg0.getMetaId() + ", " + arg1.getMetaId());
            return stringComparator.compare(arg0.getMetaId(), arg1.getMetaId());
        }
        if (stringComparator.compare(arg0.getMapVersion(), arg1.getMapVersion()) != 0) {
            this.logger.debug("Version different: " + arg0.getMapVersion() + ", " + arg1.getMapVersion());
            return stringComparator.compare(arg0.getMapVersion(), arg1.getMapVersion());
        }
        if (stringComparator.compare(arg0.getNotes(), arg1.getNotes(), true) != 0) {
            this.logger.debug(arg0.getNotes());
            this.logger.debug(arg1.getNotes());
            this.logger.debug("Notes different:\n" + arg0.getNotes() + "\n---\n" + arg1.getNotes() + "\n---");
            return stringComparator.compare(arg0.getNotes(), arg1.getNotes(), true);
        }
        if (doubleComparator.compare(arg0.getWidth(), arg1.getWidth()) != 0) {
            this.logger.debug("Width different: " + arg0.getWidth() + ", " + arg1.getWidth());
            return doubleComparator.compare(arg0.getWidth(), arg1.getWidth());
        }
        if (doubleComparator.compare(arg0.getHeight(), arg1.getHeight()) != 0) {
            this.logger.debug("Height different: " + arg0.getHeight() + ", " + arg1.getHeight());
            return doubleComparator.compare(arg0.getHeight(), arg1.getHeight());
        }
        if (integerComparator.compare(arg0.getZoomLevels(), arg1.getZoomLevels()) != 0) {
            this.logger.debug("Zoom levels different: " + arg0.getZoomLevels() + ", " + arg1.getZoomLevels());
            return integerComparator.compare(arg0.getZoomLevels(), arg1.getZoomLevels());
        }
        if (integerComparator.compare(arg0.getTileSize(), arg1.getTileSize()) != 0) {
            this.logger.debug("Tile size different: " + arg0.getTileSize() + ", " + arg1.getTileSize());
            return integerComparator.compare(arg0.getTileSize(), arg1.getTileSize());
        }
        int status = this.compareAliases(arg0.getAliases(), arg1.getAliases());
        if (status != 0) {
            this.logger.debug("Set of aliases different");
            return status;
        }
        status = this.compareLayers(arg0.getLayers(), arg1.getLayers());
        if (status != 0) {
            this.logger.debug("Set of layers different");
            return status;
        }
        status = this.compareElements(arg0.getElements(), arg1.getElements());
        if (status != 0) {
            this.logger.debug("Set of elements different");
            return status;
        }
        status = this.compareReaction(arg0.getReactions(), arg1.getReactions());
        if (status != 0) {
            this.logger.debug("Set of reactions different");
            return status;
        }
        status = this.compareLayouts(arg0.getLayouts(), arg1.getLayouts());
        if (status != 0) {
            this.logger.debug("Set of layouts different");
            return status;
        }
        status = this.compareSubmodels(arg0.getSubmodelConnections(), arg1.getSubmodelConnections());
        if (status != 0) {
            this.logger.debug("Set of submodels different");
            return status;
        }
        return 0;
    }

    private int compareReaction(Set<Reaction> reactions, Set<Reaction> reactions2) {
        int status;
        ReactionComparator comparator = new ReactionComparator(this.epsilon);
        HashMap<String, Reaction> map = new HashMap<String, Reaction>();
        HashMap<String, Reaction> map2 = new HashMap<String, Reaction>();
        for (Reaction reaction : reactions) {
            map.put(reaction.getIdReaction(), reaction);
        }
        for (Reaction reaction : reactions2) {
            map2.put(reaction.getIdReaction(), reaction);
        }
        for (Reaction reaction : reactions) {
            status = comparator.compare(reaction, (Reaction)map2.get(reaction.getIdReaction()));
            if (status == 0) continue;
            this.logger.debug("Different reaction " + reaction.getIdReaction() + ": " + map2.get(reaction.getIdReaction()));
            return status;
        }
        for (Reaction reaction : reactions2) {
            status = comparator.compare(reaction, (Reaction)map.get(reaction.getIdReaction()));
            if (status == 0) continue;
            this.logger.debug("Different reaction " + reaction.getIdReaction());
            return status;
        }
        return 0;
    }

    private int compareElements(Set<Element> elements, Set<Element> elements2) {
        int status;
        String id;
        ElementComparator comparator = new ElementComparator(this.epsilon);
        HashMap<String, Element> map = new HashMap<String, Element>();
        HashMap<String, Element> map2 = new HashMap<String, Element>();
        for (Element element : elements) {
            if (element instanceof Species) {
                map.put(((Species)element).getIdSpecies(), element);
                continue;
            }
            if (element instanceof Compartment) {
                map.put(((Compartment)element).getCompartmentId(), element);
                continue;
            }
            throw new InvalidClassException("Unknown class type...");
        }
        for (Element element : elements2) {
            if (element instanceof Species) {
                map2.put(((Species)element).getIdSpecies(), element);
                continue;
            }
            if (element instanceof Compartment) {
                map2.put(((Compartment)element).getCompartmentId(), element);
                continue;
            }
            throw new InvalidClassException("Unknown class type...");
        }
        for (Element element : elements) {
            id = "";
            if (element instanceof Species) {
                id = ((Species)element).getIdSpecies();
            } else if (element instanceof Compartment) {
                id = ((Compartment)element).getCompartmentId();
            }
            if ((status = comparator.compare(element, (Element)map2.get(id))) == 0) continue;
            this.logger.debug("Element with id " + id + " (" + element.getClass() + ") different");
            return status;
        }
        for (Element element : elements2) {
            id = "";
            if (element instanceof Species) {
                id = ((Species)element).getIdSpecies();
            } else if (element instanceof Compartment) {
                id = ((Compartment)element).getCompartmentId();
            }
            if ((status = comparator.compare(element, (Element)map.get(id))) == 0) continue;
            this.logger.debug("Element with id " + id + "(" + element.getClass() + ") different");
            return status;
        }
        return 0;
    }

    private int compareLayers(Set<Layer> layers, Set<Layer> layers2) {
        boolean found;
        LayerComparator layerComparator = new LayerComparator(this.epsilon);
        for (Layer layer : layers) {
            found = false;
            for (Layer layer2 : layers2) {
                if (layerComparator.compare(layer, layer2) != 0) continue;
                found = true;
            }
            if (found) continue;
            return 1;
        }
        for (Layer layer : layers2) {
            found = false;
            for (Layer layer2 : layers) {
                if (layerComparator.compare(layer, layer2) != 0) continue;
                found = true;
            }
            if (found) continue;
            return -1;
        }
        return 0;
    }

    private int compareLayouts(List<Layout> layouts, List<Layout> layouts2) {
        boolean found;
        LayoutComparator layoutComparator = new LayoutComparator(this.epsilon);
        for (Layout layout : layouts) {
            found = false;
            for (Layout layout2 : layouts2) {
                if (layoutComparator.compare(layout, layout2) != 0) continue;
                found = true;
            }
            if (found) continue;
            return 1;
        }
        for (Layout layout : layouts2) {
            found = false;
            for (Layout layout2 : layouts) {
                if (layoutComparator.compare(layout, layout2) != 0) continue;
                found = true;
            }
            if (found) continue;
            return -1;
        }
        return 0;
    }

    private int compareAliases(Set<Alias> aliases, Set<Alias> aliases2) {
        int status;
        AliasComparator aliasComparator = new AliasComparator(this.epsilon);
        HashMap<String, Alias> map1 = new HashMap<String, Alias>();
        HashMap<String, Alias> map2 = new HashMap<String, Alias>();
        if (aliases.size() != aliases2.size()) {
            this.logger.debug("Number of aliases different: " + aliases.size() + ", " + aliases2.size());
            return Integer.valueOf(aliases.size()).compareTo(aliases2.size());
        }
        for (Alias alias : aliases) {
            map1.put(alias.getAliasId(), alias);
        }
        for (Alias alias : aliases2) {
            map2.put(alias.getAliasId(), alias);
        }
        for (Alias alias : aliases) {
            status = aliasComparator.compare(alias, (Alias)map2.get(alias.getAliasId()));
            if (status == 0) continue;
            this.logger.debug("Alias doesn't have a match: " + alias.getAliasId() + ", " + map2.get(alias.getAliasId()));
            return status;
        }
        for (Alias alias : aliases2) {
            status = aliasComparator.compare(alias, (Alias)map1.get(alias.getAliasId()));
            if (status == 0) continue;
            this.logger.debug("Alias doesn't have a match: " + alias.getAliasId() + ", " + map2.get(alias.getAliasId()));
            return status;
        }
        return 0;
    }

    private int compareSubmodels(Collection<ModelSubmodelConnection> collection1, Collection<ModelSubmodelConnection> collection2) {
        ModelData parent2;
        ModelData parent1;
        boolean found;
        IntegerComparator integerComparator = new IntegerComparator();
        if (integerComparator.compare(collection1.size(), collection2.size()) != 0) {
            this.logger.debug("collection of submodels doesn't match: " + collection1.size() + ", " + collection2.size());
            return integerComparator.compare(collection1.size(), collection2.size());
        }
        ModelSubmodelConnectionComparator comparator = new ModelSubmodelConnectionComparator(this.epsilon);
        for (ModelSubmodelConnection submodel1 : collection1) {
            found = false;
            for (ModelSubmodelConnection submodel2 : collection2) {
                parent1 = submodel1.getParentModel();
                submodel1.setParentModel((ModelData)null);
                parent2 = submodel2.getParentModel();
                submodel2.setParentModel((ModelData)null);
                if (comparator.compare(submodel1, submodel2) == 0) {
                    found = true;
                }
                submodel1.setParentModel(parent1);
                submodel2.setParentModel(parent2);
                if (!found) continue;
                break;
            }
            if (found) continue;
            this.logger.debug("collection of submodels doesn't match. " + submodel1 + " cannot be found in the second model");
            return 1;
        }
        for (ModelSubmodelConnection submodel1 : collection2) {
            found = false;
            for (ModelSubmodelConnection submodel2 : collection1) {
                parent1 = submodel1.getParentModel();
                submodel1.setParentModel((ModelData)null);
                parent2 = submodel2.getParentModel();
                submodel2.setParentModel((ModelData)null);
                if (comparator.compare(submodel1, submodel2) == 0) {
                    found = true;
                }
                submodel1.setParentModel(parent1);
                submodel2.setParentModel(parent2);
                if (!found) continue;
                break;
            }
            if (found) continue;
            this.logger.debug("collection of submodels doesn't match. " + submodel1 + " cannot be found in the first model");
            return -1;
        }
        return 0;
    }
}

