/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.map.model;

import java.util.Comparator;
import lcsb.mapviewer.model.map.layout.alias.Alias;
import lcsb.mapviewer.model.map.layout.alias.AliasComparator;
import lcsb.mapviewer.model.map.model.AliasSubmodelConnection;
import lcsb.mapviewer.model.map.model.SubmodelConnectionComparator;
import org.apache.log4j.Logger;

public class AliasSubmodelConnectionComparator
implements Comparator<AliasSubmodelConnection> {
    private static Logger logger = Logger.getLogger(AliasSubmodelConnectionComparator.class);
    private double epsilon;

    public AliasSubmodelConnectionComparator(double epsilon) {
        this.epsilon = epsilon;
    }

    public AliasSubmodelConnectionComparator() {
        this(1.0E-6);
    }

    @Override
    public int compare(AliasSubmodelConnection arg0, AliasSubmodelConnection arg1) {
        if (arg0 == null) {
            if (arg1 == null) {
                return 0;
            }
            return 1;
        }
        if (arg1 == null) {
            return -1;
        }
        if (arg0.getClass().equals(arg1.getClass())) {
            return this.internalCompare(arg0, arg1);
        }
        logger.debug("class different: " + arg0.getClass() + ", " + arg1.getClass());
        return -1;
    }

    public int internalCompare(AliasSubmodelConnection arg0, AliasSubmodelConnection arg1) {
        SubmodelConnectionComparator superComparator = new SubmodelConnectionComparator(this.epsilon);
        int result = superComparator.internalCompare(arg0, arg1);
        if (result != 0) {
            return result;
        }
        AliasComparator aliasComparator = new AliasComparator(this.epsilon);
        Alias alias1 = arg0.getFromAlias();
        Alias alias2 = arg1.getFromAlias();
        arg0.setFromAlias(null);
        arg1.setFromAlias(null);
        int status = aliasComparator.compare(alias1, alias2);
        arg0.setFromAlias(alias1);
        arg1.setFromAlias(alias2);
        if (status != 0) {
            logger.debug("from alias different: " + arg0.getFromAlias() + ", " + arg1.getFromAlias());
            return status;
        }
        alias1 = arg0.getToAlias();
        alias2 = arg1.getToAlias();
        arg0.setToAlias(null);
        arg1.setToAlias(null);
        status = aliasComparator.compare(alias1, alias2);
        arg0.setToAlias(alias1);
        arg1.setToAlias(alias2);
        if (status != 0) {
            logger.debug("to alias different: " + arg0.getToAlias() + ", " + arg1.getToAlias());
            return status;
        }
        return 0;
    }
}

