/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.map.layout.alias;

import java.awt.geom.Point2D;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import lcsb.mapviewer.common.exception.InvalidStateException;
import lcsb.mapviewer.model.map.layout.alias.Alias;
import lcsb.mapviewer.model.map.layout.alias.ComplexAlias;
import lcsb.mapviewer.model.map.reaction.ReactionNode;
import lcsb.mapviewer.model.map.species.Species;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@DiscriminatorValue(value="Species Alias")
public class SpeciesAlias
extends Alias {
    private static Logger logger = Logger.getLogger(SpeciesAlias.class);
    private Boolean activity;
    private Double lineWidth;
    private String state;
    @ManyToOne
    @Cascade(value={CascadeType.ALL})
    @JoinColumn(name="idComplexAliasDb")
    private ComplexAlias complexAlias;
    @Cascade(value={CascadeType.ALL})
    @OneToMany(fetch=FetchType.EAGER, mappedBy="alias", orphanRemoval=true)
    private Set<ReactionNode> node = new HashSet<ReactionNode>();

    public SpeciesAlias(String aliasId) {
        this();
        this.setAliasId(aliasId);
    }

    public SpeciesAlias() {
        this.activity = false;
        this.lineWidth = 1.0;
        this.state = "usual";
    }

    public SpeciesAlias(Species species) {
        this();
        this.setSpecies(species);
    }

    public SpeciesAlias(SpeciesAlias alias) {
        super(alias);
        this.setSpecies(alias.getSpecies());
        this.activity = alias.getActivity();
        this.lineWidth = alias.getLineWidth();
        this.state = alias.getState();
        this.complexAlias = alias.getComplexAlias();
    }

    @Override
    public boolean contains(Point2D point) {
        return this.getX() <= point.getX() && this.getX() + this.getWidth() >= point.getX() && this.getY() <= point.getY() && this.getY() + this.getHeight() >= point.getY();
    }

    @Override
    public SpeciesAlias copy() {
        if (this.getClass() == SpeciesAlias.class) {
            return new SpeciesAlias(this);
        }
        throw new InvalidStateException("Method copy() should be overriden in class " + this.getClass());
    }

    public Species getSpecies() {
        return (Species)this.getElement();
    }

    public void setSpecies(Species species) {
        this.setElement(species);
    }

    public Boolean getActivity() {
        return this.activity;
    }

    public void setActivity(Boolean activity) {
        this.activity = activity;
    }

    public Double getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(Double lineWidth) {
        this.lineWidth = lineWidth;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public ComplexAlias getComplexAlias() {
        return this.complexAlias;
    }

    public void setComplexAlias(ComplexAlias complexAlias) {
        this.complexAlias = complexAlias;
    }

    public Set<ReactionNode> getNode() {
        return this.node;
    }

    public void setNode(Set<ReactionNode> node) {
        this.node = node;
    }
}

