/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.map.layout.alias;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlTransient;
import lcsb.mapviewer.model.map.Element;
import lcsb.mapviewer.model.map.layout.alias.CompartmentAlias;
import lcsb.mapviewer.model.map.layout.alias.SearchIndex;
import lcsb.mapviewer.model.map.layout.alias.SpeciesAlias;
import lcsb.mapviewer.model.map.model.AliasSubmodelConnection;
import lcsb.mapviewer.model.map.model.Model;
import lcsb.mapviewer.model.map.model.ModelData;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="alias_table")
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name="alias_type_db", discriminatorType=DiscriminatorType.STRING)
@DiscriminatorValue(value="GENERIC_ALIAS")
public abstract class Alias {
    private static final double DEFAULT_FONT_SIZE = 12.0;
    public static final Comparator<Alias> SIZE_COMPARATOR = new Comparator<Alias>(){

        @Override
        public int compare(Alias alias1, Alias alias2) {
            double size2;
            double size = alias1.getWidth() * alias1.getHeight();
            if (size < (size2 = alias2.getWidth() * alias2.getHeight())) {
                return 1;
            }
            if (size > size2) {
                return -1;
            }
            return 0;
        }
    };
    private static Logger logger = Logger.getLogger(Alias.class);
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="idDb", unique=true, nullable=false)
    private int id;
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE})
    @ManyToOne
    private Alias parent;
    @ManyToOne(fetch=FetchType.LAZY)
    private ModelData model;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private AliasSubmodelConnection submodel;
    @ManyToOne
    private CompartmentAlias compartmentAlias;
    private String aliasId;
    private Double x;
    private Double y;
    private Double width;
    private Double height;
    private Double fontSize;
    private Color color;
    private int visibilityLevel;
    private int transparencyLevel;
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    @ManyToOne
    @JoinColumn(name="idElementDb")
    private Element element;
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    @OneToMany(fetch=FetchType.EAGER, mappedBy="source", orphanRemoval=true)
    private List<SearchIndex> searchIndexes = new ArrayList<SearchIndex>();

    protected Alias(Alias param) {
        this.aliasId = param.getAliasId();
        this.x = param.getX();
        this.y = param.getY();
        this.width = param.getWidth();
        this.height = param.getHeight();
        this.fontSize = param.getFontSize();
        this.parent = param.getParent();
        this.visibilityLevel = param.getVisibilityLevel();
        this.color = param.getColor();
        this.element = param.getElement();
        for (SearchIndex searchIndex : param.getSearchIndexes()) {
            this.searchIndexes.add(searchIndex.copy());
        }
        if (param.getSubmodel() != null) {
            this.setSubmodel(param.getSubmodel().copy());
        }
    }

    protected Alias() {
        this.aliasId = "";
        this.x = 0.0;
        this.y = 0.0;
        this.width = 0.0;
        this.height = 0.0;
        this.parent = null;
        this.fontSize = 12.0;
        this.visibilityLevel = 0;
        this.color = Color.white;
        this.element = null;
    }

    public void setX(String string) {
        this.x = Double.parseDouble(string);
    }

    public void setY(String string) {
        this.y = Double.parseDouble(string);
    }

    public void setFontSize(String string) {
        this.fontSize = Double.parseDouble(string);
    }

    public double getCenterX() {
        return this.getX() + this.getWidth() / 2.0;
    }

    public double getCenterY() {
        return this.getY() + this.getHeight() / 2.0;
    }

    public Point2D getCenter() {
        return new Point2D.Double(this.getCenterX(), this.getCenterY());
    }

    public void increaseBorder(double increaseSize) {
        this.x = this.x - increaseSize;
        this.y = this.y - increaseSize;
        Alias alias = this;
        alias.width = alias.width + increaseSize * 2.0;
        alias = this;
        alias.height = alias.height + increaseSize * 2.0;
    }

    public void setWidth(String string) {
        try {
            this.width = Double.parseDouble(string);
        }
        catch (Exception e) {
            this.width = 0.0;
            logger.error("Invalid width format: " + string);
        }
    }

    public void setHeight(String string) {
        try {
            this.height = Double.parseDouble(string);
        }
        catch (Exception e) {
            this.height = 0.0;
            logger.error("Invalid height format: " + string);
        }
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public double getDistanceFromPoint(Point2D point) {
        if (this.contains(point)) {
            return 0.0;
        }
        if (this.getX() <= point.getX() && this.getX() + this.getWidth() >= point.getX()) {
            return Math.min(Math.abs(point.getY() - this.getY()), Math.abs(point.getY() - (this.getY() + this.getHeight())));
        }
        if (this.getY() <= point.getY() && this.getY() + this.getHeight() >= point.getY()) {
            return Math.min(Math.abs(point.getX() - this.getX()), Math.abs(point.getX() - (this.getY() + this.getWidth())));
        }
        double distance1 = point.distance(this.getX(), this.getY());
        double distance2 = point.distance(this.getX() + this.getWidth(), this.getY());
        double distance3 = point.distance(this.getX(), this.getY() + this.getHeight());
        double distance4 = point.distance(this.getX() + this.getWidth(), this.getY() + this.getHeight());
        return Math.min(Math.min(distance1, distance2), Math.min(distance3, distance4));
    }

    public boolean contains(Point2D point) {
        return this.getX() <= point.getX() && this.getY() <= point.getY() && this.getX() + this.getWidth() >= point.getX() && this.getY() + this.getHeight() >= point.getY();
    }

    public Rectangle2D getBorder() {
        return new Rectangle2D.Double(this.x, this.y, this.width, this.height);
    }

    public double getSize() {
        return this.getWidth() * this.getHeight();
    }

    public boolean contains(Alias alias2) {
        if (alias2 instanceof SpeciesAlias) {
            Point2D.Double p1 = new Point2D.Double(alias2.getX(), alias2.getY());
            Point2D.Double p2 = new Point2D.Double(alias2.getX(), alias2.getY() + alias2.getHeight());
            Point2D.Double p3 = new Point2D.Double(alias2.getX() + alias2.getWidth(), alias2.getY());
            Point2D.Double p4 = new Point2D.Double(alias2.getX() + alias2.getWidth(), alias2.getY() + alias2.getHeight());
            return this.contains(p1) || this.contains(p2) || this.contains(p3) || this.contains(p4);
        }
        return this.getX() < alias2.getX() && this.getY() < alias2.getY() && this.getX() + this.getWidth() > alias2.getX() + alias2.getWidth() && this.getY() + this.getHeight() > alias2.getY() + alias2.getHeight();
    }

    public abstract Alias copy();

    public void setX(int x) {
        this.setX(Double.valueOf(x));
    }

    public void setY(int y) {
        this.setY(Double.valueOf(y));
    }

    public Element getElement() {
        return this.element;
    }

    public Double getX() {
        return this.x;
    }

    public void setX(Double x) {
        this.x = x;
    }

    public Double getY() {
        return this.y;
    }

    public void setY(Double y) {
        this.y = y;
    }

    public Double getWidth() {
        return this.width;
    }

    public void setWidth(Double width) {
        this.width = width;
    }

    public Double getHeight() {
        return this.height;
    }

    public void setHeight(Double height) {
        this.height = height;
    }

    public Double getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(Double fontSize) {
        this.fontSize = fontSize;
    }

    public Alias getParent() {
        return this.parent;
    }

    public void setParent(Alias parent) {
        this.parent = parent;
    }

    public String getAliasId() {
        return this.aliasId;
    }

    public void setAliasId(String aliasId) {
        this.aliasId = aliasId;
    }

    public int getVisibilityLevel() {
        return this.visibilityLevel;
    }

    public void setVisibilityLevel(int visibilityLevel) {
        this.visibilityLevel = visibilityLevel;
    }

    public ModelData getModelData() {
        return this.model;
    }

    public void setModelData(ModelData model) {
        this.model = model;
    }

    public CompartmentAlias getCompartmentAlias() {
        return this.compartmentAlias;
    }

    public void setCompartmentAlias(CompartmentAlias compartmentAlias) {
        this.compartmentAlias = compartmentAlias;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public int getTransparencyLevel() {
        return this.transparencyLevel;
    }

    public void setTransparencyLevel(int transparencyLevel) {
        this.transparencyLevel = transparencyLevel;
    }

    protected void setElement(Element element) {
        this.element = element;
    }

    @XmlTransient
    public Model getModel() {
        return this.model.getModel();
    }

    public void setModel(Model model) {
        this.model = model.getModelData();
    }

    public void setSearchIndexes(List<SearchIndex> searchIndexes) {
        this.searchIndexes.clear();
        for (SearchIndex searchIndex : searchIndexes) {
            searchIndex.setSource(this);
        }
        this.searchIndexes.addAll(searchIndexes);
    }

    public List<SearchIndex> getSearchIndexes() {
        return this.searchIndexes;
    }

    public AliasSubmodelConnection getSubmodel() {
        return this.submodel;
    }

    public void setSubmodel(AliasSubmodelConnection submodel) {
        this.submodel = submodel;
        if (submodel != null) {
            this.submodel.setFromAlias(this);
        }
    }

    public void setFontSize(int fontSize) {
        this.setFontSize(Double.valueOf(fontSize));
    }
}

