/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.map.agregator;

import java.util.Comparator;
import lcsb.mapviewer.common.exception.InvalidClassException;
import lcsb.mapviewer.model.map.ElementComparator;
import lcsb.mapviewer.model.map.agregator.Compartment;

public class CompartmentComparator
implements Comparator<Compartment> {
    private double epsilon;

    public CompartmentComparator(double epsilon) {
        this.epsilon = epsilon;
    }

    public CompartmentComparator() {
        this(1.0E-6);
    }

    @Override
    public int compare(Compartment arg0, Compartment arg1) {
        if (arg0 == null) {
            if (arg1 == null) {
                return 0;
            }
            return 1;
        }
        if (arg1 == null) {
            return -1;
        }
        if (arg0.getClass().equals(arg1.getClass())) {
            if (arg0 instanceof Compartment) {
                return this.internalCompare(arg0, arg1);
            }
            throw new InvalidClassException("Don't know how to compare classes: " + arg0.getClass());
        }
        return -1;
    }

    private int internalCompare(Compartment arg0, Compartment arg1) {
        ElementComparator elementComparator = new ElementComparator(this.epsilon);
        int result = elementComparator.internalCompare(arg0, arg1);
        if (result != 0) {
            return result;
        }
        if (!arg0.getCompartmentId().equals(arg1.getCompartmentId())) {
            return arg0.getCompartmentId().compareTo(arg1.getCompartmentId());
        }
        if (!arg0.getMetaId().equals(arg1.getMetaId())) {
            return arg0.getMetaId().compareTo(arg1.getMetaId());
        }
        return 0;
    }
}

