/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.map;

import java.util.ArrayList;
import java.util.List;
import lcsb.mapviewer.model.map.agregator.Compartment;
import lcsb.mapviewer.model.map.reaction.Reaction;
import lcsb.mapviewer.model.map.species.Chemical;
import lcsb.mapviewer.model.map.species.ComplexSpecies;
import lcsb.mapviewer.model.map.species.Drug;
import lcsb.mapviewer.model.map.species.Gene;
import lcsb.mapviewer.model.map.species.Phenotype;
import lcsb.mapviewer.model.map.species.Protein;
import lcsb.mapviewer.model.map.species.Rna;

public enum MiriamType {
    CAS("Chemical Abstracts Service", "http://commonchemistry.org", new String[]{"urn:miriam:cas"}, new Class[0], "MIR:00000237"),
    CCDS("Consensus CDS", "http://www.ncbi.nlm.nih.gov/CCDS/", new String[]{"urn:miriam:ccds"}, new Class[0], "MIR:00000375"),
    CHEBI("Chebi", "http://www.ebi.ac.uk/chebi/", new String[]{"urn:miriam:obo.chebi", "urn:miriam:chebi"}, new Class[]{Chemical.class, Drug.class}, "MIR:00000002"),
    CHEMSPIDER("ChemSpider", "http://www.chemspider.com//", new String[]{"urn:miriam:chemspider"}, new Class[0], "MIR:00000138"),
    CHEMBL_COMPOUND("ChEMBL", "https://www.ebi.ac.uk/chembldb/", new String[]{"urn:miriam:chembl.compound"}, new Class[]{Drug.class}, "MIR:00000084"),
    CHEMBL_TARGET("ChEMBL target", "https://www.ebi.ac.uk/chembldb/", new String[]{"urn:miriam:chembl.target"}, new Class[]{Protein.class, ComplexSpecies.class}, "MIR:00000085"),
    DRUGBANK("DrugBank", "http://www.drugbank.ca/", new String[]{"urn:miriam:drugbank"}, new Class[]{Drug.class}, "MIR:00000102"),
    DRUGBANK_TARGET_V4("DrugBank Target v4", "http://www.drugbank.ca/targets", new String[]{"urn:miriam:drugbankv4.target"}, new Class[0], "MIR:00000528"),
    EC("Enzyme Nomenclature", "http://www.enzyme-database.org/", new String[]{"urn:miriam:ec-code"}, new Class[]{Protein.class, ComplexSpecies.class}, "MIR:00000004"),
    ENSEMBL("Ensembl", "www.ensembl.org", new String[]{"urn:miriam:ensembl"}, new Class[0], "MIR:00000003"),
    ENTREZ("Entrez Gene", "http://www.ncbi.nlm.nih.gov/gene", new String[]{"urn:miriam:ncbigene", "urn:miriam:entrez.gene"}, new Class[]{Protein.class, Gene.class, Rna.class}, "MIR:00000069"),
    GO("Gene Ontology", "http://amigo.geneontology.org/amigo", new String[]{"urn:miriam:obo.go", "urn:miriam:go"}, new Class[]{Phenotype.class, Compartment.class, ComplexSpecies.class}, "MIR:00000022"),
    HGNC("HGNC", "http://www.genenames.org", "urn:miriam:hgnc", new Class[]{Protein.class, Gene.class, Rna.class}, "MIR:00000080"),
    HGNC_SYMBOL("HGNC Smbol", "http://www.genenames.org", new String[]{"urn:miriam:hgnc.symbol"}, new Class[]{Protein.class, Gene.class, Rna.class}, "MIR:00000362"),
    HMDB("HMDB", "http://www.hmdb.ca/", "urn:miriam:hmdb", new Class[]{Chemical.class, Drug.class}, "MIR:00000051"),
    INTERPRO("InterPro", "http://www.ebi.ac.uk/interpro/", new String[]{"urn:miriam:interpro"}, new Class[]{Protein.class, ComplexSpecies.class}, "MIR:00000011"),
    KEGG_COMPOUND("Kegg Compound", "http://www.genome.jp/kegg/ligand.html", "urn:miriam:kegg.compound", new Class[]{Chemical.class}, "MIR:00000013"),
    KEGG_GENES("Kegg Genes", "http://www.genome.jp/kegg/genes.html", new String[]{"urn:miriam:kegg.genes", "urn:miriam:kegg.genes:hsa"}, new Class[]{Protein.class, Gene.class, Rna.class}, "MIR:00000070"),
    KEGG_ORTHOLOGY("KEGG Orthology", "http://www.genome.jp/kegg/ko.html", new String[]{"urn:miriam:kegg.orthology"}, new Class[0], "MIR:00000116"),
    KEGG_PATHWAY("Kegg Pathway", "http://www.genome.jp/kegg/pathway.html", "urn:miriam:kegg.pathway", new Class[]{Reaction.class}, "MIR:00000012"),
    KEGG_REACTION("Kegg Reaction", "http://www.genome.jp/kegg/reaction/", "urn:miriam:kegg.reaction", new Class[]{Reaction.class}, "MIR:00000014"),
    MESH_2012("MeSH 2012", "http://www.nlm.nih.gov/mesh/", new String[]{"urn:miriam:mesh.2012", "urn:miriam:mesh"}, new Class[]{Phenotype.class, Compartment.class, ComplexSpecies.class}, "MIR:00000270"),
    MI_RBASE_SEQUENCE("miRBase Sequence Database", "http://www.mirbase.org/", new String[]{"urn:miriam:mirbase"}, new Class[0], "MIR:00000078"),
    MGD("Mouse Genome Database", "http://www.informatics.jax.org/", new String[]{"urn:miriam:mgd"}, new Class[]{Protein.class, Gene.class, Rna.class}, "MIR:00000037"),
    PANTHER("PANTHER Family", "http://www.pantherdb.org/", new String[]{"urn:miriam:panther.family", "urn:miriam:panther"}, new Class[]{Protein.class, Gene.class, Rna.class}, "MIR:00000060"),
    PFAM("Protein Family Database", "http://pfam.xfam.org//", "urn:miriam:pfam", new Class[0], "MIR:00000028"),
    PHARM("PharmGKB Pathways", "http://www.pharmgkb.org/", "urn:miriam:pharmgkb.pathways", new Class[0], "MIR:00000089"),
    PUBCHEM("PubChem-compound", "http://pubchem.ncbi.nlm.nih.gov/", "urn:miriam:pubchem.compound", new Class[]{Chemical.class}, "MIR:00000034"),
    PUBCHEM_SUBSTANCE("PubChem-substance", "http://pubchem.ncbi.nlm.nih.gov/", "urn:miriam:pubchem.substance", new Class[]{Chemical.class}, "MIR:00000033"),
    PUBMED("PubMed", "http://www.ncbi.nlm.nih.gov/PubMed/", "urn:miriam:pubmed", new Class[]{Object.class}, "MIR:00000015"),
    REACTOME("Reactome", "http://www.reactome.org/", "urn:miriam:reactome", new Class[]{Reaction.class}, "MIR:00000018"),
    REFSEQ("RefSeq", "http://www.ncbi.nlm.nih.gov/projects/RefSeq/", "urn:miriam:refseq", new Class[]{Protein.class, Gene.class, Rna.class}, "MIR:00000039"),
    TAXONOMY("Taxonomy", "http://www.ncbi.nlm.nih.gov/taxonomy/", "urn:miriam:taxonomy", new Class[0], "MIR:00000006"),
    UNIGENE("UniGene", "http://www.ncbi.nlm.nih.gov/unigene", "urn:miriam:unigene", new Class[0], "MIR:00000346"),
    UNIPROT("Uniprot", "http://www.uniprot.org/", "urn:miriam:uniprot", new Class[]{Protein.class, Gene.class, Rna.class}, "MIR:00000005"),
    UNIPROT_ISOFORM("UniProt Isoform", "http://www.uniprot.org/", "urn:miriam:uniprot.isoform", new Class[]{Protein.class}, "MIR:00000388"),
    UNKNOWN("Unknown", null, new String[0], new Class[0], null),
    WIKIPATHWAYS("WikiPathways", "http://www.wikipathways.org/", new String[]{"urn:miriam:wikipathways"}, new Class[0], "MIR:00000076"),
    WIKIPEDIA("Wikipedia (English)", "http://en.wikipedia.org/wiki/Main_Page", new String[]{"urn:miriam:wikipedia.en"}, new Class[0], "MIR:00000384");

    private String commonName;
    private String dbHomepage;
    private String registryIdentifier;
    private List<String> uris = new ArrayList<String>();
    private List<Class<?>> validClass = new ArrayList();

    private MiriamType(String commonName, String dbHomePage, String[] uris, Class<?>[] classes, String registryIdentifier) {
        this.commonName = commonName;
        this.dbHomepage = dbHomePage;
        for (String string2 : uris) {
            this.uris.add(string2);
        }
        for (Class<?> clazz : classes) {
            this.validClass.add(clazz);
        }
        this.registryIdentifier = registryIdentifier;
    }

    private MiriamType(String commonName, String dbHomePage, String uri, Class<?>[] classes, String registryIdentifier) {
        this.dbHomepage = dbHomePage;
        this.commonName = commonName;
        this.uris.add(uri);
        for (Class<?> clazz : classes) {
            this.validClass.add(clazz);
        }
        this.registryIdentifier = registryIdentifier;
    }

    private MiriamType(String commonName, String uri, String registryIdentifier) {
        this.commonName = commonName;
        this.uris.add(uri);
        this.registryIdentifier = registryIdentifier;
    }

    public String getCommonName() {
        return this.commonName;
    }

    public List<String> getUris() {
        return this.uris;
    }

    public void addUri(String uri) {
        this.uris.add(uri);
    }

    public List<Class<?>> getValidClass() {
        return this.validClass;
    }

    public static MiriamType getTypeByUri(String uri) {
        for (MiriamType mt : MiriamType.values()) {
            for (String string : mt.getUris()) {
                if (!string.equalsIgnoreCase(uri)) continue;
                return mt;
            }
        }
        return null;
    }

    public String getDbHomepage() {
        return this.dbHomepage;
    }

    public String getRegistryIdentifier() {
        return this.registryIdentifier;
    }
}

