/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.map;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import lcsb.mapviewer.common.exception.InvalidArgumentException;
import lcsb.mapviewer.model.map.AnnotatedObject;
import lcsb.mapviewer.model.map.MiriamData;
import lcsb.mapviewer.model.map.agregator.Compartment;
import lcsb.mapviewer.model.map.model.Model;
import lcsb.mapviewer.model.map.model.ModelData;
import lcsb.mapviewer.model.map.species.ComplexSpecies;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.IndexColumn;

@Entity
@Table(name="species_table")
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name="species_type_db", discriminatorType=DiscriminatorType.STRING)
@DiscriminatorValue(value="GENERIC_ELEMENT")
public abstract class Element
implements AnnotatedObject {
    private static final int MAX_SYNONYM_LENGTH = 255;
    private static Logger logger = Logger.getLogger(Element.class);
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="idDb", unique=true, nullable=false)
    private int id;
    private String metaId;
    @Column(name="notes", columnDefinition="TEXT")
    private String notes;
    private String symbol;
    private String fullName;
    private String abbreviation;
    private String formula;
    @Column(name="name")
    private String name = "";
    @ElementCollection
    @CollectionTable(name="element_synonyms", joinColumns={@JoinColumn(name="idDb")})
    @Column(name="synonym")
    @IndexColumn(name="idx")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    private List<String> synonyms = new ArrayList<String>();
    @ElementCollection
    @CollectionTable(name="element_former_symbols", joinColumns={@JoinColumn(name="idDb")})
    @Column(name="symbol")
    @IndexColumn(name="idx")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    private List<String> formerSymbols = new ArrayList<String>();
    @ManyToOne(cascade={CascadeType.ALL})
    private Compartment parent;
    @ManyToOne(cascade={CascadeType.ALL})
    private ComplexSpecies complex;
    @ManyToOne(fetch=FetchType.LAZY)
    private ModelData model;
    @OneToMany(fetch=FetchType.EAGER, mappedBy="element", cascade={CascadeType.ALL})
    private Set<MiriamData> miriamData = new HashSet<MiriamData>();

    protected Element(Element element) {
        this.parent = element.parent;
        this.complex = element.complex;
        this.notes = element.notes;
        this.symbol = element.symbol;
        this.fullName = element.fullName;
        this.name = element.getName();
        this.getSynonyms().addAll(element.getSynonyms());
        this.getFormerSymbols().addAll(element.getFormerSymbols());
        this.metaId = element.metaId;
        for (MiriamData md : element.getMiriamData()) {
            this.addMiriamData(new MiriamData(md), null);
        }
        this.abbreviation = element.getAbbreviation();
        this.formula = element.getFormula();
    }

    protected Element() {
        this.notes = "";
        this.metaId = "";
    }

    @Override
    public void addMiriamData(Set<MiriamData> miriamData, List<String> warnings) {
        if (miriamData != null) {
            for (MiriamData md : miriamData) {
                this.addMiriamData(md, warnings);
            }
        }
    }

    @Override
    public void addMiriamData(MiriamData md, List<String> warnings) {
        if (this.miriamData.contains(md)) {
            String warning = "Miriam data (" + (Object)((Object)md.getDataType()) + ": " + md.getResource() + ") for " + this.getElementId() + " already exists. Ignoring...";
            if (warnings != null) {
                warnings.add(warning);
            } else {
                logger.warn(warning);
            }
        } else {
            this.miriamData.add(md);
            md.setElement(this);
        }
    }

    public void setNotes(String notes) {
        if (notes != null && notes.contains("</html>")) {
            throw new InvalidArgumentException("Notes cannot contain html tags...");
        }
        this.notes = notes;
    }

    public abstract Element copy();

    public void addSynonyms(List<String> synonyms) {
        for (String string : synonyms) {
            if (string.length() > 255) {
                String message = " <Synonym too long. Only 255 characters are allowed>";
                this.getSynonyms().add(string.substring(0, 255 - message.length()) + message);
                continue;
            }
            this.getSynonyms().add(string);
        }
    }

    public abstract String getElementId();

    public abstract String getStringType();

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getNotes() {
        return this.notes;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getSynonyms() {
        return this.synonyms;
    }

    public void setSynonyms(List<String> synonyms) {
        this.synonyms = synonyms;
    }

    public List<String> getFormerSymbols() {
        return this.formerSymbols;
    }

    public void setFormerSymbols(List<String> formerSymbols) {
        this.formerSymbols = formerSymbols;
    }

    public Compartment getParent() {
        return this.parent;
    }

    public void setParent(Compartment parent) {
        this.parent = parent;
    }

    public ComplexSpecies getComplex() {
        return this.complex;
    }

    public void setComplex(ComplexSpecies complex) {
        this.complex = complex;
    }

    public ModelData getModelData() {
        return this.model;
    }

    public void setModelData(ModelData model) {
        this.model = model;
    }

    public void setModel(Model model) {
        this.model = model.getModelData();
    }

    public Set<MiriamData> getMiriamData() {
        return this.miriamData;
    }

    public String getMetaId() {
        return this.metaId;
    }

    public void setMetaId(String metaId) {
        this.metaId = metaId;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public void setAbbreviation(String abbreviation) {
        this.abbreviation = abbreviation;
    }

    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }
}

