/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.graphics;

import java.util.Comparator;
import lcsb.mapviewer.common.comparator.DoubleComparator;
import lcsb.mapviewer.common.comparator.IntegerComparator;
import lcsb.mapviewer.model.graphics.ArrowTypeDataComparator;
import lcsb.mapviewer.model.graphics.PolylineData;
import org.apache.log4j.Logger;

public class PolylineDataComparator
implements Comparator<PolylineData> {
    private Logger logger = Logger.getLogger(PolylineDataComparator.class);
    private double epsilon;

    public PolylineDataComparator(double epsilon) {
        this.epsilon = epsilon;
    }

    public PolylineDataComparator() {
        this(1.0E-6);
    }

    @Override
    public int compare(PolylineData arg0, PolylineData arg1) {
        if (arg0 == null) {
            if (arg1 == null) {
                return 0;
            }
            return 1;
        }
        if (arg1 == null) {
            return -1;
        }
        if (arg0.getClass().equals(arg1.getClass())) {
            return this.internalCompare(arg0, arg1);
        }
        return -1;
    }

    private int internalCompare(PolylineData arg0, PolylineData arg1) {
        IntegerComparator integerComparator = new IntegerComparator();
        DoubleComparator doubleComparator = new DoubleComparator(this.epsilon);
        ArrowTypeDataComparator atdComparator = new ArrowTypeDataComparator(this.epsilon);
        if (integerComparator.compare(arg0.getPoints().size(), arg1.getPoints().size()) != 0) {
            this.logger.debug("Lines have different size: " + arg0.getPoints().size() + ", " + arg1.getPoints().size());
            return integerComparator.compare(arg0.getPoints().size(), arg1.getPoints().size());
        }
        if (atdComparator.compare(arg0.getBeginAtd(), arg1.getBeginAtd()) != 0) {
            this.logger.debug("Lines have different begin adt: " + arg0.getBeginAtd() + ", " + arg1.getBeginAtd());
            return atdComparator.compare(arg0.getBeginAtd(), arg1.getBeginAtd());
        }
        if (atdComparator.compare(arg0.getEndAtd(), arg1.getEndAtd()) != 0) {
            this.logger.debug("Lines have different end adt: " + arg0.getEndAtd() + ", " + arg1.getEndAtd());
            return atdComparator.compare(arg0.getEndAtd(), arg1.getEndAtd());
        }
        if (doubleComparator.compare(arg0.getWidth(), arg1.getWidth()) != 0) {
            this.logger.debug("Lines have different width: " + arg0.getWidth() + ", " + arg1.getWidth());
            return doubleComparator.compare(arg0.getWidth(), arg1.getWidth());
        }
        if (integerComparator.compare(arg0.getColor().getRGB(), arg1.getColor().getRGB()) != 0) {
            this.logger.debug("Lines have different color: " + arg0.getColor() + ", " + arg1.getColor());
            return integerComparator.compare(arg0.getColor().getRGB(), arg1.getColor().getRGB());
        }
        if (arg0.getType().compareTo(arg1.getType()) != 0) {
            this.logger.debug("Lines have different type: " + (Object)((Object)arg0.getType()) + ", " + (Object)((Object)arg1.getType()));
            return arg0.getType().compareTo(arg1.getType());
        }
        return 0;
    }
}

