/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.converter.model.celldesigner.types;

import lcsb.mapviewer.common.exception.InvalidArgumentException;
import lcsb.mapviewer.converter.model.celldesigner.types.OperatorType;
import lcsb.mapviewer.model.map.reaction.NodeOperator;
import org.apache.log4j.Logger;

public class OperatorTypeUtils {
    private static Logger logger = Logger.getLogger(OperatorTypeUtils.class);

    public OperatorType getOperatorTypeForClazz(Class<? extends NodeOperator> clazz) {
        for (OperatorType modType : OperatorType.values()) {
            if (!clazz.equals(modType.getClazz())) continue;
            return modType;
        }
        return null;
    }

    protected OperatorType getOperatorTypeForStringType(String type) {
        for (OperatorType modType : OperatorType.values()) {
            if (!type.equalsIgnoreCase(modType.getStringName())) continue;
            return modType;
        }
        return null;
    }

    public NodeOperator createModifierForStringType(String type) {
        NodeOperator operator = null;
        OperatorType opType = this.getOperatorTypeForStringType(type);
        if (opType == null) {
            throw new InvalidArgumentException("Unknown modifier type: " + type);
        }
        try {
            operator = opType.getClazz().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
        return operator;
    }

    public String getStringTypeByOperator(NodeOperator modifierOperator) {
        OperatorType operatorType = this.getOperatorTypeForClazz(modifierOperator.getClass());
        if (operatorType != null) {
            return operatorType.getStringName();
        }
        return null;
    }
}

