/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.converter.model.celldesigner.types;

import lcsb.mapviewer.model.graphics.ArrowType;
import lcsb.mapviewer.model.graphics.ArrowTypeData;
import lcsb.mapviewer.model.graphics.LineType;
import lcsb.mapviewer.model.map.modifier.Catalysis;
import lcsb.mapviewer.model.map.modifier.Inhibition;
import lcsb.mapviewer.model.map.modifier.Modulation;
import lcsb.mapviewer.model.map.modifier.PhysicalStimulation;
import lcsb.mapviewer.model.map.modifier.Trigger;
import lcsb.mapviewer.model.map.modifier.UnknownCatalysis;
import lcsb.mapviewer.model.map.modifier.UnknownInhibition;
import lcsb.mapviewer.model.map.reaction.Modifier;

public enum ModifierType {
    CATALYSIS("CATALYSIS", Catalysis.class, ArrowType.CIRCLE, 8.0),
    INHIBITION("INHIBITION", Inhibition.class, ArrowType.CROSSBAR, 8.0, 4.0),
    UNKNOWN_CATALYSIS("UNKNOWN_CATALYSIS", UnknownCatalysis.class, ArrowType.CIRCLE, 8.0, 0.0, LineType.DASHED),
    UNKNOWN_INHIBITION("UNKNOWN_INHIBITION", UnknownInhibition.class, ArrowType.CROSSBAR, 8.0, 4.0, LineType.DASHED),
    PHYSICAL_STIMULATION("PHYSICAL_STIMULATION", PhysicalStimulation.class, ArrowType.BLANK),
    MODULATION_STRING("MODULATION", Modulation.class, ArrowType.DIAMOND),
    TRIGGER_STRING("TRIGGER", Trigger.class, ArrowType.BLANK_CROSSBAR);

    private String stringName;
    private Class<? extends Modifier> clazz;
    private ArrowTypeData atd = new ArrowTypeData();
    private double trimLength = 0.0;
    private LineType lineType = LineType.SOLID;

    private ModifierType(String string2, Class<? extends Modifier> clazz, ArrowType at) {
        this(string2, clazz, at, null, null, null);
    }

    private ModifierType(String string2, Class<? extends Modifier> clazz, ArrowType at, Double arrowLength) {
        this(string2, clazz, at, arrowLength, null, null);
    }

    private ModifierType(String string2, Class<? extends Modifier> clazz, ArrowType at, Double arrowLength, Double trimLength) {
        this(string2, clazz, at, arrowLength, trimLength, null);
    }

    private ModifierType(String string2, Class<? extends Modifier> clazz, ArrowType at, Double arrowLength, Double trimLength, LineType lt) {
        this.stringName = string2;
        this.clazz = clazz;
        if (at != null) {
            this.atd.setArrowType(at);
        }
        if (arrowLength != null) {
            this.atd.setLen(arrowLength);
        }
        if (trimLength != null) {
            this.trimLength = trimLength;
        }
        if (lt != null) {
            this.lineType = lt;
        }
    }

    public String getStringName() {
        return this.stringName;
    }

    public Class<? extends Modifier> getClazz() {
        return this.clazz;
    }

    public ArrowTypeData getAtd() {
        return this.atd;
    }

    public double getTrimLength() {
        return this.trimLength;
    }

    public LineType getLineType() {
        return this.lineType;
    }
}

