/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.converter.model.celldesigner.structure;

import java.util.HashMap;
import java.util.Map;
import lcsb.mapviewer.common.exception.InvalidArgumentException;
import org.apache.log4j.Logger;

public class ConnectScheme {
    private Logger logger = Logger.getLogger(ConnectScheme.class.getName());
    private String connectPolicy;
    private Integer connectIndex;
    private Map<String, String> lineDirections;

    public ConnectScheme() {
        this.connectPolicy = "";
        this.connectIndex = null;
        this.lineDirections = new HashMap<String, String>();
    }

    public ConnectScheme(ConnectScheme connectScheme) {
        this.connectPolicy = connectScheme.getConnectPolicy();
        this.connectIndex = connectScheme.getConnectIndex();
        this.lineDirections = connectScheme.lineDirections;
    }

    public void setLineDirections(Map<String, String> directions) {
        this.lineDirections = directions;
    }

    public void setConnectIndex(String text) {
        if (text == null || "".equals(text)) {
            this.connectIndex = null;
        } else {
            try {
                this.connectIndex = Integer.parseInt(text);
            }
            catch (Exception e) {
                throw new InvalidArgumentException(e);
            }
        }
    }

    public String getConnectPolicy() {
        return this.connectPolicy;
    }

    public void setConnectPolicy(String connectPolicy) {
        this.connectPolicy = connectPolicy;
    }

    public Integer getConnectIndex() {
        return this.connectIndex;
    }

    public void setConnectIndex(Integer connectIndex) {
        this.connectIndex = connectIndex;
    }
}

