/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.converter.model.celldesigner.species;

import java.util.List;
import lcsb.mapviewer.common.Pair;
import lcsb.mapviewer.common.exception.InvalidArgumentException;
import lcsb.mapviewer.common.exception.InvalidXmlSchemaException;
import lcsb.mapviewer.converter.model.celldesigner.species.AbstractElementXmlParser;
import lcsb.mapviewer.converter.model.celldesigner.species.ProteinMapping;
import lcsb.mapviewer.model.map.Element;
import lcsb.mapviewer.model.map.species.Protein;
import lcsb.mapviewer.model.map.species.fields.ModificationResidue;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProteinXmlParser
extends AbstractElementXmlParser<Protein> {
    private Logger logger = Logger.getLogger(ProteinXmlParser.class.getName());

    @Override
    public Pair<String, Protein> parseXmlElement(Node proteinNode, List<String> warnings) throws InvalidXmlSchemaException {
        Protein protein = null;
        String value = this.getNodeAttr("type", proteinNode);
        ProteinMapping mapping = ProteinMapping.getMappingByString(value);
        if (mapping == null) {
            throw new InvalidXmlSchemaException("Protein node in Sbml model is of unknown type: " + value);
        }
        protein = mapping.createProtein();
        String identifier = this.getNodeAttr("id", proteinNode);
        protein.setName(this.decodeName(this.getNodeAttr("name", proteinNode)));
        NodeList list = proteinNode.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equals("celldesigner:listOfModificationResidues")) {
                NodeList residueList = node.getChildNodes();
                for (int j = 0; j < residueList.getLength(); ++j) {
                    Node residueNode = residueList.item(j);
                    if (residueNode.getNodeType() != 1) continue;
                    if (residueNode.getNodeName().equalsIgnoreCase("celldesigner:modificationResidue")) {
                        protein.addModificationResidue(this.getModificationResidue(residueNode));
                        continue;
                    }
                    this.logger.debug("Unknown element of celldesigner:listOfModificationResidues " + residueNode.getNodeName());
                }
                continue;
            }
            if (node.getNodeName().equals("celldesigner:notes")) {
                this.getRap().processNotes(node, (Element)protein, warnings);
                continue;
            }
            this.logger.debug("Unknown element of celldesigner:protein " + node.getNodeName());
        }
        return new Pair<String, Protein>(identifier, protein);
    }

    @Override
    public String toXml(Protein protein) {
        String attributes = "";
        String result = "";
        attributes = attributes + " id=\"p_" + protein.getIdSpecies() + "\"";
        if (!protein.getName().equals("")) {
            attributes = attributes + " name=\"" + this.escapeXml(protein.getName()) + "\"";
        }
        String type = null;
        ProteinMapping mapping = ProteinMapping.getMappingByClass(protein.getClass());
        if (mapping == null) {
            throw new InvalidArgumentException("Invalid protein class type: " + protein.getClass().getName());
        }
        type = mapping.getCellDesignerString();
        attributes = attributes + " type=\"" + type + "\"";
        result = result + "<celldesigner:protein" + attributes + ">\n";
        if (protein.getModificationResidues().size() > 0) {
            result = result + "<celldesigner:listOfModificationResidues>";
            for (ModificationResidue mr : protein.getModificationResidues()) {
                result = result + this.toXml(mr);
            }
            result = result + "</celldesigner:listOfModificationResidues>\n";
        }
        result = result + "</celldesigner:protein>\n";
        return result;
    }

    @Override
    private String toXml(ModificationResidue mr) {
        String result = "";
        String attributes = "";
        if (!mr.getIdModificationResidue().equals("")) {
            attributes = attributes + " id=\"" + mr.getIdModificationResidue() + "\"";
        }
        if (!mr.getName().equals("")) {
            attributes = attributes + " name=\"" + this.escapeXml(mr.getName()) + "\"";
        }
        if (!mr.getSide().equals("")) {
            attributes = attributes + " side=\"" + mr.getSide() + "\"";
        }
        if (mr.getAngle() != 0.0) {
            attributes = attributes + " angle=\"" + mr.getAngle() + "\"";
        }
        result = result + "<celldesigner:modificationResidue " + attributes + ">";
        result = result + "</celldesigner:modificationResidue>";
        return result;
    }

    private ModificationResidue getModificationResidue(Node residueNode) {
        ModificationResidue residue = new ModificationResidue();
        residue.setIdModificationResidue(this.getNodeAttr("id", residueNode));
        residue.setName(this.getNodeAttr("name", residueNode));
        residue.setSide(this.getNodeAttr("side", residueNode));
        residue.setAngle(this.getNodeAttr("angle", residueNode));
        NodeList list = residueNode.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1) continue;
            this.logger.debug("Unknown element of celldesigner:modificationResidue " + node.getNodeName());
        }
        return residue;
    }
}

