/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.converter.model.celldesigner.species;

import java.util.List;
import lcsb.mapviewer.common.Pair;
import lcsb.mapviewer.common.exception.InvalidArgumentException;
import lcsb.mapviewer.common.exception.InvalidXmlSchemaException;
import lcsb.mapviewer.converter.model.celldesigner.annotation.RestAnnotationParser;
import lcsb.mapviewer.converter.model.celldesigner.species.AbstractElementXmlParser;
import lcsb.mapviewer.model.map.Element;
import lcsb.mapviewer.model.map.species.AntisenseRna;
import lcsb.mapviewer.model.map.species.fields.AntisenseRnaRegion;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AntisenseRnaXmlParser
extends AbstractElementXmlParser<AntisenseRna> {
    private Logger logger = Logger.getLogger(AntisenseRnaXmlParser.class.getName());

    @Override
    public Pair<String, AntisenseRna> parseXmlElement(Node antisenseRnaNode, List<String> warnings) throws InvalidXmlSchemaException {
        AntisenseRna antisenseRna = new AntisenseRna();
        String identifier = this.getNodeAttr("id", antisenseRnaNode);
        antisenseRna.setName(this.getNodeAttr("name", antisenseRnaNode));
        NodeList list = antisenseRnaNode.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equals("celldesigner:notes")) {
                this.getRap().processNotes(node, (Element)antisenseRna, warnings);
                continue;
            }
            if (node.getNodeName().equals("celldesigner:listOfRegions")) {
                NodeList residueList = node.getChildNodes();
                for (int j = 0; j < residueList.getLength(); ++j) {
                    Node residueNode = residueList.item(j);
                    if (residueNode.getNodeType() != 1) continue;
                    if (residueNode.getNodeName().equalsIgnoreCase("celldesigner:region")) {
                        antisenseRna.addRegion(this.getAntisenseRnaRegion(residueNode));
                        continue;
                    }
                    this.logger.debug("Unknown element of celldesigner:listOfRegions " + residueNode.getNodeName());
                }
                continue;
            }
            this.logger.debug("Unknown element of celldesigner:antisenseRna " + node.getNodeName());
        }
        Pair<String, AntisenseRna> result = new Pair<String, AntisenseRna>(identifier, antisenseRna);
        return result;
    }

    @Override
    public String toXml(AntisenseRna species) {
        if (!(species instanceof AntisenseRna)) {
            throw new InvalidArgumentException("Argument should be instance of a AntisenseRna");
        }
        AntisenseRna protein = species;
        String attributes = "";
        String result = "";
        attributes = attributes + " id=\"ar_" + protein.getIdSpecies() + "\"";
        if (!protein.getName().equals("")) {
            attributes = attributes + " name=\"" + this.escapeXml(protein.getName()) + "\"";
        }
        result = result + "<celldesigner:AntisenseRNA" + attributes + ">";
        result = result + "<celldesigner:notes>";
        result = result + "<html xmlns=\"http://www.w3.org/1999/xhtml\"><head><title/></head><body>";
        RestAnnotationParser rap = new RestAnnotationParser();
        result = result + rap.createAnnotationString(protein);
        result = result + protein.getNotes();
        result = result + "</body></html>";
        result = result + "</celldesigner:notes>";
        if (protein.getRegions().size() > 0) {
            result = result + "<celldesigner:listOfRegions>";
            for (AntisenseRnaRegion region : protein.getRegions()) {
                result = result + this.toXml(region);
            }
            result = result + "</celldesigner:listOfRegions>";
        }
        result = result + "</celldesigner:AntisenseRNA>";
        return result;
    }

    @Override
    private String toXml(AntisenseRnaRegion region) {
        String result = "";
        String attributes = "";
        if (!region.getIdAntisenseRnaRegion().equals("")) {
            attributes = attributes + " id=\"" + region.getIdAntisenseRnaRegion() + "\"";
        }
        if (!region.getName().equals("")) {
            attributes = attributes + " name=\"" + this.escapeXml(region.getName()) + "\"";
        }
        if (region.getSize() != 0.0) {
            attributes = attributes + " size=\"" + region.getSize() + "\"";
        }
        if (region.getPos() != 0.0) {
            attributes = attributes + " pos=\"" + region.getPos() + "\"";
        }
        if (region.getType() != null) {
            attributes = attributes + " type=\"" + region.getType().getName() + "\"";
        }
        result = result + "<celldesigner:region " + attributes + ">";
        result = result + "</celldesigner:region>";
        return result;
    }

    private AntisenseRnaRegion getAntisenseRnaRegion(Node regionNode) {
        AntisenseRnaRegion residue = new AntisenseRnaRegion();
        residue.setIdAntisenseRnaRegion(this.getNodeAttr("id", regionNode));
        residue.setName(this.getNodeAttr("name", regionNode));
        residue.setSize(this.getNodeAttr("size", regionNode));
        residue.setPos(this.getNodeAttr("pos", regionNode));
        String typeString = this.getNodeAttr("type", regionNode);
        if (typeString != null) {
            AntisenseRnaRegion.AntisenseRnaRegionType type = AntisenseRnaRegion.AntisenseRnaRegionType.getTypeByString(typeString);
            if (type == null) {
                throw new InvalidArgumentException("Unknown antisense rna region type: " + typeString);
            }
            residue.setType(type);
        }
        NodeList list = regionNode.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1) continue;
            this.logger.debug("Unknown element of celldesigner:region " + node.getNodeName());
        }
        return residue;
    }
}

