/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.converter.model.celldesigner.reaction;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import lcsb.mapviewer.common.XmlParser;
import lcsb.mapviewer.common.exception.InvalidArgumentException;
import lcsb.mapviewer.common.exception.InvalidStateException;
import lcsb.mapviewer.common.exception.InvalidXmlSchemaException;
import lcsb.mapviewer.converter.model.celldesigner.annotation.RestAnnotationParser;
import lcsb.mapviewer.converter.model.celldesigner.annotation.XmlAnnotationParser;
import lcsb.mapviewer.converter.model.celldesigner.geometry.CellDesignerAliasConverter;
import lcsb.mapviewer.converter.model.celldesigner.geometry.helper.CellDesignerAnchor;
import lcsb.mapviewer.converter.model.celldesigner.geometry.helper.CellDesignerPointTransformation;
import lcsb.mapviewer.converter.model.celldesigner.geometry.helper.PolylineDataFactory;
import lcsb.mapviewer.converter.model.celldesigner.reaction.ReactionLineData;
import lcsb.mapviewer.converter.model.celldesigner.reaction.ReactionXmlParser;
import lcsb.mapviewer.converter.model.celldesigner.reaction.UnknownReactionClassException;
import lcsb.mapviewer.converter.model.celldesigner.structure.ConnectScheme;
import lcsb.mapviewer.converter.model.celldesigner.structure.EditPoints;
import lcsb.mapviewer.converter.model.celldesigner.structure.LineProperties;
import lcsb.mapviewer.converter.model.celldesigner.types.ModifierTypeUtils;
import lcsb.mapviewer.converter.model.celldesigner.types.OperatorType;
import lcsb.mapviewer.converter.model.celldesigner.types.OperatorTypeUtils;
import lcsb.mapviewer.model.graphics.ArrowType;
import lcsb.mapviewer.model.graphics.ArrowTypeData;
import lcsb.mapviewer.model.graphics.LineType;
import lcsb.mapviewer.model.graphics.PolylineData;
import lcsb.mapviewer.model.map.Element;
import lcsb.mapviewer.model.map.layout.alias.Alias;
import lcsb.mapviewer.model.map.layout.alias.SpeciesAlias;
import lcsb.mapviewer.model.map.model.Model;
import lcsb.mapviewer.model.map.reaction.AbstractNode;
import lcsb.mapviewer.model.map.reaction.AndOperator;
import lcsb.mapviewer.model.map.reaction.DissociationOperator;
import lcsb.mapviewer.model.map.reaction.Modifier;
import lcsb.mapviewer.model.map.reaction.NandOperator;
import lcsb.mapviewer.model.map.reaction.NodeOperator;
import lcsb.mapviewer.model.map.reaction.OrOperator;
import lcsb.mapviewer.model.map.reaction.Product;
import lcsb.mapviewer.model.map.reaction.Reactant;
import lcsb.mapviewer.model.map.reaction.Reaction;
import lcsb.mapviewer.model.map.reaction.ReactionNode;
import lcsb.mapviewer.model.map.reaction.SplitOperator;
import lcsb.mapviewer.model.map.reaction.TruncationOperator;
import lcsb.mapviewer.model.map.reaction.UnknownOperator;
import lcsb.mapviewer.model.map.reaction.type.DissociationReaction;
import lcsb.mapviewer.model.map.reaction.type.SimpleReactionInterface;
import lcsb.mapviewer.model.map.reaction.type.TruncationReaction;
import lcsb.mapviewer.model.map.reaction.type.TwoProductReactionInterface;
import lcsb.mapviewer.model.map.reaction.type.TwoReactantReactionInterface;
import lcsb.mapviewer.model.map.species.Species;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ReactionFromXml
extends XmlParser {
    private static final double REACTANT_END_RATIO = 0.4;
    private static final double PRODUCT_START_RATIO = 0.6;
    private Map<ReactionNode, CellDesignerAnchor> anchorsByNodes = new HashMap<ReactionNode, CellDesignerAnchor>();
    private Map<ReactionNode, String> typeByModifier = new HashMap<ReactionNode, String>();
    private Map<ReactionNode, String> lineTypeByModifier = new HashMap<ReactionNode, String>();
    private Map<ReactionNode, List<Point2D>> pointsByModifier = new HashMap<ReactionNode, List<Point2D>>();
    private Map<Modifier, Modifier> modifierParentOperator = new HashMap<Modifier, Modifier>();
    private Map<ReactionNode, Integer> indexByComplexReaction = new HashMap<ReactionNode, Integer>();
    private Logger logger = Logger.getLogger(ReactionXmlParser.class.getName());
    private RestAnnotationParser rap = new RestAnnotationParser();
    private CellDesignerPointTransformation pointTransformation = new CellDesignerPointTransformation();

    public Reaction getReaction(Node reactionNode, Model model) throws InvalidXmlSchemaException, UnknownReactionClassException {
        Reaction result = new Reaction();
        result.setMetaId(this.getNodeAttr("metaid", reactionNode));
        result.setIdReaction(this.getNodeAttr("id", reactionNode));
        result.setName(this.getNodeAttr("name", reactionNode));
        result.setReversible(!this.getNodeAttr("reversible", reactionNode).equalsIgnoreCase("false"));
        NodeList nodes = reactionNode.getChildNodes();
        Node annotationNode = null;
        for (int x = 0; x < nodes.getLength(); ++x) {
            Node node = nodes.item(x);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equalsIgnoreCase("annotation")) {
                annotationNode = node;
                continue;
            }
            if (node.getNodeName().equalsIgnoreCase("listOfReactants") || node.getNodeName().equalsIgnoreCase("listOfProducts") || node.getNodeName().equalsIgnoreCase("listOfModifiers")) continue;
            if (node.getNodeName().equalsIgnoreCase("notes")) {
                ArrayList<String> warnings = new ArrayList<String>();
                this.rap.processNotes(this.rap.getNotes(node), result, warnings);
                model.addCreationWarnings(warnings);
                continue;
            }
            if (node.getNodeName().equalsIgnoreCase("kineticLaw")) {
                Node kineticLaw = node;
                Node mathNode = this.getNode("math", kineticLaw.getChildNodes());
                if (mathNode == null) {
                    throw new InvalidXmlSchemaException("kineticLaw node doesn't have math subnode");
                }
                String xmlns = this.getNodeAttr("xmlns", mathNode);
                if (!xmlns.equals("http://www.w3.org/1998/Math/MathML")) {
                    throw new InvalidXmlSchemaException("invalid value in math xmlns attrib: " + xmlns);
                }
                result.setKineticLaw(true);
                continue;
            }
            this.logger.debug("Unknown element of reaction: " + node.getNodeName());
        }
        if (annotationNode != null) {
            result = this.parseReactionAnnotation(annotationNode, result, model);
        } else {
            this.logger.debug("No annotation node in reaction");
        }
        return result;
    }

    private Reaction parseReactionAnnotation(Node annotationNode, Reaction result, Model model) throws InvalidXmlSchemaException, UnknownReactionClassException {
        NodeList nodes = annotationNode.getChildNodes();
        for (int x = 0; x < nodes.getLength(); ++x) {
            Node node = nodes.item(x);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equalsIgnoreCase("celldesigner:extension")) {
                result = this.parseReactionExtension(result, node, model);
                continue;
            }
            if (node.getNodeName().equalsIgnoreCase("rdf:RDF")) {
                XmlAnnotationParser xmlParser = new XmlAnnotationParser();
                ArrayList<String> warnings = new ArrayList<String>();
                result.addMiriamData(xmlParser.parseRdfNode(nodes, warnings), warnings);
                model.addCreationWarnings(warnings);
                continue;
            }
            this.logger.debug("Unknown element of reaction/annotation: " + node.getNodeName());
        }
        return result;
    }

    private Reaction parseReactionExtension(Reaction result, Node node, Model model) throws InvalidXmlSchemaException, UnknownReactionClassException {
        NodeList extensionNodes = node.getChildNodes();
        LineProperties line = null;
        ConnectScheme connectScheme = null;
        EditPoints points = null;
        Node reactantsLinkNode = null;
        Node productsLinkNode = null;
        Node modifiersLinkNode = null;
        Node gateMembers = null;
        String type = null;
        for (int y = 0; y < extensionNodes.getLength(); ++y) {
            Node reactantNode;
            int z;
            NodeList reactantsNodes;
            Node nodeReaction = extensionNodes.item(y);
            if (nodeReaction.getNodeType() != 1) continue;
            if (nodeReaction.getNodeName().equalsIgnoreCase("celldesigner:reactionType")) {
                type = this.getNodeValue(nodeReaction);
                continue;
            }
            if (nodeReaction.getNodeName().equalsIgnoreCase("celldesigner:baseReactants")) {
                reactantsNodes = nodeReaction.getChildNodes();
                for (z = 0; z < reactantsNodes.getLength(); ++z) {
                    reactantNode = reactantsNodes.item(z);
                    if (reactantNode.getNodeType() != 1) continue;
                    if (reactantNode.getNodeName().equalsIgnoreCase("celldesigner:baseReactant")) {
                        this.parseBaseReactant(result, reactantNode, model);
                        continue;
                    }
                    this.logger.debug("Unknown element of celldesigner:baseReactants: " + node.getNodeName());
                }
                continue;
            }
            if (nodeReaction.getNodeName().equalsIgnoreCase("celldesigner:baseProducts")) {
                reactantsNodes = nodeReaction.getChildNodes();
                for (z = 0; z < reactantsNodes.getLength(); ++z) {
                    reactantNode = reactantsNodes.item(z);
                    if (reactantNode.getNodeType() != 1) continue;
                    if (reactantNode.getNodeName().equalsIgnoreCase("celldesigner:baseProduct")) {
                        this.parseBaseProduct(model, result, reactantNode);
                        continue;
                    }
                    this.logger.debug("Unknown element of celldesigner:baseProducts: " + node.getNodeName());
                }
                continue;
            }
            if (nodeReaction.getNodeName().equalsIgnoreCase("celldesigner:line")) {
                line = this.getLineProperties(nodeReaction);
                continue;
            }
            if (nodeReaction.getNodeName().equalsIgnoreCase("celldesigner:connectScheme")) {
                connectScheme = this.parseConnectScheme(nodeReaction);
                continue;
            }
            if (nodeReaction.getNodeName().equalsIgnoreCase("celldesigner:listOfReactantLinks")) {
                reactantsLinkNode = nodeReaction;
                continue;
            }
            if (nodeReaction.getNodeName().equalsIgnoreCase("celldesigner:listOfProductLinks")) {
                productsLinkNode = nodeReaction;
                continue;
            }
            if (nodeReaction.getNodeName().equalsIgnoreCase("celldesigner:listOfModification")) {
                modifiersLinkNode = nodeReaction;
                continue;
            }
            if (nodeReaction.getNodeName().equalsIgnoreCase("celldesigner:editPoints")) {
                points = this.parseEditPoints(nodeReaction);
                continue;
            }
            if (nodeReaction.getNodeName().equalsIgnoreCase("celldesigner:name")) {
                result.setName(this.getNodeValue(nodeReaction));
                continue;
            }
            if (nodeReaction.getNodeName().equalsIgnoreCase("celldesigner:listOfGateMember")) {
                gateMembers = nodeReaction;
                continue;
            }
            this.logger.debug("Unknown element of reaction/celldesigner:extension: " + nodeReaction.getNodeName());
        }
        if (gateMembers != null) {
            points = this.gateMembersToPoints(gateMembers);
        }
        result = this.createProperTypeReaction(type, result);
        if (connectScheme == null) {
            throw new InvalidXmlSchemaException("No connectScheme node");
        }
        if (points == null) {
            points = new EditPoints();
        }
        if (result instanceof SimpleReactionInterface) {
            this.createLinesForSimpleReaction(result, points, connectScheme);
        } else if (result instanceof TwoReactantReactionInterface) {
            this.createLinesForTwoReactantReaction(result, points, gateMembers != null);
            this.createOperatorsForTwoReactantReaction(result, gateMembers);
        } else if (result instanceof TwoProductReactionInterface) {
            this.createLinesForTwoProductReaction(result, points);
            this.createOperatorsForTwoProductReaction(result);
        } else {
            throw new InvalidXmlSchemaException("Problem with parsing lines. Unknown reaction type (" + result.getIdReaction() + "): " + type + "; " + result.getClass().getName());
        }
        if (reactantsLinkNode != null) {
            this.parseReactantLinks(result, reactantsLinkNode, model);
        }
        if (productsLinkNode != null) {
            this.parseProductLinks(result, productsLinkNode, model);
        }
        this.createOperators(result);
        if (modifiersLinkNode != null) {
            this.parseReactionModification(result, modifiersLinkNode, model);
        }
        for (int i = 0; i < result.getModifiers().size(); ++i) {
            Modifier modifier = result.getModifiers().get(i);
            if (modifier.getAlias() == null) {
                ArrayList<Modifier> modifiers = new ArrayList<Modifier>();
                modifiers.add(modifier);
                for (Modifier modifier2 : result.getModifiers()) {
                    if (this.modifierParentOperator.get(modifier2) != modifier) continue;
                    modifiers.add(modifier2);
                }
                this.computeLineForModification(result, modifiers);
                this.createOperatorFromModifiers(result, modifiers);
                result.removeModifier(modifier);
                --i;
                continue;
            }
            if (modifier.getLine() != null) continue;
            this.createLineForModifier(result, modifier);
        }
        if (line != null) {
            for (AbstractNode rNode : result.getNodes()) {
                rNode.getLine().setWidth(line.getWidth());
                rNode.getLine().setColor(line.getColor());
            }
        }
        if (result.isReversible()) {
            for (Reactant reactant : result.getReactants()) {
                reactant.getLine().getBeginAtd().setArrowType(result.getProducts().get(0).getLine().getEndAtd().getArrowType());
            }
        }
        return result;
    }

    private Reaction createProperTypeReaction(String type, Reaction result) throws UnknownReactionClassException {
        ReactionLineData rdl = ReactionLineData.getByCellDesignerString(type);
        if (rdl == null) {
            throw new UnknownReactionClassException("Unknown CellDesigner class type: " + type + ". Reaction id: " + result.getIdReaction(), type, result.getIdReaction());
        }
        return rdl.createReaction(result);
    }

    private EditPoints gateMembersToPoints(Node gateMembers) {
        Node lastMember = null;
        EditPoints result = new EditPoints();
        Integer num0 = null;
        Integer num1 = null;
        Integer num2 = null;
        for (int i = 0; i < gateMembers.getChildNodes().getLength(); ++i) {
            Node child = gateMembers.getChildNodes().item(i);
            if (child.getNodeType() != 1) continue;
            if (child.getNodeName().equalsIgnoreCase("celldesigner:GateMember")) {
                String type = this.getNodeAttr("type", child);
                if (type.startsWith(ReactionLineData.BOOLEAN_LOGIC_GATE.getCellDesignerString())) {
                    lastMember = child;
                    continue;
                }
                String pointsString = this.getNodeAttr("editPoints", child);
                ArrayList<Point2D> points = this.parseEditPointsString(pointsString);
                if (num0 == null) {
                    num0 = points.size();
                } else if (num1 == null) {
                    num1 = points.size();
                } else {
                    throw new InvalidStateException();
                }
                result.getPoints().addAll(points);
                continue;
            }
            this.logger.warn("Unknown node type: " + child.getNodeName());
        }
        if (lastMember == null) {
            throw new InvalidStateException();
        }
        String pointsString = this.getNodeAttr("editPoints", lastMember);
        ArrayList<Point2D> points = this.parseEditPointsString(pointsString);
        num2 = points.size() - 1;
        result.getPoints().addAll(points);
        result.setNum0(num0);
        result.setNum1(num1);
        result.setNum2(num2);
        return result;
    }

    private void createLineForModifier(Reaction reaction, Modifier modifier) {
        Alias alias = modifier.getAlias();
        CellDesignerAliasConverter converter = new CellDesignerAliasConverter(alias);
        Point2D startPoint = converter.getPointCoordinates(alias, this.anchorsByNodes.get(modifier));
        ModifierTypeUtils modifierTypeUtils = new ModifierTypeUtils();
        Point2D p = modifierTypeUtils.getAnchorPointOnReactionRect(modifier.getReaction(), this.lineTypeByModifier.get(modifier));
        PolylineData line = PolylineDataFactory.createPolylineDataFromEditPoints(startPoint, p, this.pointsByModifier.get(modifier));
        startPoint = converter.getAnchorPointCoordinates(alias, this.anchorsByNodes.get(modifier), line);
        line.setStartPoint(startPoint);
        modifier.setLine(line);
        modifierTypeUtils.updateLineEndPoint(modifier);
    }

    private void createOperatorsForTwoProductReaction(Reaction result) {
        int inputs = 0;
        NodeOperator operator = null;
        if (result.getClass() == DissociationReaction.class) {
            operator = new DissociationOperator();
        } else if (result.getClass() == TruncationReaction.class) {
            operator = new TruncationOperator();
        } else {
            throw new InvalidArgumentException("Invalid reaction type");
        }
        for (AbstractNode node : result.getNodes()) {
            if (node.getClass() == Product.class) {
                operator.addOutput(node);
                continue;
            }
            if (node.getClass() != Product.class || ++inputs <= 1) continue;
            throw new InvalidArgumentException("Reaction has more than one product");
        }
        if (operator.getOutputs().size() > 2) {
            throw new InvalidArgumentException("Too many ouputs...");
        }
        Reactant reactant = result.getReactants().get(0);
        Integer index = this.indexByComplexReaction.get(reactant);
        Point2D p1 = reactant.getLine().getPoints().get(index);
        Point2D p2 = reactant.getLine().getPoints().get(index + 1);
        p1 = new Point2D.Double(p1.getX(), p1.getY());
        p2 = new Point2D.Double(p2.getX(), p2.getY());
        Point2D.Double p = new Point2D.Double((p2.getX() + p1.getX()) / 2.0, (p2.getY() + p1.getY()) / 2.0);
        operator.setLine(reactant.getLine().getSubline(0, index + 1));
        operator.getLine().addPoint(p);
        p = new Point2D.Double((p2.getX() + p1.getX()) / 2.0, (p2.getY() + p1.getY()) / 2.0);
        reactant.setLine(reactant.getLine().getSubline(index + 1, reactant.getLine().getPoints().size()).reverse());
        reactant.getLine().getPoints().add(p);
        reactant.getLine().trimEnd(4.0);
        operator.getLine().trimEnd(4.0);
        result.addNode(operator);
    }

    private void createOperators(Reaction result) {
        Point2D p1 = result.getReactants().get(0).getLine().getPoints().get(result.getReactants().get(0).getLine().getPoints().size() - 2);
        Point2D p2 = result.getProducts().get(0).getLine().getPoints().get(1);
        Point2D tmp = result.getProducts().get(0).getLine().getPoints().get(0);
        Point2D.Double productSplitOperatorBeginPoint = new Point2D.Double(tmp.getX(), tmp.getY());
        tmp = result.getReactants().get(0).getLine().getPoints().get(result.getReactants().get(0).getLine().getPoints().size() - 1);
        Point2D.Double reactantAndOperatorEndPoint = new Point2D.Double(tmp.getX(), tmp.getY());
        HashSet<AbstractNode> toExclude = new HashSet<AbstractNode>();
        HashSet<NodeOperator> toInclude = new HashSet<NodeOperator>();
        for (NodeOperator operator : result.getOperators()) {
            toExclude.addAll(operator.getInputs());
            if (operator.isReactantOperator()) {
                toInclude.add(operator);
                p1 = operator.getLine().getPoints().get(operator.getLine().getPoints().size() - 2);
                tmp = operator.getLine().getPoints().get(operator.getLine().getPoints().size() - 1);
                reactantAndOperatorEndPoint = new Point2D.Double(tmp.getX(), tmp.getY());
            }
            if (!operator.isProductOperator()) continue;
            p2 = operator.getLine().getPoints().get(operator.getLine().getPoints().size() - 2);
            tmp = operator.getLine().getPoints().get(operator.getLine().getPoints().size() - 1);
            productSplitOperatorBeginPoint = new Point2D.Double(tmp.getX(), tmp.getY());
        }
        double dx = p2.getX() - p1.getX();
        double dy = p2.getY() - p1.getY();
        Point2D.Double reactantAndOperatorBeginPoint = new Point2D.Double(p1.getX() + dx * 0.4, p1.getY() + dy * 0.4);
        PolylineData ld = new PolylineData(reactantAndOperatorBeginPoint, reactantAndOperatorEndPoint);
        LineType lineType = null;
        LinkedHashSet<AbstractNode> nodes = new LinkedHashSet<AbstractNode>();
        for (Reactant reactant : result.getReactants()) {
            if (toExclude.contains(reactant)) continue;
            nodes.add(reactant);
            if (lineType != null) continue;
            lineType = reactant.getLine().getType();
        }
        nodes.addAll(toInclude);
        nodes.removeAll(toExclude);
        if (nodes.size() > 1) {
            AndOperator inputOperator = new AndOperator();
            inputOperator.setLine(ld);
            inputOperator.addInputs(nodes);
            for (Reactant reactant : result.getReactants()) {
                if (toExclude.contains(reactant)) continue;
                reactant.getLine().getEndPoint().setLocation(((Point2D)reactantAndOperatorBeginPoint).getX(), ((Point2D)reactantAndOperatorBeginPoint).getY());
            }
            if (lineType != null) {
                inputOperator.getLine().setType(lineType);
            }
            result.addNode(inputOperator);
        }
        toExclude = new HashSet();
        toInclude = new HashSet();
        for (NodeOperator nodeOperator : result.getOperators()) {
            toExclude.addAll(nodeOperator.getOutputs());
            if (!nodeOperator.isProductOperator()) continue;
            toInclude.add(nodeOperator);
        }
        Point2D.Double productSplitOperatorEndPoint = new Point2D.Double(p1.getX() + dx * 0.6, p1.getY() + dy * 0.6);
        ld = new PolylineData(productSplitOperatorEndPoint, productSplitOperatorBeginPoint);
        lineType = null;
        nodes = new LinkedHashSet();
        for (Product product : result.getProducts()) {
            if (toExclude.contains(product)) continue;
            nodes.add(product);
            if (lineType != null) continue;
            lineType = product.getLine().getType();
        }
        nodes.addAll(toInclude);
        nodes.removeAll(toExclude);
        if (nodes.size() > 1) {
            SplitOperator splitOperator = new SplitOperator();
            splitOperator.setLine(ld);
            splitOperator.addOutputs(nodes);
            for (Product product : result.getProducts()) {
                if (toExclude.contains(product)) continue;
                product.getLine().getPoints().get(0).setLocation(((Point2D)productSplitOperatorEndPoint).getX(), ((Point2D)productSplitOperatorEndPoint).getY());
            }
            if (lineType != null) {
                splitOperator.getLine().setType(lineType);
            }
            result.addNode(splitOperator);
        }
    }

    private void createOperatorFromModifiers(Reaction reaction, List<Modifier> modifiers) {
        OperatorTypeUtils otu = new OperatorTypeUtils();
        String type = this.typeByModifier.get(modifiers.get(0));
        NodeOperator operator = otu.createModifierForStringType(type);
        if (operator == null) {
            throw new InvalidArgumentException("Unknown modifier type: " + type);
        }
        operator.setLine(modifiers.get(0).getLine());
        for (int i = 1; i < modifiers.size(); ++i) {
            operator.addInput(modifiers.get(i));
        }
        ModifierTypeUtils modifierTypeUtils = new ModifierTypeUtils();
        modifierTypeUtils.updateLineEndPoint(operator);
        reaction.addNode(operator);
    }

    private void createOperatorsForTwoReactantReaction(Reaction result, Node gateMembers) throws InvalidXmlSchemaException {
        AndOperator andOperator = new AndOperator();
        int outputs = 0;
        for (AbstractNode node : result.getNodes()) {
            if (node.getClass() == Reactant.class) {
                andOperator.addInput(node);
                continue;
            }
            if (node.getClass() != Product.class || ++outputs <= 1) continue;
            throw new InvalidArgumentException("Reaction has more than one product");
        }
        if (andOperator.getInputs().size() > 2) {
            throw new InvalidArgumentException("Too many inputs...");
        }
        Product product = result.getProducts().get(0);
        Integer index = this.indexByComplexReaction.get(product);
        if (index != null) {
            Point2D p1 = product.getLine().getPoints().get(index);
            Point2D p2 = product.getLine().getPoints().get(index + 1);
            p1 = new Point2D.Double(p1.getX(), p1.getY());
            p2 = new Point2D.Double(p2.getX(), p2.getY());
            Point2D.Double p = new Point2D.Double((p2.getX() + p1.getX()) / 2.0, (p2.getY() + p1.getY()) / 2.0);
            andOperator.setLine(product.getLine().getSubline(0, index + 1));
            andOperator.getLine().addPoint(p);
            andOperator.getLine().trimEnd(4.0);
            p = new Point2D.Double((p2.getX() + p1.getX()) / 2.0, (p2.getY() + p1.getY()) / 2.0);
            product.setLine(product.getLine().getSubline(index, product.getLine().getPoints().size()));
            product.getLine().getPoints().set(0, p);
            product.getLine().trimBegin(4.0);
            product.getLine().getEndAtd().setArrowType(ArrowType.FULL);
            result.addNode(andOperator);
        } else {
            NodeOperator operator = null;
            HashSet<String> undefinedTypes = new HashSet<String>();
            for (int i = 0; i < gateMembers.getChildNodes().getLength(); ++i) {
                Node child = gateMembers.getChildNodes().item(i);
                if (child.getNodeType() != 1 || !child.getNodeName().equalsIgnoreCase("celldesigner:GateMember")) continue;
                String type = this.getNodeAttr("type", child);
                if (type.equalsIgnoreCase(OperatorType.AND_OPERATOR_STRING.getStringName())) {
                    operator = new AndOperator();
                    continue;
                }
                if (type.equalsIgnoreCase(OperatorType.OR_OPERATOR_STRING.getStringName())) {
                    operator = new OrOperator();
                    continue;
                }
                if (type.equalsIgnoreCase(OperatorType.NAND_OPERATOR_STRING.getStringName())) {
                    operator = new NandOperator();
                    continue;
                }
                if (type.equalsIgnoreCase(OperatorType.UNKNOWN_OPERATOR_STRING.getStringName())) {
                    operator = new UnknownOperator();
                    continue;
                }
                undefinedTypes.add(type);
            }
            if (operator == null) {
                String types = "";
                for (String string : undefinedTypes) {
                    types = types + string + ", ";
                }
                throw new InvalidXmlSchemaException("Couldn't find type of BOOLEAN_LOGIC_GATE. Unknown types identified: " + types);
            }
            operator.addInputs(andOperator.getInputs());
            operator.addOutput(product);
            PolylineData line = new PolylineData();
            line.addPoint(product.getLine().getBeginPoint());
            line.addPoint(product.getLine().getBeginPoint());
            operator.setLine(line);
            result.addNode(operator);
        }
    }

    private void createLinesForTwoProductReaction(Reaction reaction, EditPoints points) {
        int num1;
        int num0;
        Point2D p = points.getPoints().get(points.size() - 1);
        Product product1 = reaction.getProducts().get(0);
        Product product2 = reaction.getProducts().get(1);
        Reactant reactant = reaction.getReactants().get(0);
        CellDesignerAliasConverter reactantConverter = new CellDesignerAliasConverter(reactant.getAlias());
        CellDesignerAliasConverter product1Converter = new CellDesignerAliasConverter(product1.getAlias());
        CellDesignerAliasConverter product2Converter = new CellDesignerAliasConverter(product2.getAlias());
        Point2D p1 = reactantConverter.getPointCoordinates(reactant.getAlias(), this.anchorsByNodes.get(reactant));
        Point2D p2 = product1Converter.getPointCoordinates(product1.getAlias(), this.anchorsByNodes.get(product1));
        Point2D p3 = product2Converter.getPointCoordinates(product2.getAlias(), this.anchorsByNodes.get(product2));
        Point2D centerPoint = this.pointTransformation.getCoordinatesInNormalBase(product1.getAlias().getCenter(), product2.getAlias().getCenter(), reactant.getAlias().getCenter(), p);
        int startId0 = 0;
        int startId1 = num0 = points.getNum0();
        int startId2 = num1 = num0 + points.getNum1();
        int num2 = num1 + points.getNum2();
        ArrayList<Point2D> linePoints1 = new ArrayList<Point2D>(points.getPoints().subList(startId0, num0));
        ArrayList<Point2D> linePoints2 = new ArrayList<Point2D>(points.getPoints().subList(startId1, num1));
        ArrayList<Point2D> linePoints3 = new ArrayList<Point2D>(points.getPoints().subList(startId2, num2));
        PolylineData product1Line = PolylineDataFactory.createPolylineDataFromEditPoints(centerPoint, p2, linePoints2);
        PolylineData product2Line = PolylineDataFactory.createPolylineDataFromEditPoints(centerPoint, p3, linePoints3);
        PolylineData reactantLine = PolylineDataFactory.createPolylineDataFromEditPoints(centerPoint, p1, linePoints1);
        p1 = product2Converter.getAnchorPointCoordinates(product2.getAlias(), this.anchorsByNodes.get(product2), product2Line.reverse());
        product2Line.setEndPoint(p1);
        p1 = product1Converter.getAnchorPointCoordinates(product1.getAlias(), this.anchorsByNodes.get(product1), product1Line.reverse());
        product1Line.setEndPoint(p1);
        p1 = reactantConverter.getAnchorPointCoordinates(reactant.getAlias(), this.anchorsByNodes.get(reactant), reactantLine.reverse());
        reactantLine.setEndPoint(p1);
        product2Line.getEndAtd().setArrowType(ArrowType.FULL);
        product1Line.getEndAtd().setArrowType(ArrowType.FULL);
        product1.setLine(product1Line);
        product2.setLine(product2Line);
        reactant.setLine(reactantLine);
        this.indexByComplexReaction.put(reactant, points.getIndex());
    }

    private void createLinesForTwoReactantReaction(Reaction reaction, EditPoints points, boolean hasGateMemebers) {
        int num1;
        int num0;
        Point2D p = points.getPoints().get(points.size() - 1);
        Product product = reaction.getProducts().get(0);
        Reactant reactant1 = reaction.getReactants().get(0);
        Reactant reactant2 = reaction.getReactants().get(1);
        CellDesignerAliasConverter productConverter = new CellDesignerAliasConverter(product.getAlias());
        CellDesignerAliasConverter reactantConverter1 = new CellDesignerAliasConverter(reactant1.getAlias());
        CellDesignerAliasConverter reactantConverter2 = new CellDesignerAliasConverter(reactant2.getAlias());
        Point2D p1 = reactantConverter1.getPointCoordinates(reactant1.getAlias(), this.anchorsByNodes.get(reactant1));
        Point2D p2 = reactantConverter2.getPointCoordinates(reactant2.getAlias(), this.anchorsByNodes.get(reactant2));
        Point2D p3 = productConverter.getPointCoordinates(product.getAlias(), this.anchorsByNodes.get(product));
        if (p1 == null || p2 == null || p3 == null) {
            this.logger.error("Point cannot be null");
            return;
        }
        Alias alias1 = reactant1.getAlias();
        Alias alias2 = reactant2.getAlias();
        Alias alias3 = product.getAlias();
        Point2D pointA = alias2.getCenter();
        Point2D pointC = alias1.getCenter();
        Point2D pointB = alias3.getCenter();
        Point2D pointP = p;
        Point2D centerPoint = null;
        centerPoint = !hasGateMemebers ? this.pointTransformation.getCoordinatesInNormalBase(pointA, pointB, pointC, pointP) : pointP;
        int startId0 = 0;
        int startId1 = num0 = points.getNum0();
        int startId2 = num1 = num0 + points.getNum1();
        int num2 = num1 + points.getNum2();
        ArrayList<Point2D> linePoints1 = new ArrayList<Point2D>(points.getPoints().subList(startId0, num0));
        ArrayList<Point2D> linePoints2 = new ArrayList<Point2D>(points.getPoints().subList(startId1, num1));
        ArrayList<Point2D> linePoints3 = new ArrayList<Point2D>(points.getPoints().subList(startId2, num2));
        PolylineData reactant1Line = null;
        PolylineData reactant2Line = null;
        if (!hasGateMemebers) {
            reactant1Line = PolylineDataFactory.createPolylineDataFromEditPoints(centerPoint, p1, linePoints1);
            reactant2Line = PolylineDataFactory.createPolylineDataFromEditPoints(centerPoint, p2, linePoints2);
        } else {
            reactant1Line = PolylineDataFactory.createPolylineDataFromEditPoints(p1, centerPoint, linePoints1);
            reactant1Line = reactant1Line.reverse();
            reactant2Line = PolylineDataFactory.createPolylineDataFromEditPoints(p2, centerPoint, linePoints2);
            reactant2Line = reactant2Line.reverse();
        }
        PolylineData productLine = PolylineDataFactory.createPolylineDataFromEditPoints(centerPoint, p3, linePoints3);
        p1 = reactantConverter1.getAnchorPointCoordinates(reactant1.getAlias(), this.anchorsByNodes.get(reactant1), reactant1Line.reverse());
        reactant1Line.setEndPoint(p1);
        reactant1Line = reactant1Line.reverse();
        p1 = reactantConverter2.getAnchorPointCoordinates(reactant2.getAlias(), this.anchorsByNodes.get(reactant2), reactant2Line.reverse());
        reactant2Line.setEndPoint(p1);
        reactant2Line = reactant2Line.reverse();
        p1 = productConverter.getAnchorPointCoordinates(product.getAlias(), this.anchorsByNodes.get(product), productLine.reverse());
        productLine.setEndPoint(p1);
        if (hasGateMemebers) {
            productLine.getEndAtd().setArrowType(ArrowType.OPEN);
        }
        product.setLine(productLine);
        reactant1.setLine(reactant1Line);
        reactant2.setLine(reactant2Line);
        this.indexByComplexReaction.put(product, points.getIndex());
    }

    private void createLinesForSimpleReaction(Reaction reaction, EditPoints editPoints, ConnectScheme scheme) {
        Product product = reaction.getProducts().get(0);
        Reactant reactant = reaction.getReactants().get(0);
        CellDesignerAliasConverter productConverter = new CellDesignerAliasConverter(product.getAlias());
        CellDesignerAliasConverter reactantConverter = new CellDesignerAliasConverter(reactant.getAlias());
        Point2D endPoint = productConverter.getPointCoordinates(product.getAlias(), this.anchorsByNodes.get(product));
        Point2D startPoint = reactantConverter.getPointCoordinates(reactant.getAlias(), this.anchorsByNodes.get(reactant));
        PolylineData ld = PolylineDataFactory.createPolylineDataFromEditPoints(startPoint, endPoint, editPoints.getPoints());
        Integer index = editPoints.getIndex();
        if (index == null && (index = scheme.getConnectIndex()) != null) {
            index = ld.getPoints().size() - index - 2;
        }
        if (index == null) {
            index = 0;
        }
        startPoint = reactantConverter.getAnchorPointCoordinates(reactant.getAlias(), this.anchorsByNodes.get(reactant), ld);
        endPoint = productConverter.getAnchorPointCoordinates(product.getAlias(), this.anchorsByNodes.get(product), ld.reverse());
        ld.getPoints().set(0, startPoint);
        ld.getPoints().set(ld.getPoints().size() - 1, endPoint);
        PolylineData line = new PolylineData(ld);
        PolylineData reactantLine = line.getSubline(0, ld.getPoints().size() - index - 1);
        PolylineData productLine = line.getSubline(ld.getPoints().size() - index - 2, ld.getPoints().size());
        Point2D p1 = ld.getPoints().get(ld.getPoints().size() - index - 2);
        Point2D p2 = ld.getPoints().get(ld.getPoints().size() - index - 1);
        Point2D.Double p = new Point2D.Double((p2.getX() + p1.getX()) / 2.0, (p2.getY() + p1.getY()) / 2.0);
        reactantLine.getPoints().add(p);
        reactantLine.trimEnd(4.0);
        p = new Point2D.Double((p2.getX() + p1.getX()) / 2.0, (p2.getY() + p1.getY()) / 2.0);
        productLine.getPoints().set(0, p);
        productLine.trimBegin(4.0);
        productLine.getEndAtd().setArrowType(ArrowType.FULL);
        reactant.setLine(reactantLine);
        product.setLine(productLine);
        ReactionLineData rld = ReactionLineData.getByReactionType(reaction.getClass());
        reactantLine.setType(rld.getLineType());
        productLine.setType(rld.getLineType());
        productLine.getEndAtd().setArrowType(rld.getProductArrowType());
        productLine.trimEnd(rld.getProductLineTrim());
    }

    private EditPoints parseEditPoints(Node rootNode) {
        String index;
        EditPoints result = new EditPoints();
        String num0 = this.getNodeAttr("num0", rootNode);
        String num1 = this.getNodeAttr("num1", rootNode);
        String num2 = this.getNodeAttr("num2", rootNode);
        if (!num0.equals("")) {
            result.setNum0(Integer.parseInt(num0));
        }
        if (!num1.equals("")) {
            result.setNum1(Integer.parseInt(num1));
        }
        if (!num2.equals("")) {
            result.setNum2(Integer.parseInt(num2));
        }
        if (!(index = this.getNodeAttr("tShapeIndex", rootNode)).equals("")) {
            result.setIndex(Integer.parseInt(index));
        }
        String pointsString = this.getNodeValue(rootNode);
        result.setPoints(this.parseEditPointsString(pointsString));
        return result;
    }

    private ArrayList<Point2D> parseEditPointsString(String pointsString) {
        String[] points;
        ArrayList<Point2D> points2 = new ArrayList<Point2D>();
        if (pointsString.trim().equals("")) {
            return points2;
        }
        for (String string : points = pointsString.trim().split(" ")) {
            String[] p = string.split(",");
            if (p.length != 2) {
                this.logger.debug("Invalid editPoint string: " + string);
                continue;
            }
            double posX = Double.parseDouble(p[0]);
            double posY = Double.parseDouble(p[1]);
            points2.add(new Point2D.Double(posX, posY));
        }
        return points2;
    }

    private void parseReactantLinks(Reaction result, Node rootNode, Model model) throws InvalidXmlSchemaException {
        NodeList list = rootNode.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equalsIgnoreCase("celldesigner:reactantLink")) {
                Reactant newReactant = this.getReactantLink(node, model, result);
                result.addReactant(newReactant);
                continue;
            }
            this.logger.debug("Unknown element of celldesigner:listOfReactantLinks: " + node.getNodeName());
        }
    }

    private Reactant getReactantLink(Node rootNode, Model model, Reaction reaction) throws InvalidXmlSchemaException {
        String speciesId = this.getNodeAttr("reactant", rootNode);
        String aliasId = this.getNodeAttr("alias", rootNode);
        Species sp = model.getSpeciesBySpeciesId(speciesId);
        if (sp == null) {
            throw new InvalidXmlSchemaException("Species doesn't exist (id: " + speciesId + ")");
        }
        SpeciesAlias al = (SpeciesAlias)model.getAliasByAliasId(aliasId);
        if (al == null) {
            throw new InvalidXmlSchemaException("Alias doesn't exist (id: " + aliasId + ")");
        }
        Reactant result = new Reactant(al, (Element)sp);
        CellDesignerAnchor anchor = null;
        EditPoints points = null;
        NodeList nodes = rootNode.getChildNodes();
        for (int x = 0; x < nodes.getLength(); ++x) {
            Node node = nodes.item(x);
            if (node.getNodeType() != 1 || node.getNodeName().equalsIgnoreCase("celldesigner:connectScheme")) continue;
            if (node.getNodeName().equalsIgnoreCase("celldesigner:linkAnchor")) {
                anchor = CellDesignerAnchor.valueOf(this.getNodeAttr("position", node).toUpperCase());
                continue;
            }
            if (node.getNodeName().equalsIgnoreCase("celldesigner:line")) continue;
            if (node.getNodeName().equalsIgnoreCase("celldesigner:editPoints")) {
                points = this.parseEditPoints(node);
                continue;
            }
            this.logger.debug("Unknown element of celldesigner:reactantLink: " + node.getNodeName());
        }
        CellDesignerAliasConverter reactantConverter = new CellDesignerAliasConverter(al);
        Point2D additionalPoint = reactantConverter.getPointCoordinates(al, anchor);
        ArrowTypeData atd = new ArrowTypeData();
        atd.setArrowType(ArrowType.NONE);
        Line2D centerLine = reaction.getCenterLine();
        double dx = centerLine.getX2() - centerLine.getX1();
        double dy = centerLine.getY2() - centerLine.getY1();
        double coef = 0.4;
        Point2D.Double endPoint = new Point2D.Double(centerLine.getX1() + dx * coef, centerLine.getY1() + dy * coef);
        PolylineData polyline = PolylineDataFactory.createPolylineDataFromEditPoints(additionalPoint, (Point2D)endPoint, points);
        additionalPoint = reactantConverter.getAnchorPointCoordinates(al, anchor, polyline);
        polyline.setStartPoint(additionalPoint);
        result.setLine(polyline);
        return result;
    }

    private void parseProductLinks(Reaction result, Node rootNode, Model model) throws InvalidXmlSchemaException {
        NodeList list = rootNode.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equalsIgnoreCase("celldesigner:productLink")) {
                Product link = this.getProductLink(node, model, result);
                result.addProduct(link);
                continue;
            }
            this.logger.debug("Unknown element of celldesigner:listOfProductLinks: " + node.getNodeName());
        }
    }

    private Product getProductLink(Node rootNode, Model model, Reaction reaction) throws InvalidXmlSchemaException {
        String speciesId = this.getNodeAttr("product", rootNode);
        String aliasId = this.getNodeAttr("alias", rootNode);
        Species sp = model.getSpeciesBySpeciesId(speciesId);
        if (sp == null) {
            throw new InvalidXmlSchemaException("Species doesn't exist (id: " + speciesId + " reactionId: " + reaction.getIdReaction() + ")");
        }
        SpeciesAlias al = (SpeciesAlias)model.getAliasByAliasId(aliasId);
        if (al == null) {
            throw new InvalidXmlSchemaException("Alias doesn't exist (id: " + aliasId + ")");
        }
        Product result = new Product(al, (Element)sp);
        CellDesignerAnchor anchor = null;
        EditPoints points = null;
        NodeList nodes = rootNode.getChildNodes();
        for (int x = 0; x < nodes.getLength(); ++x) {
            Node node = nodes.item(x);
            if (node.getNodeType() != 1 || node.getNodeName().equalsIgnoreCase("celldesigner:connectScheme")) continue;
            if (node.getNodeName().equalsIgnoreCase("celldesigner:linkAnchor")) {
                anchor = CellDesignerAnchor.valueOf(this.getNodeAttr("position", node).toUpperCase());
                continue;
            }
            if (node.getNodeName().equalsIgnoreCase("celldesigner:line")) continue;
            if (node.getNodeName().equalsIgnoreCase("celldesigner:editPoints")) {
                points = this.parseEditPoints(node);
                continue;
            }
            this.logger.debug("Unknown element of celldesigner:reactantLink: " + node.getNodeName());
        }
        CellDesignerAliasConverter reactantConverter = new CellDesignerAliasConverter(al);
        Point2D additionalPoint = reactantConverter.getPointCoordinates(al, anchor);
        ArrowTypeData atd = new ArrowTypeData();
        atd.setArrowType(ArrowType.NONE);
        Point2D p1 = reaction.getReactants().get(0).getLine().getPoints().get(reaction.getReactants().get(0).getLine().getPoints().size() - 2);
        Point2D p2 = reaction.getProducts().get(0).getLine().getPoints().get(1);
        HashSet<AbstractNode> toExclude = new HashSet<AbstractNode>();
        HashSet<NodeOperator> toInclude = new HashSet<NodeOperator>();
        for (NodeOperator operator : reaction.getOperators()) {
            toExclude.addAll(operator.getInputs());
            if (operator.isReactantOperator()) {
                toInclude.add(operator);
                p1 = operator.getLine().getPoints().get(operator.getLine().getPoints().size() - 2);
            }
            if (!operator.isProductOperator()) continue;
            p2 = operator.getLine().getPoints().get(operator.getLine().getPoints().size() - 2);
        }
        double dx = p2.getX() - p1.getX();
        double dy = p2.getY() - p1.getY();
        double coef = 0.6;
        Point2D.Double endPoint = new Point2D.Double(p1.getX() + dx * coef, p1.getY() + dy * coef);
        PolylineData polyline = PolylineDataFactory.createPolylineDataFromEditPoints((Point2D)endPoint, additionalPoint, points);
        additionalPoint = reactantConverter.getAnchorPointCoordinates(al, anchor, polyline.reverse());
        polyline.setEndPoint(additionalPoint);
        polyline.getEndAtd().setArrowType(ArrowType.FULL);
        result.setLine(polyline);
        return result;
    }

    private LineProperties getLineProperties(Node node) {
        LineProperties line = new LineProperties();
        String tmp = this.getNodeAttr("width", node);
        line.setWidth(Double.parseDouble(tmp));
        tmp = this.getNodeAttr("color", node);
        line.setColor(this.stringToColor(tmp));
        line.setType(this.getNodeAttr("type", node));
        return line;
    }

    private void parseReactionModification(Reaction result, Node rootNode, Model model) {
        NodeList nodes = rootNode.getChildNodes();
        for (int x = 0; x < nodes.getLength(); ++x) {
            Node node = nodes.item(x);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equalsIgnoreCase("celldesigner:modification")) {
                this.parseModificationReaction(result, node, model);
                continue;
            }
            this.logger.debug("Unknown element of celldesigner:listOfModification: " + node.getNodeName());
        }
    }

    private void parseModificationReaction(Reaction reaction, Node rootNode, Model model) {
        ModifierTypeUtils modifierTypeUtils = new ModifierTypeUtils();
        String type = this.getNodeAttr("type", rootNode);
        String modificationType = this.getNodeAttr("modificationType", rootNode);
        String speciesId = this.getNodeAttr("modifiers", rootNode);
        String aliasId = this.getNodeAttr("aliases", rootNode);
        String lineConnectionType = this.getNodeAttr("targetLineIndex", rootNode);
        String points = this.getNodeAttr("editPoints", rootNode);
        String[] list = speciesId.split(",");
        ArrayList<Species> speciesList = new ArrayList<Species>();
        ArrayList<SpeciesAlias> aliasList = new ArrayList<SpeciesAlias>();
        for (String string : list) {
            Species sp = model.getSpeciesBySpeciesId(string);
            if (sp != null) {
                speciesList.add(sp);
                continue;
            }
            this.logger.debug("Unknown species: " + string);
        }
        for (String string : list = aliasId.split(",")) {
            SpeciesAlias al = (SpeciesAlias)model.getAliasByAliasId(string);
            if (al != null) {
                aliasList.add(al);
                continue;
            }
            this.logger.debug("Unknown species: " + aliasId);
        }
        if (speciesList.size() == 0 || speciesList.size() != aliasList.size()) {
            throw new InvalidArgumentException();
        }
        Modifier result = null;
        if (speciesList.size() > 1) {
            result = new Modifier(null, null);
            reaction.addModifier(result);
            for (int i = 0; i < speciesList.size(); ++i) {
                Modifier mod = modifierTypeUtils.createModifierForStringType(modificationType, (SpeciesAlias)aliasList.get(i), (Element)speciesList.get(i));
                this.modifierParentOperator.put(mod, result);
                reaction.addModifier(mod);
            }
        } else {
            for (Modifier modifier : reaction.getModifiers()) {
                if (modifier.getElement() != speciesList.get(0) || modifier.getAlias() != aliasList.get(0)) continue;
                result = modifier;
            }
            if (result == null) {
                result = modifierTypeUtils.createModifierForStringType(type, (SpeciesAlias)aliasList.get(0), (Element)speciesList.get(0));
                reaction.addModifier(result);
            }
        }
        this.pointsByModifier.put(result, this.parseEditPointsString(points));
        this.typeByModifier.put(result, type);
        this.lineTypeByModifier.put(result, lineConnectionType);
        NodeList nodes = rootNode.getChildNodes();
        for (int x = 0; x < nodes.getLength(); ++x) {
            Node node = nodes.item(x);
            if (node.getNodeType() != 1 || node.getNodeName().equalsIgnoreCase("celldesigner:connectScheme") || node.getNodeName().equalsIgnoreCase("celldesigner:line")) continue;
            if (node.getNodeName().equalsIgnoreCase("celldesigner:linkTarget")) {
                CellDesignerAnchor anchor = this.getAnchorFromLinkTarget(node);
                this.anchorsByNodes.put(result, anchor);
                continue;
            }
            this.logger.debug("Unknown element of celldesigner:listOfModification: " + node.getNodeName());
        }
    }

    private void computeLineForModification(Reaction reaction, List<Modifier> modifiers) {
        ModifierTypeUtils modifierTypeUtils = new ModifierTypeUtils();
        Point2D p = modifierTypeUtils.getAnchorPointOnReactionRect(reaction, this.lineTypeByModifier.get(modifiers.get(0)));
        if (modifiers.size() > 1) {
            Modifier modifier = modifiers.get(0);
            List<Point2D> points = this.pointsByModifier.get(modifier);
            Point2D startPoint = points.get(points.size() - 1);
            List<Point2D> subPoints = points.subList(0, points.size() - 1);
            PolylineData line = PolylineDataFactory.createPolylineDataFromEditPoints(startPoint, p, subPoints);
            modifiers.get(0).setLine(line);
            Point2D endPoint = startPoint;
            for (int i = 1; i < modifiers.size(); ++i) {
                Modifier param = modifiers.get(i);
                CellDesignerAliasConverter reactantConverter = new CellDesignerAliasConverter(param.getAlias());
                startPoint = reactantConverter.getPointCoordinates(param.getAlias(), this.anchorsByNodes.get(param));
                PolylineData polyline = PolylineDataFactory.createPolylineDataFromEditPoints(startPoint, endPoint, this.pointsByModifier.get(param));
                startPoint = reactantConverter.getAnchorPointCoordinates(param.getAlias(), this.anchorsByNodes.get(param), polyline);
                polyline.setStartPoint(startPoint);
                param.setLine(polyline);
            }
        } else {
            List<Point2D> points;
            Modifier modifier = modifiers.get(0);
            Alias alias = modifier.getAlias();
            CellDesignerAliasConverter converter = new CellDesignerAliasConverter(alias);
            Point2D startPoint = converter.getPointCoordinates(alias, this.anchorsByNodes.get(modifier));
            List<Point2D> subPoints = points = this.pointsByModifier.get(modifier);
            PolylineData polyline = PolylineDataFactory.createPolylineDataFromEditPoints(startPoint, p, subPoints);
            startPoint = converter.getAnchorPointCoordinates(alias, this.anchorsByNodes.get(modifier), polyline);
            polyline.setStartPoint(startPoint);
            modifier.setLine(polyline);
        }
    }

    private CellDesignerAnchor getAnchorFromLinkTarget(Node rootNode) {
        CellDesignerAnchor result = null;
        NodeList nodes = rootNode.getChildNodes();
        for (int z = 0; z < nodes.getLength(); ++z) {
            Node node = nodes.item(z);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equalsIgnoreCase("celldesigner:linkAnchor")) {
                result = CellDesignerAnchor.valueOf(this.getNodeAttr("position", node).toUpperCase());
                continue;
            }
            this.logger.debug("Unknown element of celldesigner:connectScheme: " + node.getNodeName());
        }
        return result;
    }

    private ConnectScheme parseConnectScheme(Node nodeReaction) {
        ConnectScheme result = new ConnectScheme();
        result.setConnectPolicy(this.getNodeAttr("connectPolicy", nodeReaction));
        result.setConnectIndex(this.getNodeAttr("rectangleIndex", nodeReaction));
        NodeList reactantsNodes = nodeReaction.getChildNodes();
        for (int z = 0; z < reactantsNodes.getLength(); ++z) {
            Node reactantNode = reactantsNodes.item(z);
            if (reactantNode.getNodeType() != 1) continue;
            if (reactantNode.getNodeName().equalsIgnoreCase("celldesigner:listOfLineDirection")) {
                result.setLineDirections(this.getlineDirectionMapForReactions(reactantNode));
                continue;
            }
            this.logger.debug("Unknown element of celldesigner:connectScheme: " + nodeReaction.getNodeName());
        }
        return result;
    }

    private Map<String, String> getlineDirectionMapForReactions(Node reactantNode) {
        HashMap<String, String> result = new HashMap<String, String>();
        NodeList nodes = reactantNode.getChildNodes();
        for (int x = 0; x < nodes.getLength(); ++x) {
            Node node = nodes.item(x);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equalsIgnoreCase("celldesigner:lineDirection")) {
                String index = this.getNodeAttr("index", node);
                String value = this.getNodeAttr("value", node);
                result.put(index, value);
                continue;
            }
            this.logger.debug("Unknown element of reaction/celldesigner:baseReactant: " + node.getNodeName());
        }
        return result;
    }

    private void parseBaseReactant(Reaction result, Node reactantNode, Model model) {
        String speciesId = this.getNodeAttr("species", reactantNode);
        String aliasId = this.getNodeAttr("alias", reactantNode);
        SpeciesAlias alias = (SpeciesAlias)model.getAliasByAliasId(aliasId);
        if (alias == null) {
            throw new InvalidArgumentException("Alias with id=" + aliasId + " doesn't exist.");
        }
        Species species = model.getSpeciesBySpeciesId(speciesId);
        if (species == null) {
            throw new InvalidArgumentException("Species with id=" + speciesId + " doesn't exist.");
        }
        Reactant reactant = new Reactant(alias, (Element)species);
        result.addReactant(reactant);
        NodeList nodes = reactantNode.getChildNodes();
        for (int x = 0; x < nodes.getLength(); ++x) {
            Node node = nodes.item(x);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equalsIgnoreCase("celldesigner:linkAnchor")) {
                this.anchorsByNodes.put(reactant, CellDesignerAnchor.valueOf(this.getNodeAttr("position", node)));
                continue;
            }
            this.logger.debug("Unknown element of reaction/celldesigner:baseReactant: " + node.getNodeName());
        }
    }

    private void parseBaseProduct(Model model, Reaction result, Node reactantNode) {
        String speciesId = this.getNodeAttr("species", reactantNode);
        String aliasId = this.getNodeAttr("alias", reactantNode);
        SpeciesAlias alias = (SpeciesAlias)model.getAliasByAliasId(aliasId);
        if (alias == null) {
            throw new InvalidArgumentException("Alias with id=" + aliasId + " doesn't exist.");
        }
        Species species = model.getSpeciesBySpeciesId(speciesId);
        if (species == null) {
            throw new InvalidArgumentException("Species with id=" + speciesId + " doesn't exist.");
        }
        Product product = new Product(alias, (Element)species);
        result.addProduct(product);
        NodeList nodes = reactantNode.getChildNodes();
        for (int x = 0; x < nodes.getLength(); ++x) {
            Node node = nodes.item(x);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equalsIgnoreCase("celldesigner:linkAnchor")) {
                this.anchorsByNodes.put(product, CellDesignerAnchor.valueOf(this.getNodeAttr("position", node)));
                continue;
            }
            this.logger.debug("Unknown element of reaction/celldesigner:baseProduct: " + node.getNodeName());
        }
    }
}

