/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.converter.model.celldesigner.geometry;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import lcsb.mapviewer.converter.model.celldesigner.geometry.AbstractCellDesignerAliasConverter;
import lcsb.mapviewer.converter.model.celldesigner.geometry.helper.CellDesignerAnchor;
import lcsb.mapviewer.model.map.layout.alias.Alias;
import lcsb.mapviewer.model.map.layout.alias.SpeciesAlias;
import lcsb.mapviewer.model.map.species.GenericProtein;
import lcsb.mapviewer.model.map.species.IonChannelProtein;
import lcsb.mapviewer.model.map.species.Protein;
import lcsb.mapviewer.model.map.species.ReceptorProtein;
import lcsb.mapviewer.model.map.species.TruncatedProtein;
import org.apache.log4j.Logger;

public class ProteinCellDesignerAliasConverter
extends AbstractCellDesignerAliasConverter<SpeciesAlias> {
    private static Logger logger = Logger.getLogger(ProteinCellDesignerAliasConverter.class);
    private static final int GENERIC_PROTEIN_RECTANGLE_CORNER_ARC_SIZE = 10;

    @Override
    public Point2D getPointCoordinates(SpeciesAlias alias, CellDesignerAnchor anchor) {
        Point2D result = null;
        if (this.invalidAnchorPosition(alias, anchor)) {
            result = alias.getCenter();
        } else {
            Protein protein = (Protein)alias.getSpecies();
            int homodir = protein.getHomodimer();
            alias.setWidth(alias.getWidth() - (double)(6 * (homodir - 1)));
            alias.setHeight(alias.getHeight() - (double)(6 * (homodir - 1)));
            if (alias.getSpecies() instanceof GenericProtein) {
                result = this.getRectangleTransformation().getPointOnRectangleByAnchor(alias.getX(), alias.getY(), alias.getWidth(), alias.getHeight(), anchor);
            } else if (alias.getSpecies() instanceof ReceptorProtein) {
                ArrayList<Point2D> points = this.getReceptorPoints(alias);
                result = this.getPolygonTransformation().getPointOnPolygonByAnchor(points, anchor);
            } else if (alias.getSpecies() instanceof IonChannelProtein) {
                result = this.getRectangleTransformation().getPointOnRectangleByAnchor(alias.getX(), alias.getY(), alias.getWidth(), alias.getHeight(), anchor);
            } else if (alias.getSpecies() instanceof TruncatedProtein) {
                ArrayList<Point2D> points = this.getTruncatedPoints(alias);
                result = this.getPolygonTransformation().getPointOnPolygonByAnchor(points, anchor);
            } else {
                logger.warn("Unknown type: " + alias.getSpecies().getClass() + ", " + alias.getSpecies().getIdSpecies());
                result = alias.getCenter();
            }
            alias.setWidth(alias.getWidth() + (double)(6 * (homodir - 1)));
            alias.setHeight(alias.getHeight() + (double)(6 * (homodir - 1)));
        }
        return result;
    }

    @Override
    public PathIterator getBoundPathIterator(SpeciesAlias alias) {
        if (alias.getSpecies() instanceof GenericProtein) {
            return this.getGenericShape(alias).getPathIterator(new AffineTransform());
        }
        if (alias.getSpecies() instanceof ReceptorProtein) {
            return this.getReceptorShape(alias).getPathIterator(new AffineTransform());
        }
        if (alias.getSpecies() instanceof IonChannelProtein) {
            return this.getGenericShape(alias).getPathIterator(new AffineTransform());
        }
        if (alias.getSpecies() instanceof TruncatedProtein) {
            return this.getTruncatedShape(alias).getPathIterator(new AffineTransform());
        }
        logger.warn("Not implemented protein converter for type: " + alias.getSpecies().getClass());
        logger.warn("Alias id: " + alias.getAliasId());
        logger.warn("Species id: " + alias.getSpecies().getIdSpecies());
        return null;
    }

    private Shape getGenericShape(Alias alias) {
        return new RoundRectangle2D.Double(alias.getX(), alias.getY(), alias.getWidth(), alias.getHeight(), 10.0, 10.0);
    }

    private ArrayList<Point2D> getTruncatedPoints(Alias alias) {
        double x = alias.getX();
        double y = alias.getY();
        double width = alias.getWidth();
        double height = alias.getHeight();
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        points.add(new Point2D.Double(x, y + height / 2.0));
        points.add(new Point2D.Double(x, y + height / 4.0));
        points.add(new Point2D.Double(x, y));
        points.add(new Point2D.Double(x + width / 4.0, y));
        points.add(new Point2D.Double(x + width / 2.0, y));
        points.add(new Point2D.Double(x + width * 3.0 / 4.0, y));
        points.add(new Point2D.Double(x + width, y));
        points.add(new Point2D.Double(x + width, y + height * 3.0 / 10.0));
        points.add(new Point2D.Double(x + width, y + height * 3.0 / 5.0));
        points.add(new Point2D.Double(x + width * 4.0 / 5.0, y + height * 2.0 / 5.0));
        points.add(new Point2D.Double(x + width * 4.0 / 5.0, y + height * 7.0 / 10.0));
        points.add(new Point2D.Double(x + width * 4.0 / 5.0, y + height));
        points.add(new Point2D.Double(x + width / 2.0, y + height));
        points.add(new Point2D.Double(x + width / 4.0, y + height));
        points.add(new Point2D.Double(x, y + height));
        points.add(new Point2D.Double(x, y + height * 3.0 / 4.0));
        return points;
    }

    protected Shape getReceptorShape(Alias alias) {
        GeneralPath path = new GeneralPath(0);
        ArrayList<Point2D> points = this.getReceptorPoints(alias);
        path.moveTo(points.get(0).getX(), points.get(0).getY());
        for (int i = 1; i < points.size(); ++i) {
            path.lineTo(points.get(i).getX(), points.get(i).getY());
        }
        path.closePath();
        GeneralPath shape = path;
        return shape;
    }

    protected Shape getTruncatedShape(Alias alias) {
        GeneralPath path = new GeneralPath();
        path.moveTo(alias.getX() + 10.0, alias.getY());
        path.lineTo(alias.getX() + alias.getWidth(), alias.getY());
        path.lineTo(alias.getX() + alias.getWidth(), alias.getY() + alias.getHeight() * 3.0 / 5.0);
        path.lineTo(alias.getX() + alias.getWidth() * 4.0 / 5.0, alias.getY() + alias.getHeight() * 2.0 / 5.0);
        path.lineTo(alias.getX() + alias.getWidth() * 4.0 / 5.0, alias.getY() + alias.getHeight());
        path.lineTo(alias.getX() + 10.0, alias.getY() + alias.getHeight());
        path.curveTo(alias.getX() + 5.0, alias.getY() + alias.getHeight() - 2.0, alias.getX() + 2.0, alias.getY() + alias.getHeight() - 5.0, alias.getX(), alias.getY() + alias.getHeight() - 10.0);
        path.lineTo(alias.getX(), alias.getY() + 10.0);
        path.curveTo(alias.getX() + 2.0, alias.getY() + 5.0, alias.getX() + 5.0, alias.getY() + 2.0, alias.getX() + 10.0, alias.getY());
        path.closePath();
        GeneralPath shape = path;
        return shape;
    }

    private ArrayList<Point2D> getReceptorPoints(Alias alias) {
        double x = alias.getX();
        double y = alias.getY();
        double width = alias.getWidth();
        double height = alias.getHeight();
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        points.add(new Point2D.Double(x, y + height * 2.0 / 5.0));
        points.add(new Point2D.Double(x, y));
        points.add(new Point2D.Double(x + width / 2.0, y + height / 5.0));
        points.add(new Point2D.Double(x + width, y));
        points.add(new Point2D.Double(x + width, y + height * 2.0 / 5.0));
        points.add(new Point2D.Double(x + width, y + height * 4.0 / 5.0));
        points.add(new Point2D.Double(x + width / 2.0, y + height));
        points.add(new Point2D.Double(x, y + height * 4.0 / 5.0));
        return points;
    }
}

