/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.converter.model.celldesigner.geometry;

import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import lcsb.mapviewer.converter.model.celldesigner.geometry.AbstractCellDesignerAliasConverter;
import lcsb.mapviewer.converter.model.celldesigner.geometry.helper.CellDesignerAnchor;
import lcsb.mapviewer.model.map.layout.alias.Alias;
import lcsb.mapviewer.model.map.layout.alias.SpeciesAlias;

public class PhenotypeCellDesignerAliasConverter
extends AbstractCellDesignerAliasConverter<SpeciesAlias> {
    @Override
    public Point2D getPointCoordinates(SpeciesAlias alias, CellDesignerAnchor anchor) {
        if (this.invalidAnchorPosition(alias, anchor)) {
            return alias.getCenter();
        }
        return this.getPolygonTransformation().getPointOnPolygonByAnchor(this.getPointsForAlias(alias), anchor);
    }

    private ArrayList<Point2D> getPointsForAlias(Alias alias) {
        ArrayList<Point2D> list = new ArrayList<Point2D>();
        double x = alias.getX();
        double y = alias.getY();
        double width = alias.getWidth();
        double height = alias.getHeight();
        list.add(new Point2D.Double(x, y + height / 2.0));
        list.add(new Point2D.Double(x + width / 6.0, y));
        list.add(new Point2D.Double(x + width / 2.0, y));
        list.add(new Point2D.Double(x + width * 5.0 / 6.0, y));
        list.add(new Point2D.Double(x + width, y + height / 2.0));
        list.add(new Point2D.Double(x + width * 5.0 / 6.0, y + height));
        list.add(new Point2D.Double(x + width / 2.0, y + height));
        list.add(new Point2D.Double(x + width / 6.0, y + height));
        return list;
    }

    @Override
    public PathIterator getBoundPathIterator(SpeciesAlias alias) {
        return this.getPhenotypePath(alias).getPathIterator(new AffineTransform());
    }

    private GeneralPath getPhenotypePath(Alias alias) {
        GeneralPath path = new GeneralPath(0, 6);
        path.moveTo(alias.getX() + alias.getWidth() / 6.0, alias.getY());
        path.lineTo(alias.getX() + alias.getWidth() * 5.0 / 6.0, alias.getY());
        path.lineTo(alias.getX() + alias.getWidth(), alias.getY() + alias.getHeight() / 2.0);
        path.lineTo(alias.getX() + alias.getWidth() * 5.0 / 6.0, alias.getY() + alias.getHeight());
        path.lineTo(alias.getX() + alias.getWidth() / 6.0, alias.getY() + alias.getHeight());
        path.lineTo(alias.getX(), alias.getY() + alias.getHeight() / 2.0);
        path.closePath();
        return path;
    }
}

