/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.converter.model.celldesigner.geometry;

import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import lcsb.mapviewer.common.exception.InvalidStateException;
import lcsb.mapviewer.converter.model.celldesigner.geometry.AbstractCellDesignerAliasConverter;
import lcsb.mapviewer.converter.model.celldesigner.geometry.helper.CellDesignerAnchor;
import lcsb.mapviewer.model.map.layout.alias.Alias;
import lcsb.mapviewer.model.map.layout.alias.SpeciesAlias;

public class DegradedCellDesignerAliasConverter
extends AbstractCellDesignerAliasConverter<SpeciesAlias> {
    private static final int DEGRADED_MARGIN = 7;

    @Override
    public Point2D getPointCoordinates(SpeciesAlias alias, CellDesignerAnchor anchor) {
        double diameter = this.getDiameter(alias);
        double x = this.getXCoord(alias, diameter);
        double y = this.getYCoord(alias);
        if (this.invalidAnchorPosition(alias, anchor)) {
            return alias.getCenter();
        }
        return this.getEllipseTransformation().getPointOnEllipseByAnchor(x, y, diameter, diameter, anchor);
    }

    private double getYCoord(Alias alias) {
        double y = alias.getY() + 7.0;
        return y;
    }

    private double getXCoord(Alias alias, double diameter) {
        double x = alias.getX() + (alias.getWidth() - diameter) / 2.0;
        return x;
    }

    private double getDiameter(Alias alias) {
        double diameter = Math.min(alias.getWidth(), alias.getHeight()) - 14.0;
        if (diameter < 0.0) {
            diameter = 0.0;
        }
        return diameter;
    }

    @Override
    public Point2D getAnchorPointCoordinates(SpeciesAlias alias, double angle) {
        if (alias.getWidth() == 0.0 && alias.getHeight() == 0.0) {
            return alias.getCenter();
        }
        double diameter = this.getDiameter(alias);
        double x = this.getXCoord(alias, diameter);
        double y = this.getYCoord(alias);
        Point2D result = this.getEllipseTransformation().getPointOnEllipseByRadian(x, y, diameter, diameter, angle);
        return result;
    }

    @Override
    public PathIterator getBoundPathIterator(SpeciesAlias alias) {
        throw new InvalidStateException("This class doesn't have bound");
    }
}

