/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.converter.model.celldesigner.annotation;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lcsb.mapviewer.common.XmlParser;
import lcsb.mapviewer.common.exception.InvalidXmlSchemaException;
import lcsb.mapviewer.model.map.MiriamData;
import lcsb.mapviewer.model.map.MiriamRelationType;
import lcsb.mapviewer.model.map.MiriamType;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlAnnotationParser
extends XmlParser {
    private Logger logger = Logger.getLogger(XmlAnnotationParser.class.getName());

    public Set<MiriamData> parse(String data, List<String> warnings) throws InvalidXmlSchemaException {
        if (data.trim().equals("")) {
            return null;
        }
        Document doc = this.getXmlDocumentFromString(data);
        if (doc != null) {
            NodeList root = doc.getChildNodes();
            return this.parseRdfNode(root, warnings);
        }
        throw new InvalidXmlSchemaException("no root node");
    }

    public Set<MiriamData> parseRdfNode(NodeList root, List<String> warnings) throws InvalidXmlSchemaException {
        Node rdf = this.getNode("rdf:RDF", root);
        return this.parseRdfNode(rdf, warnings);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Set<MiriamData> parseRdfNode(Node rdf, List<String> warnings) throws InvalidXmlSchemaException {
        HashSet<MiriamData> miriamDataSet = new HashSet<MiriamData>();
        if (rdf == null) throw new InvalidXmlSchemaException("rdf:Rdf node not found");
        Node description = this.getNode("rdf:Description", rdf.getChildNodes());
        if (description == null) throw new InvalidXmlSchemaException("rdf:Description node not found");
        NodeList list = description.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1) continue;
            miriamDataSet.addAll(this.parseMiriamNode(node, warnings));
        }
        return miriamDataSet;
    }

    public Set<MiriamData> parseMiriamNode(Node node, List<String> warnings) throws InvalidXmlSchemaException {
        HashSet<MiriamData> result = new HashSet<MiriamData>();
        NodeList list = node.getChildNodes();
        String relationTypeString = node.getNodeName();
        MiriamRelationType relationType = MiriamRelationType.getTypeByStringRepresentation(relationTypeString);
        Node bag = this.getNode("rdf:Bag", list);
        if (bag == null) {
            throw new InvalidXmlSchemaException("No rdf:Bag node found");
        }
        list = bag.getChildNodes();
        List<Node> nodes = this.getNodes("rdf:li", list);
        for (Node li : nodes) {
            String warning;
            MiriamType miriamType;
            String[] split;
            String dataTypeUri = this.getNodeAttr("rdf:resource", li);
            if (dataTypeUri == null) {
                throw new InvalidXmlSchemaException("rdf:li does not have a rdf:resource attribute");
            }
            if (dataTypeUri.contains("panther.family")) {
                dataTypeUri = dataTypeUri.replace("%3A", ":");
            }
            if ((split = dataTypeUri.split(":")).length < 2) {
                throw new InvalidXmlSchemaException("rdf:resource (" + dataTypeUri + ") is wrong");
            }
            String resource = split[split.length - 1];
            String uri = dataTypeUri.substring(0, dataTypeUri.length() - 1 - resource.length());
            if (uri.contains("pubmed")) {
                relationType = MiriamRelationType.BQ_BIOL_IS_DESCRIBED_BY;
            }
            if ((miriamType = MiriamType.getTypeByUri(uri)) == null) {
                warning = "Unknown miriam uri: " + uri;
                if (warnings != null) {
                    warnings.add(warning);
                    continue;
                }
                this.logger.warn(warning);
                continue;
            }
            if (relationType == null) {
                warning = "Unknown relation type: " + relationTypeString + ". For miriam data: " + (Object)((Object)miriamType) + ". Resource: " + resource;
                if (warnings != null) {
                    warnings.add(warning);
                    continue;
                }
                this.logger.warn(warning);
                continue;
            }
            result.add(new MiriamData(relationType, miriamType, resource));
        }
        return result;
    }

    public void parseFile(String fileName, List<String> warnings) throws IOException, InvalidXmlSchemaException {
        BufferedReader reader = new BufferedReader(new FileReader(fileName));
        String line = null;
        StringBuilder stringBuilder = new StringBuilder();
        String ls = System.getProperty("line.separator");
        while ((line = reader.readLine()) != null) {
            stringBuilder.append(line);
            stringBuilder.append(ls);
        }
        reader.close();
        this.parse(stringBuilder.toString(), warnings);
    }

    public String dataSetToXmlString(Set<MiriamData> data) {
        if (data == null) {
            return "";
        }
        String result = "";
        result = result + "<rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:vCard=\"http://www.w3.org/2001/vcard-rdf/3.0#\" xmlns:bqbiol=\"http://biomodels.net/biology-qualifiers/\" xmlns:bqmodel=\"http://biomodels.net/model-qualifiers/\">\n";
        result = result + "<rdf:Description rdf:about=\"#\">\n";
        for (MiriamData miriamData : data) {
            result = result + this.miriamDataToXmlString(miriamData);
        }
        result = result + "</rdf:Description>\n";
        result = result + "</rdf:RDF>\n";
        return result;
    }

    public String miriamDataToXmlString(MiriamData data) {
        String result = "";
        result = result + "<" + data.getRelationType().getStringRepresentation() + ">\n";
        result = result + "<rdf:Bag>\n";
        result = result + "<rdf:li rdf:resource=\"" + data.getDataType().getUris().get(0) + ":" + data.getResource().replaceAll(":", "%3A") + "\"/>\n";
        result = result + "</rdf:Bag>\n";
        result = result + "</" + data.getRelationType().getStringRepresentation() + ">\n";
        return result;
    }
}

