/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.apache.log4j.Logger;

public final class Configuration {
    private static Logger logger = Logger.getLogger(Configuration.class);
    private static final int DEFAULT_AUTOCOMPLETE_SIZE = 5;
    public static final int MIN_ZOOM_LEVEL = 2;
    public static final double MIN_VISIBLE_OBJECT_SIZE = 55000.0;
    public static final double MAX_VISIBLE_OBJECT_SIZE = 80000.0;
    public static final String PUBLICALY_AVAILABLE_PD_MAP = "http://pdmap.uni.lu/MapViewer/?id=pdmap";
    public static final String MAIN_PAGE = "/index.xhtml";
    public static final String MIRIAM_PAGE = "miriam.xhtml";
    public static final String LOGIN_PAGE = "/login.xhtml";
    public static final String SPRING_SECURITY_ACTION = "/j_spring_security_check";
    public static final String SPRING_SECURITY_LOGOUT = "/j_spring_security_logout";
    public static final String ANONYMOUS_LOGIN = "anonymous";
    public static final int SEARCH_LIMIT = 50;
    private static boolean applicationCacheOn = true;
    private static boolean dbCacheOn = true;
    private static int autocompleteSize = 5;
    public static final double EPSILON = 1.0E-6;
    private static String systemVersion = null;
    private static String systemBuild = null;

    private Configuration() {
    }

    public static boolean isApplicationCacheOn() {
        return applicationCacheOn;
    }

    public static void setApplicationCacheOn(boolean applicationCacheOn) {
        Configuration.applicationCacheOn = applicationCacheOn;
    }

    public static boolean isDbCacheOn() {
        return dbCacheOn;
    }

    public static void setDbCacheOn(boolean dbCacheOn) {
        Configuration.dbCacheOn = dbCacheOn;
    }

    public static int getAutocompleteSize() {
        return autocompleteSize;
    }

    public static void setAutocompleteSize(int autocompleteSize) {
        Configuration.autocompleteSize = autocompleteSize;
    }

    public static String getSystemVersion(String baseDir) {
        if (systemVersion == null) {
            Configuration.loadSystemVersion(baseDir);
        }
        return systemVersion;
    }

    public static String getSystemVersion(String baseDir, boolean forceReload) {
        if (forceReload) {
            systemVersion = null;
        }
        return Configuration.getSystemVersion(baseDir);
    }

    protected static void loadSystemVersion(String baseDir) {
        systemVersion = "Unknown";
        systemBuild = "Unknown";
        File file = null;
        file = baseDir == null ? new File("svnversion.txt") : new File(baseDir + "svnversion.txt");
        if (file.exists()) {
            try {
                BufferedReader reader = new BufferedReader(new FileReader(file));
                systemVersion = reader.readLine();
                systemBuild = reader.readLine();
                reader.close();
            }
            catch (IOException e) {
                logger.error(e);
            }
        } else {
            logger.error(file.getAbsoluteFile() + " doesn't exist.");
        }
    }

    public static String getSystemBuild(String baseDir) {
        if (systemBuild == null) {
            Configuration.loadSystemVersion(baseDir);
        }
        return systemBuild;
    }
}

