/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.cdplugin.info;

import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.Timer;
import jp.sbi.celldesigner.plugin.CellDesignerPlugin;
import jp.sbi.celldesigner.plugin.PluginListOf;
import jp.sbi.celldesigner.plugin.PluginSBase;
import jp.sbi.celldesigner.plugin.PluginSpeciesAlias;
import lcsb.mapviewer.cdplugin.info.InfoFrame;
import org.apache.log4j.Logger;

public class InfoPlugin
extends CellDesignerPlugin {
    private static final int DELAY_BETWEEN_ON_SELECT_LISTENER_CHECKS = 250;
    private static final int MAX_VISIBLE_ELEMENTS = 5;
    private Logger logger = Logger.getLogger(InfoPlugin.class.getName());
    private ActionListener onChangeSelectListener;
    private InfoFrame frame;

    public InfoPlugin() {
        try {
            this.logger.debug("Loading info plugin...");
            this.frame = InfoFrame.getInstance();
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(){

                @Override
                public boolean dispatchKeyEvent(KeyEvent e) {
                    if (401 == e.getID() && e.getKeyCode() == 84 && e.getModifiers() == 2) {
                        InfoPlugin.this.frame.setVisible(!InfoPlugin.this.frame.isVisible());
                        return true;
                    }
                    return false;
                }
            });
            this.onChangeSelectListener = new ActionListener(){
                private String selectedElementsId = "";

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    PluginListOf list = null;
                    try {
                        list = InfoPlugin.this.getSelectedAllNode();
                    }
                    catch (Exception e) {
                        return;
                    }
                    try {
                        ArrayList<PluginSpeciesAlias> v = new ArrayList<PluginSpeciesAlias>();
                        String newId = "";
                        for (int i = 0; i < Math.min(list.size(), 5); ++i) {
                            if (!(list.get(i) instanceof PluginSpeciesAlias)) continue;
                            PluginSpeciesAlias alias = (PluginSpeciesAlias)list.get(i);
                            v.add(alias);
                            newId = newId + alias.getSpecies().getName();
                        }
                        if (!this.selectedElementsId.equals(newId)) {
                            this.selectedElementsId = newId;
                            InfoPlugin.this.frame.setSpecies(v);
                        }
                    }
                    catch (Exception exception) {
                        InfoPlugin.this.logger.error(exception, exception);
                    }
                }
            };
            Timer timer = new Timer(250, this.onChangeSelectListener);
            timer.start();
        }
        catch (Exception exception) {
            this.logger.error("Unhandled exception. ", exception);
        }
    }

    public void SBaseAdded(PluginSBase arg0) {
    }

    public void SBaseChanged(PluginSBase arg0) {
    }

    public void SBaseDeleted(PluginSBase arg0) {
    }

    public void addPluginMenu() {
    }

    public void modelClosed(PluginSBase arg0) {
    }

    public void modelOpened(PluginSBase arg0) {
    }

    public void modelSelectChanged(PluginSBase arg0) {
    }
}

