/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.internal;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.engine.jdbc.spi.InvalidatableWrapper;
import org.hibernate.engine.jdbc.spi.JdbcResourceRegistry;
import org.hibernate.engine.jdbc.spi.JdbcWrapper;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.internal.CoreMessageLogger;
import org.jboss.logging.Logger;

public class JdbcResourceRegistryImpl
implements JdbcResourceRegistry {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, JdbcResourceRegistryImpl.class.getName());
    private final HashMap<Statement, Set<ResultSet>> xref = new HashMap();
    private final Set<ResultSet> unassociatedResultSets = new HashSet<ResultSet>();
    private final SqlExceptionHelper exceptionHelper;
    private Statement lastQuery;

    public JdbcResourceRegistryImpl(SqlExceptionHelper exceptionHelper) {
        this.exceptionHelper = exceptionHelper;
    }

    @Override
    public void register(Statement statement) {
        LOG.tracev("Registering statement [{0}]", (Object)statement);
        if (this.xref.containsKey(statement)) {
            throw new HibernateException("statement already registered with JDBCContainer");
        }
        this.xref.put(statement, null);
    }

    @Override
    public void registerLastQuery(Statement statement) {
        LOG.tracev("Registering last query statement [{0}]", (Object)statement);
        if (statement instanceof JdbcWrapper) {
            JdbcWrapper wrapper = (JdbcWrapper)((Object)statement);
            this.registerLastQuery((Statement)wrapper.getWrappedObject());
            return;
        }
        this.lastQuery = statement;
    }

    @Override
    public void cancelLastQuery() {
        try {
            if (this.lastQuery != null) {
                this.lastQuery.cancel();
            }
        }
        catch (SQLException sqle) {
            throw this.exceptionHelper.convert(sqle, "Cannot cancel query");
        }
        finally {
            this.lastQuery = null;
        }
    }

    @Override
    public void release(Statement statement) {
        LOG.tracev("Releasing statement [{0}]", (Object)statement);
        Set<ResultSet> resultSets = this.xref.get(statement);
        if (resultSets != null) {
            for (ResultSet resultSet : resultSets) {
                this.close(resultSet);
            }
            resultSets.clear();
        }
        this.xref.remove(statement);
        this.close(statement);
    }

    @Override
    public void register(ResultSet resultSet) {
        Statement statement;
        LOG.tracev("Registering result set [{0}]", (Object)resultSet);
        try {
            statement = resultSet.getStatement();
        }
        catch (SQLException e) {
            throw this.exceptionHelper.convert(e, "unable to access statement from resultset");
        }
        if (statement != null) {
            Set<ResultSet> resultSets;
            if (LOG.isEnabled(Logger.Level.WARN) && !this.xref.containsKey(statement)) {
                LOG.unregisteredStatement();
            }
            if ((resultSets = this.xref.get(statement)) == null) {
                resultSets = new HashSet<ResultSet>();
                this.xref.put(statement, resultSets);
            }
            resultSets.add(resultSet);
        } else {
            this.unassociatedResultSets.add(resultSet);
        }
    }

    @Override
    public void release(ResultSet resultSet) {
        Statement statement;
        LOG.tracev("Releasing result set [{0}]", (Object)resultSet);
        try {
            statement = resultSet.getStatement();
        }
        catch (SQLException e) {
            throw this.exceptionHelper.convert(e, "unable to access statement from resultset");
        }
        if (statement != null) {
            Set<ResultSet> resultSets;
            if (LOG.isEnabled(Logger.Level.WARN) && !this.xref.containsKey(statement)) {
                LOG.unregisteredStatement();
            }
            if ((resultSets = this.xref.get(statement)) != null) {
                resultSets.remove(resultSet);
                if (resultSets.isEmpty()) {
                    this.xref.remove(statement);
                }
            }
        } else {
            boolean removed = this.unassociatedResultSets.remove(resultSet);
            if (!removed) {
                LOG.unregisteredResultSetWithoutStatement();
            }
        }
        this.close(resultSet);
    }

    @Override
    public boolean hasRegisteredResources() {
        return !this.xref.isEmpty() || !this.unassociatedResultSets.isEmpty();
    }

    @Override
    public void releaseResources() {
        LOG.tracev("Releasing JDBC container resources [{0}]", (Object)this);
        this.cleanup();
    }

    private void cleanup() {
        for (Map.Entry<Statement, Set<ResultSet>> entry : this.xref.entrySet()) {
            if (entry.getValue() != null) {
                for (ResultSet resultSet : entry.getValue()) {
                    this.close(resultSet);
                }
                entry.getValue().clear();
            }
            this.close(entry.getKey());
        }
        this.xref.clear();
        for (ResultSet resultSet : this.unassociatedResultSets) {
            this.close(resultSet);
        }
        this.unassociatedResultSets.clear();
    }

    @Override
    public void close() {
        LOG.tracev("Closing JDBC container [{0}]", (Object)this);
        this.cleanup();
    }

    protected void close(Statement statement) {
        block9: {
            LOG.tracev("Closing prepared statement [{0}]", (Object)statement);
            if (statement instanceof InvalidatableWrapper) {
                InvalidatableWrapper wrapper = (InvalidatableWrapper)((Object)statement);
                this.close((Statement)wrapper.getWrappedObject());
                wrapper.invalidate();
                return;
            }
            try {
                try {
                    if (statement.getMaxRows() != 0) {
                        statement.setMaxRows(0);
                    }
                    if (statement.getQueryTimeout() != 0) {
                        statement.setQueryTimeout(0);
                    }
                }
                catch (SQLException sqle) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debugf("Exception clearing maxRows/queryTimeout [%s]", (Object)sqle.getMessage());
                    }
                    return;
                }
                statement.close();
                if (this.lastQuery == statement) {
                    this.lastQuery = null;
                }
            }
            catch (SQLException sqle) {
                if (!LOG.isDebugEnabled()) break block9;
                LOG.debugf("Unable to release statement [%s]", (Object)sqle.getMessage());
            }
        }
    }

    protected void close(ResultSet resultSet) {
        block3: {
            LOG.tracev("Closing result set [{0}]", (Object)resultSet);
            if (resultSet instanceof InvalidatableWrapper) {
                InvalidatableWrapper wrapper = (InvalidatableWrapper)((Object)resultSet);
                this.close((ResultSet)wrapper.getWrappedObject());
                wrapper.invalidate();
            }
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debugf("Unable to release result set [%s]", (Object)e.getMessage());
            }
        }
    }
}

