/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.internal.javassist;

import java.lang.reflect.Method;
import java.util.HashMap;
import javassist.util.proxy.MethodFilter;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyObject;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.bytecode.spi.BasicProxyFactory;
import org.hibernate.bytecode.spi.ProxyFactoryFactory;
import org.hibernate.proxy.ProxyFactory;
import org.hibernate.proxy.pojo.javassist.JavassistProxyFactory;

public class ProxyFactoryFactoryImpl
implements ProxyFactoryFactory {
    private static final MethodFilter FINALIZE_FILTER = new MethodFilter(){

        @Override
        public boolean isHandled(Method m) {
            return m.getParameterTypes().length != 0 || !m.getName().equals("finalize");
        }
    };

    @Override
    public ProxyFactory buildProxyFactory() {
        return new JavassistProxyFactory();
    }

    @Override
    public BasicProxyFactory buildBasicProxyFactory(Class superClass, Class[] interfaces) {
        return new BasicProxyFactoryImpl(superClass, interfaces);
    }

    private static class PassThroughHandler
    implements MethodHandler {
        private HashMap data = new HashMap();
        private final Object proxiedObject;
        private final String proxiedClassName;

        public PassThroughHandler(Object proxiedObject, String proxiedClassName) {
            this.proxiedObject = proxiedObject;
            this.proxiedClassName = proxiedClassName;
        }

        @Override
        public Object invoke(Object object, Method method, Method method1, Object[] args) throws Exception {
            boolean hasSetterSignature;
            String name = method.getName();
            if ("toString".equals(name)) {
                return this.proxiedClassName + "@" + System.identityHashCode(object);
            }
            if ("equals".equals(name)) {
                return this.proxiedObject == object;
            }
            if ("hashCode".equals(name)) {
                return System.identityHashCode(object);
            }
            boolean hasGetterSignature = method.getParameterTypes().length == 0 && method.getReturnType() != null;
            boolean bl = hasSetterSignature = method.getParameterTypes().length == 1 && (method.getReturnType() == null || method.getReturnType() == Void.TYPE);
            if (name.startsWith("get") && hasGetterSignature) {
                String propName = name.substring(3);
                return this.data.get(propName);
            }
            if (name.startsWith("is") && hasGetterSignature) {
                String propName = name.substring(2);
                return this.data.get(propName);
            }
            if (name.startsWith("set") && hasSetterSignature) {
                String propName = name.substring(3);
                this.data.put(propName, args[0]);
                return null;
            }
            return null;
        }
    }

    private static class BasicProxyFactoryImpl
    implements BasicProxyFactory {
        private final Class proxyClass;

        public BasicProxyFactoryImpl(Class superClass, Class[] interfaces) {
            if (superClass == null && (interfaces == null || interfaces.length < 1)) {
                throw new AssertionFailure("attempting to build proxy without any superclass or interfaces");
            }
            javassist.util.proxy.ProxyFactory factory = new javassist.util.proxy.ProxyFactory();
            factory.setFilter(FINALIZE_FILTER);
            if (superClass != null) {
                factory.setSuperclass(superClass);
            }
            if (interfaces != null && interfaces.length > 0) {
                factory.setInterfaces(interfaces);
            }
            this.proxyClass = factory.createClass();
        }

        @Override
        public Object getProxy() {
            try {
                ProxyObject proxy = (ProxyObject)this.proxyClass.newInstance();
                proxy.setHandler(new PassThroughHandler(proxy, this.proxyClass.getName()));
                return proxy;
            }
            catch (Throwable t) {
                throw new HibernateException("Unable to instantiated proxy instance");
            }
        }

        public boolean isInstance(Object object) {
            return this.proxyClass.isInstance(object);
        }
    }
}

