/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.map.species.fields;

public enum ModificationState {
    PHOSPHORYLATED("phosphorylated", "P"),
    ACETYLATED("acetylated", "Ac"),
    UBIQUITINATED("ubiquitinated", "Ub"),
    METHYLATED("methylated", "Me"),
    HYDROXYLATED("hydroxylated", "OH"),
    MYRISTOYLATED("myristoylated", "My"),
    SULFATED("sulfated", "S"),
    PRENYLATED("prenylated", "Pr"),
    GLYCOSYLATED("glycosylated", "G"),
    PALMYTOYLATED("palmytoylated", "Pa"),
    UNKNOWN("unknown", "?"),
    PROTONATED("protonated", "H"),
    DONT_CARE("don't care", "*");

    private String fullName;
    private String abbreviation;

    private ModificationState(String name, String abbreviation) {
        this.fullName = name;
        this.abbreviation = abbreviation;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public static ModificationState getByName(String name) {
        for (ModificationState state : ModificationState.values()) {
            if (!state.getFullName().equalsIgnoreCase(name)) continue;
            return state;
        }
        return null;
    }
}

