/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.map.species.fields;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import lcsb.mapviewer.model.map.species.Species;
import lcsb.mapviewer.model.map.species.fields.ModificationState;
import org.apache.log4j.Logger;
import org.hibernate.annotations.GenericGenerator;

@Entity
@Table(name="modification_residue_table")
@GenericGenerator(name="test-increment-strategy", strategy="increment")
public class ModificationResidue {
    private static Logger logger = Logger.getLogger(ModificationResidue.class.getName());
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="iddb", unique=true, nullable=false)
    private int id;
    @Column(name="idModificationResidue")
    private String idModificationResidue = "";
    @Column(name="name")
    private String name = "";
    @Column(name="side")
    private String side = "";
    @Column(name="state")
    private ModificationState state = null;
    @Column(name="angle")
    private Double angle = null;
    @Column(name="size")
    private Double size = null;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="idSpeciesDb", nullable=false)
    private Species species;

    public ModificationResidue() {
    }

    public ModificationResidue(ModificationResidue mr) {
        this.idModificationResidue = mr.idModificationResidue;
        this.name = mr.name;
        this.angle = mr.angle;
        this.size = mr.size;
        this.side = mr.side;
        this.state = mr.state;
    }

    public void update(ModificationResidue mr) {
        if (mr.getName() != null && !mr.getName().equals("")) {
            this.name = mr.name;
        }
        if (mr.getAngle() != null) {
            this.angle = mr.angle;
        }
        if (mr.getSize() != null) {
            this.size = mr.size;
        }
        if (mr.getSide() != null && !mr.getSide().equals("")) {
            this.side = mr.side;
        }
        if (mr.getState() != null) {
            this.state = mr.state;
        }
    }

    public String toString() {
        String result = this.getIdModificationResidue() + "," + this.getName() + "," + (Object)((Object)this.getState()) + "," + this.getAngle() + "," + this.getSize() + "," + this.getSide() + ",";
        return result;
    }

    public ModificationResidue copy() {
        return new ModificationResidue(this);
    }

    public void setAngle(String text) {
        try {
            this.angle = text != null && !text.equals("") ? Double.valueOf(Double.parseDouble(text)) : null;
        }
        catch (Exception e) {
            logger.warn("Invalid angle: " + text);
            this.angle = 0.0;
        }
    }

    public void setSize(String text) {
        try {
            this.size = text != null && !text.equals("") ? Double.valueOf(Double.parseDouble(text)) : null;
        }
        catch (Exception e) {
            logger.error("Invalid size: " + text);
        }
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getIdModificationResidue() {
        return this.idModificationResidue;
    }

    public void setIdModificationResidue(String idModificationResidue) {
        this.idModificationResidue = idModificationResidue;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSide() {
        return this.side;
    }

    public void setSide(String side) {
        this.side = side;
    }

    public ModificationState getState() {
        return this.state;
    }

    public void setState(ModificationState state) {
        this.state = state;
    }

    public Double getAngle() {
        return this.angle;
    }

    public void setAngle(Double angle) {
        this.angle = angle;
    }

    public Double getSize() {
        return this.size;
    }

    public void setSize(Double size) {
        this.size = size;
    }

    public Species getSpecies() {
        return this.species;
    }

    public void setSpecies(Species species) {
        this.species = species;
    }
}

