/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.map.species;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import lcsb.mapviewer.common.exception.InvalidArgumentException;
import lcsb.mapviewer.model.map.Element;
import lcsb.mapviewer.model.map.MiriamData;
import lcsb.mapviewer.model.map.species.fields.PositionToCompartment;
import org.apache.log4j.Logger;

@Entity
@DiscriminatorValue(value="SPECIES")
public class Species
extends Element {
    private static Logger logger = Logger.getLogger(Species.class.getName());
    private String idSpecies;
    private Integer initialAmount = null;
    private Integer charge = null;
    private Integer initialConcentration = null;
    private Boolean onlySubstanceUnits = null;
    @Enumerated(value=EnumType.STRING)
    private PositionToCompartment positionToCompartment = null;
    private Boolean hypothetical = null;

    public void setHypothetical(String text) {
        this.hypothetical = text.equals("true");
    }

    public Species(Species species) {
        super(species);
        this.hypothetical = species.hypothetical;
        this.idSpecies = species.idSpecies;
        this.positionToCompartment = species.positionToCompartment;
        this.initialAmount = species.initialAmount;
        this.charge = species.charge;
        this.initialConcentration = species.initialConcentration;
        this.onlySubstanceUnits = species.onlySubstanceUnits;
    }

    public Species() {
        this.idSpecies = "";
    }

    public Species(String id) {
        this();
        this.idSpecies = id;
    }

    @Override
    public Species copy() {
        Species result = new Species(this);
        result.idSpecies = this.idSpecies;
        result.setNotes(this.getNotes());
        result.setHypothetical(this.hypothetical);
        try {
            result.setParent(this.getParent());
        }
        catch (InvalidArgumentException e) {
            logger.fatal("Impossible...", e);
        }
        result.charge = this.charge;
        result.initialAmount = this.initialAmount;
        result.initialConcentration = this.initialConcentration;
        result.onlySubstanceUnits = this.onlySubstanceUnits;
        result.positionToCompartment = this.positionToCompartment;
        return result;
    }

    public String getIdSpecies() {
        return this.idSpecies;
    }

    public void setIdSpecies(String idSpecies) {
        if (this.idSpecies.equals(idSpecies) || this.idSpecies.equals("")) {
            this.idSpecies = idSpecies;
        } else {
            if (!idSpecies.equals("")) {
                throw new InvalidArgumentException("Cannot change identifier of the species in the runtime. OLD: " + this.idSpecies + ", NEW: " + idSpecies);
            }
            this.idSpecies = idSpecies;
        }
    }

    public List<String> update(Species species) {
        ArrayList<String> warnings = new ArrayList<String>();
        if (this.getName() == null || this.getName().equals("")) {
            this.setName(species.getName());
        } else if (!this.getName().trim().equals(species.getName().trim())) {
            Object id = species.getIdSpecies();
            if (id == null || ((String)id).equals("")) {
                id = this.getIdSpecies();
            }
            String warning = "Two different names in species with id =" + (String)id + ": \"" + species.getName() + "\", \"" + this.getName() + "\"";
            warning = warning.replaceAll("\n", "_NEW_LINE_");
            warnings.add(warning);
            this.setName(species.getName());
        }
        if (this.idSpecies == null || this.idSpecies.equals("")) {
            this.setIdSpecies(species.getIdSpecies());
        }
        if (this.getMetaId() == null || this.getMetaId().equals("")) {
            this.setMetaId(species.getMetaId());
        }
        for (MiriamData md : species.getMiriamData()) {
            if (this.getMiriamData().contains(md)) continue;
            this.addMiriamData(new MiriamData(md), warnings);
        }
        if (this.getNotes() == null || this.getNotes().trim().equals("")) {
            this.setNotes(species.getNotes());
        } else if (species.getNotes() != null && !species.getNotes().trim().equals("") && !this.getNotes().equals(species.getNotes())) {
            String string1 = this.getNotes();
            String string2 = species.getNotes();
            string1 = string1.trim();
            if ((string2 = string2.trim()).contains(string1)) {
                this.setNotes(species.getNotes());
            } else if (!string1.toLowerCase().contains(string2.toLowerCase())) {
                this.setNotes(string2 + this.getNotes());
            }
        }
        if (this.getParent() == null) {
            try {
                this.setParent(species.getParent());
            }
            catch (InvalidArgumentException e) {
                logger.fatal(e.getMessage(), e);
            }
        }
        if (species.getHypothetical() != null) {
            this.setHypothetical(species.getHypothetical());
        }
        if (this.getSymbol() != null && !this.getSymbol().equals("")) {
            if (species.getSymbol() != null && !species.getSymbol().equals("") && !species.getSymbol().equals(this.getSymbol())) {
                warnings.add("Different symbol names: " + species.getSymbol() + ", " + this.getSymbol() + ". Ignoring...");
            }
        } else {
            this.setSymbol(species.getSymbol());
        }
        if (this.getFullName() != null && !this.getFullName().equals("")) {
            if (species.getFullName() != null && !species.getFullName().equals("") && !species.getFullName().equals(this.getFullName())) {
                warnings.add("Different symbol names: " + species.getFullName() + ", " + this.getFullName() + ". Ignoring...");
            }
        } else {
            this.setFullName(species.getFullName());
        }
        for (String string : species.getSynonyms()) {
            if (this.getSynonyms().contains(string)) continue;
            this.getSynonyms().add(string);
        }
        for (String string : species.getFormerSymbols()) {
            if (this.getFormerSymbols().contains(string)) continue;
            this.getFormerSymbols().add(string);
        }
        return warnings;
    }

    public void setInitialAmount(String text) {
        if (text != null && !text.trim().equals("")) {
            try {
                this.initialAmount = Integer.parseInt(text);
            }
            catch (Exception exception) {
                this.initialAmount = null;
                logger.error("Invalid species amount: " + text);
            }
        } else {
            this.initialAmount = null;
        }
    }

    public void setCharge(String text) {
        if (text != null && !text.trim().equals("")) {
            try {
                this.charge = Integer.parseInt(text);
            }
            catch (Exception exception) {
                this.charge = null;
                logger.error("Invalid species charge: " + text);
            }
        } else {
            this.charge = null;
        }
    }

    public void setOnlySubstanceUnits(String text) {
        if (text != null && !text.trim().equals("")) {
            if (text.equalsIgnoreCase("TRUE")) {
                this.onlySubstanceUnits = true;
            } else if (text.equalsIgnoreCase("FALSE")) {
                this.onlySubstanceUnits = false;
            } else {
                logger.error("Invalid species value for only substance unit boolean: " + text);
                this.onlySubstanceUnits = null;
            }
        } else {
            this.onlySubstanceUnits = null;
        }
    }

    public void setInitialConcentration(String text) {
        if (text != null && !text.trim().equals("")) {
            try {
                this.initialConcentration = Integer.parseInt(text);
            }
            catch (Exception exception) {
                this.initialConcentration = null;
                logger.error("Invalid species initial concentration: " + text);
            }
        } else {
            this.initialConcentration = null;
        }
    }

    public boolean isHypothetical() {
        if (this.hypothetical == null) {
            return false;
        }
        return this.hypothetical;
    }

    @Override
    public String getElementId() {
        return this.getIdSpecies();
    }

    @Override
    public String getStringType() {
        logger.error("Invalid call");
        return null;
    }

    public Integer getInitialAmount() {
        return this.initialAmount;
    }

    public void setInitialAmount(Integer initialAmount) {
        this.initialAmount = initialAmount;
    }

    public Integer getCharge() {
        return this.charge;
    }

    public void setCharge(Integer charge) {
        this.charge = charge;
    }

    public Boolean getOnlySubstanceUnits() {
        return this.onlySubstanceUnits;
    }

    public void setOnlySubstanceUnits(Boolean onlySubstanceUnits) {
        this.onlySubstanceUnits = onlySubstanceUnits;
    }

    public Integer getInitialConcentration() {
        return this.initialConcentration;
    }

    public void setInitialConcentration(Integer initialConcentration) {
        this.initialConcentration = initialConcentration;
    }

    public Boolean getHypothetical() {
        return this.hypothetical;
    }

    public void setHypothetical(Boolean hypothetical) {
        this.hypothetical = hypothetical;
    }

    public Boolean hasOnlySubstanceUnits() {
        return this.onlySubstanceUnits;
    }

    public PositionToCompartment getPositionToCompartment() {
        return this.positionToCompartment;
    }

    public void setPositionToCompartment(PositionToCompartment positionToCompartment) {
        this.positionToCompartment = positionToCompartment;
    }
}

