/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.map.species;

import java.util.Comparator;
import lcsb.mapviewer.common.comparator.IntegerComparator;
import lcsb.mapviewer.common.exception.InvalidClassException;
import lcsb.mapviewer.model.map.species.Phenotype;
import lcsb.mapviewer.model.map.species.SpeciesComparator;
import lcsb.mapviewer.model.map.species.fields.AssociatedElementComparator;
import org.apache.log4j.Logger;

public class PhenotypeComparator
implements Comparator<Phenotype> {
    private Logger logger = Logger.getLogger(PhenotypeComparator.class);
    private double epsilon;

    public PhenotypeComparator(double epsilon) {
        this.epsilon = epsilon;
    }

    public PhenotypeComparator() {
        this(1.0E-6);
    }

    @Override
    public int compare(Phenotype arg0, Phenotype arg1) {
        if (arg0 == null) {
            if (arg1 == null) {
                return 0;
            }
            return 1;
        }
        if (arg1 == null) {
            return -1;
        }
        if (arg0.getClass().equals(arg1.getClass())) {
            if (arg0 instanceof Phenotype) {
                return this.internalCompare(arg0, arg1);
            }
            throw new InvalidClassException("Don't know how to compare classes: " + arg0.getClass());
        }
        return -1;
    }

    private int internalCompare(Phenotype arg0, Phenotype arg1) {
        SpeciesComparator speciesComparator = new SpeciesComparator(this.epsilon);
        int result = speciesComparator.internalCompare(arg0, arg1);
        if (result != 0) {
            return result;
        }
        IntegerComparator integerComparator = new IntegerComparator();
        if (integerComparator.compare(arg0.getAssociatedElements().size(), arg1.getAssociatedElements().size()) != 0) {
            this.logger.debug("number of associated elements different: " + arg0.getAssociatedElements().size() + ", " + arg1.getAssociatedElements().size());
            return integerComparator.compare(arg0.getAssociatedElements().size(), arg1.getAssociatedElements().size());
        }
        AssociatedElementComparator associatedElementComparator = new AssociatedElementComparator();
        for (int i = 0; i < arg0.getAssociatedElements().size(); ++i) {
            if (associatedElementComparator.compare(arg0.getAssociatedElements().get(i), arg1.getAssociatedElements().get(i)) == 0) continue;
            this.logger.debug("Associated elements different");
            return associatedElementComparator.compare(arg0.getAssociatedElements().get(i), arg1.getAssociatedElements().get(i));
        }
        return 0;
    }
}

