/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.map.species;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.OneToMany;
import lcsb.mapviewer.model.map.species.Species;
import lcsb.mapviewer.model.map.species.fields.ModificationResidue;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.LazyCollection;
import org.hibernate.annotations.LazyCollectionOption;

@Entity
@DiscriminatorValue(value="Gene")
public class Gene
extends Species {
    @Cascade(value={CascadeType.ALL})
    @OneToMany(mappedBy="species", orphanRemoval=true)
    @LazyCollection(value=LazyCollectionOption.FALSE)
    private List<ModificationResidue> modificationResidues = new ArrayList<ModificationResidue>();

    public Gene(Species species) {
        super(species);
        if (species instanceof Gene) {
            Gene gene = (Gene)species;
            for (ModificationResidue mr : gene.getModificationResidues()) {
                this.addModificationResidue(new ModificationResidue(mr));
            }
        }
    }

    @Override
    public List<String> update(Species species) {
        List<String> warnings = super.update(species);
        if (species instanceof Gene) {
            Gene gene = (Gene)species;
            for (ModificationResidue mr : gene.getModificationResidues()) {
                this.addModificationResidue(mr);
            }
        }
        return warnings;
    }

    public Gene() {
    }

    @Override
    public Gene copy() {
        return new Gene(this);
    }

    @Override
    public String getStringType() {
        return "Gene";
    }

    public void addModificationResidue(ModificationResidue modificationResidue) {
        for (ModificationResidue mr : this.modificationResidues) {
            if (!mr.getIdModificationResidue().equals(modificationResidue.getIdModificationResidue())) continue;
            mr.update(modificationResidue);
            return;
        }
        this.modificationResidues.add(modificationResidue);
        modificationResidue.setSpecies(this);
    }

    public List<ModificationResidue> getModificationResidues() {
        return this.modificationResidues;
    }

    public void setModificationResidues(List<ModificationResidue> modificationResidues) {
        this.modificationResidues = modificationResidues;
    }
}

