/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.map.reaction.type;

import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import lcsb.mapviewer.common.exception.InvalidArgumentException;
import lcsb.mapviewer.common.exception.InvalidStateException;
import lcsb.mapviewer.model.map.reaction.Reaction;
import lcsb.mapviewer.model.map.reaction.type.ReactionRect;
import lcsb.mapviewer.model.map.reaction.type.TwoProductReactionInterface;

@Entity
@DiscriminatorValue(value="TRUNCATION_REACTION_REACTION")
public class TruncationReaction
extends Reaction
implements TwoProductReactionInterface {
    public TruncationReaction() {
    }

    public TruncationReaction(Reaction result) {
        super(result);
        if (result.getProducts().size() < 2) {
            throw new InvalidArgumentException("Reaction cannot be transformed to truncation: number of products must be greater than 1");
        }
        if (result.getReactants().size() < 1) {
            throw new InvalidArgumentException("Reaction cannot be transformed to truncation: number of reactants must be greater than 0");
        }
    }

    @Override
    public String getStringType() {
        return "Truncation";
    }

    @Override
    public ReactionRect getReactionRect() {
        return ReactionRect.RECT_BOLT;
    }

    @Override
    public TruncationReaction copy() {
        if (this.getClass() == TruncationReaction.class) {
            return new TruncationReaction(this);
        }
        throw new InvalidStateException("Method copy() should be overriden in class " + this.getClass());
    }
}

