/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.map.reaction.type;

import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import lcsb.mapviewer.common.exception.InvalidArgumentException;
import lcsb.mapviewer.common.exception.InvalidStateException;
import lcsb.mapviewer.model.map.reaction.Reaction;
import lcsb.mapviewer.model.map.reaction.type.ReactionRect;
import lcsb.mapviewer.model.map.reaction.type.SimpleReactionInterface;

@Entity
@DiscriminatorValue(value="KNOWN_TRANSITION_OMMITED")
public class KnownTransitionOmittedReaction
extends Reaction
implements SimpleReactionInterface {
    public KnownTransitionOmittedReaction() {
    }

    public KnownTransitionOmittedReaction(Reaction result) {
        super(result);
        if (result.getProducts().size() < 1) {
            throw new InvalidArgumentException("Reaction cannot be transformed to " + this.getStringType() + ": number of products must be greater than 0");
        }
        if (result.getReactants().size() < 1) {
            throw new InvalidArgumentException("Reaction cannot be transformed to " + this.getStringType() + ": number of reactants must be greater than 0");
        }
    }

    @Override
    public String getStringType() {
        return "Known transition omitted";
    }

    @Override
    public ReactionRect getReactionRect() {
        return ReactionRect.RECT_SLASH;
    }

    @Override
    public KnownTransitionOmittedReaction copy() {
        if (this.getClass() == KnownTransitionOmittedReaction.class) {
            return new KnownTransitionOmittedReaction(this);
        }
        throw new InvalidStateException("Method copy() should be overriden in class " + this.getClass());
    }
}

