/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.map.reaction;

import java.util.Comparator;
import lcsb.mapviewer.common.exception.InvalidClassException;
import lcsb.mapviewer.model.map.ElementComparator;
import lcsb.mapviewer.model.map.layout.alias.AliasComparator;
import lcsb.mapviewer.model.map.reaction.AbstractNodeComparator;
import lcsb.mapviewer.model.map.reaction.ReactionNode;
import org.apache.log4j.Logger;

public class ReactionNodeComparator
implements Comparator<ReactionNode> {
    private Logger logger = Logger.getLogger(ReactionNodeComparator.class);
    private double epsilon;

    public ReactionNodeComparator(double epsilon) {
        this.epsilon = epsilon;
    }

    public ReactionNodeComparator() {
        this(1.0E-6);
    }

    @Override
    public int compare(ReactionNode arg0, ReactionNode arg1) {
        if (arg0 == null) {
            if (arg1 == null) {
                return 0;
            }
            return 1;
        }
        if (arg1 == null) {
            return -1;
        }
        if (arg0.getClass().equals(arg1.getClass())) {
            if (arg0 instanceof ReactionNode) {
                return this.internalCompare(arg0, arg1);
            }
            throw new InvalidClassException("Don't know how to compare classes: " + arg0.getClass());
        }
        this.logger.debug("Different classes.");
        return -1;
    }

    private int internalCompare(ReactionNode arg0, ReactionNode arg1) {
        AbstractNodeComparator anComparator = new AbstractNodeComparator(this.epsilon);
        ElementComparator elementComparator = new ElementComparator(this.epsilon);
        AliasComparator aliasComparator = new AliasComparator(this.epsilon);
        int result = anComparator.internalCompare(arg0, arg1);
        if (result != 0) {
            return result;
        }
        if (aliasComparator.compare(arg0.getAlias(), arg1.getAlias()) != 0) {
            this.logger.debug("Alias different");
            return aliasComparator.compare(arg0.getAlias(), arg1.getAlias());
        }
        if (elementComparator.compare(arg0.getElement(), arg1.getElement()) != 0) {
            this.logger.debug("Element different");
            return elementComparator.compare(arg0.getElement(), arg1.getElement());
        }
        return 0;
    }
}

