/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.map.reaction;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import lcsb.mapviewer.common.comparator.BooleanComparator;
import lcsb.mapviewer.common.comparator.DoubleComparator;
import lcsb.mapviewer.common.comparator.IntegerComparator;
import lcsb.mapviewer.common.comparator.StringComparator;
import lcsb.mapviewer.common.comparator.StringListComparator;
import lcsb.mapviewer.common.comparator.StringSetComparator;
import lcsb.mapviewer.common.exception.InvalidClassException;
import lcsb.mapviewer.model.map.MiriamData;
import lcsb.mapviewer.model.map.reaction.AbstractNodeComparator;
import lcsb.mapviewer.model.map.reaction.Reaction;
import org.apache.log4j.Logger;

public class ReactionComparator
implements Comparator<Reaction> {
    private Logger logger = Logger.getLogger(ReactionComparator.class);
    private double epsilon;

    public ReactionComparator(double epsilon) {
        this.epsilon = epsilon;
    }

    public ReactionComparator() {
        this(1.0E-6);
    }

    @Override
    public int compare(Reaction arg0, Reaction arg1) {
        if (arg0 == null) {
            if (arg1 == null) {
                return 0;
            }
            return 1;
        }
        if (arg1 == null) {
            return -1;
        }
        if (arg0.getClass().equals(arg1.getClass())) {
            if (arg0 instanceof Reaction) {
                return this.internalCompare(arg0, arg1);
            }
            throw new InvalidClassException("Don't know how to compare classes: " + arg0.getClass());
        }
        this.logger.debug("Different class: " + arg0.getClass() + ", " + arg1.getClass());
        return -1;
    }

    public int internalCompare(Reaction arg0, Reaction arg1) {
        String hash;
        StringComparator stringComparator = new StringComparator();
        BooleanComparator booleanComparator = new BooleanComparator();
        AbstractNodeComparator aNodeComparator = new AbstractNodeComparator(this.epsilon);
        if (stringComparator.compare(arg0.getName(), arg1.getName()) != 0) {
            this.logger.debug("Name different: " + arg0.getName() + ", " + arg1.getName());
            return stringComparator.compare(arg0.getName(), arg1.getName());
        }
        if (stringComparator.compare(arg0.getNotes().trim(), arg1.getNotes().trim()) != 0) {
            this.logger.debug("Notes different: " + arg0.getNotes() + ", " + arg1.getNotes());
            return stringComparator.compare(arg0.getNotes(), arg1.getNotes());
        }
        if (stringComparator.compare(arg0.getMetaId(), arg1.getMetaId()) != 0) {
            this.logger.debug("MetaId different: " + arg0.getMetaId() + ", " + arg1.getMetaId());
            return stringComparator.compare(arg0.getMetaId(), arg1.getMetaId());
        }
        if (stringComparator.compare(arg0.getIdReaction(), arg1.getIdReaction()) != 0) {
            this.logger.debug("IdReaction different: " + arg0.getIdReaction() + ", " + arg1.getIdReaction());
            return stringComparator.compare(arg0.getIdReaction(), arg1.getIdReaction());
        }
        if (booleanComparator.compare(arg0.isReversible(), arg1.isReversible()) != 0) {
            this.logger.debug("Reversible different: " + arg0.isReversible() + ", " + arg1.isReversible());
            return booleanComparator.compare(arg0.isReversible(), arg1.isReversible());
        }
        if (booleanComparator.compare(arg0.isKineticLaw(), arg1.isKineticLaw()) != 0) {
            this.logger.debug("KineticLaw different: " + arg0.isKineticLaw() + ", " + arg1.isKineticLaw());
            return booleanComparator.compare(arg0.isKineticLaw(), arg1.isKineticLaw());
        }
        if (stringComparator.compare(arg0.getSymbol(), arg1.getSymbol()) != 0) {
            this.logger.debug("Symbol different: " + arg0.getSymbol() + ", " + arg1.getSymbol());
            return stringComparator.compare(arg0.getSymbol(), arg1.getSymbol());
        }
        if (stringComparator.compare(arg0.getAbbreviation(), arg1.getAbbreviation()) != 0) {
            this.logger.debug("abbreviation different: " + arg0.getAbbreviation() + ", " + arg1.getAbbreviation());
            return stringComparator.compare(arg0.getAbbreviation(), arg1.getAbbreviation());
        }
        if (stringComparator.compare(arg0.getFormula(), arg1.getFormula()) != 0) {
            this.logger.debug("Formula different: " + arg0.getFormula() + ", " + arg1.getFormula());
            return stringComparator.compare(arg0.getFormula(), arg1.getFormula());
        }
        if (stringComparator.compare(arg0.getSubsystem(), arg1.getSubsystem()) != 0) {
            this.logger.debug("Subsystem different: " + arg0.getSubsystem() + ", " + arg1.getSubsystem());
            return stringComparator.compare(arg0.getSubsystem(), arg1.getSubsystem());
        }
        if (stringComparator.compare(arg0.getGeneProteinReaction(), arg1.getGeneProteinReaction()) != 0) {
            this.logger.debug("GeneProteinReaction different: " + arg0.getGeneProteinReaction() + ", " + arg1.getGeneProteinReaction());
            return stringComparator.compare(arg0.getGeneProteinReaction(), arg1.getGeneProteinReaction());
        }
        IntegerComparator integerComparator = new IntegerComparator();
        if (integerComparator.compare(arg0.getMechanicalConfidenceScore(), arg1.getMechanicalConfidenceScore()) != 0) {
            this.logger.debug("MechanicalConfidenceScore different: " + arg0.getMechanicalConfidenceScore() + ", " + arg1.getMechanicalConfidenceScore());
            return integerComparator.compare(arg0.getMechanicalConfidenceScore(), arg1.getMechanicalConfidenceScore());
        }
        DoubleComparator doubleComparator = new DoubleComparator(this.epsilon);
        if (doubleComparator.compare(arg0.getLowerBound(), arg1.getLowerBound()) != 0) {
            this.logger.debug("LowerBound different: " + arg0.getLowerBound() + ", " + arg1.getLowerBound());
            return doubleComparator.compare(arg0.getLowerBound(), arg1.getLowerBound());
        }
        if (doubleComparator.compare(arg0.getUpperBound(), arg1.getUpperBound()) != 0) {
            this.logger.debug("UpperBound different: " + arg0.getUpperBound() + ", " + arg1.getUpperBound());
            return doubleComparator.compare(arg0.getUpperBound(), arg1.getUpperBound());
        }
        StringListComparator stringListComparator = new StringListComparator();
        if (stringListComparator.compare(arg0.getSynonyms(), arg1.getSynonyms()) != 0) {
            this.logger.debug("Synonyms dataset different");
            return stringListComparator.compare(arg0.getSynonyms(), arg1.getSynonyms());
        }
        HashSet<String> hashCode1 = new HashSet<String>();
        HashSet<String> hashCode2 = new HashSet<String>();
        for (MiriamData md : arg0.getMiriamData()) {
            hash = (Object)((Object)md.getRelationType()) + "  " + (Object)((Object)md.getDataType()) + "  " + md.getResource();
            hashCode1.add(hash);
        }
        for (MiriamData md : arg1.getMiriamData()) {
            hash = (Object)((Object)md.getRelationType()) + "  " + (Object)((Object)md.getDataType()) + "  " + md.getResource();
            hashCode2.add(hash);
        }
        StringSetComparator stringSetComparator = new StringSetComparator();
        if (stringSetComparator.compare((Set<String>)hashCode1, (Set<String>)hashCode2) != 0) {
            this.logger.debug("Miriam dataset different");
            return stringSetComparator.compare((Set<String>)hashCode1, (Set<String>)hashCode2);
        }
        if (arg0.getNodes().size() != arg1.getNodes().size()) {
            this.logger.debug("Different number of nodes: " + arg0.getNodes().size() + ", " + arg1.getNodes().size());
            return Integer.valueOf(arg0.getNodes().size()).compareTo(arg1.getNodes().size());
        }
        for (int i = 0; i < arg0.getNodes().size(); ++i) {
            int status = -1;
            for (int j = 0; j < arg1.getNodes().size(); ++j) {
                int tmpStatus = aNodeComparator.compare(arg0.getNodes().get(i), arg1.getNodes().get(j));
                if (tmpStatus != 0) continue;
                status = 0;
                break;
            }
            if (status == 0) continue;
            this.logger.debug("Can't find matching node for: " + arg0.getNodes().get(i));
            return status;
        }
        if (arg0.getOperators().size() != arg1.getOperators().size()) {
            this.logger.debug("Different number of operators: " + arg0.getOperators().size() + ", " + arg1.getOperators().size());
            return Integer.valueOf(arg0.getOperators().size()).compareTo(arg1.getOperators().size());
        }
        return 0;
    }
}

