/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.map.reaction;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlTransient;
import lcsb.mapviewer.common.exception.InvalidArgumentException;
import lcsb.mapviewer.common.exception.InvalidStateException;
import lcsb.mapviewer.common.geometry.LineTransformation;
import lcsb.mapviewer.model.map.AnnotatedObject;
import lcsb.mapviewer.model.map.Element;
import lcsb.mapviewer.model.map.MiriamData;
import lcsb.mapviewer.model.map.model.Model;
import lcsb.mapviewer.model.map.model.ModelData;
import lcsb.mapviewer.model.map.reaction.AbstractNode;
import lcsb.mapviewer.model.map.reaction.Modifier;
import lcsb.mapviewer.model.map.reaction.NodeOperator;
import lcsb.mapviewer.model.map.reaction.Product;
import lcsb.mapviewer.model.map.reaction.Reactant;
import lcsb.mapviewer.model.map.reaction.ReactionNode;
import lcsb.mapviewer.model.map.reaction.type.ReactionRect;
import lcsb.mapviewer.model.map.reaction.type.TwoProductReactionInterface;
import lcsb.mapviewer.model.map.reaction.type.TwoReactantReactionInterface;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.IndexColumn;

@Entity
@Table(name="reaction_table")
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name="reaction_type_db", discriminatorType=DiscriminatorType.STRING)
@DiscriminatorValue(value="GENERIC_REACTION")
public class Reaction
implements AnnotatedObject {
    public static final Comparator<Reaction> ID_COMPARATOR = new Comparator<Reaction>(){

        @Override
        public int compare(Reaction reaction1, Reaction reaction2) {
            return reaction1.getIdReaction().compareTo(reaction2.getIdReaction());
        }
    };
    private static Logger logger = Logger.getLogger(Reaction.class.getName());
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="idDb", unique=true, nullable=false)
    private int id;
    @Cascade(value={CascadeType.ALL})
    @OneToMany(mappedBy="reaction")
    @OrderBy(value="id")
    private List<AbstractNode> nodes = new ArrayList<AbstractNode>();
    @Column(name="notes", columnDefinition="TEXT")
    private String notes = "";
    private String idReaction = "";
    private String metaId = "";
    private String name = "";
    private boolean reversible = false;
    private boolean kineticLaw = false;
    private String symbol = null;
    private String abbreviation = null;
    private String formula = null;
    private Integer mechanicalConfidenceScore = null;
    private Double lowerBound = null;
    private Double upperBound = null;
    private String subsystem = null;
    private String geneProteinReaction = null;
    @ElementCollection
    @CollectionTable(name="reaction_synonyms", joinColumns={@JoinColumn(name="idDb")})
    @Column(name="synonym")
    @IndexColumn(name="idx")
    @Cascade(value={CascadeType.ALL})
    private List<String> synonyms = new ArrayList<String>();
    @Cascade(value={CascadeType.ALL})
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="reaction_miriam", joinColumns={@JoinColumn(name="reaction_id", referencedColumnName="idDb", nullable=false, updatable=false)}, inverseJoinColumns={@JoinColumn(name="miriam_id", referencedColumnName="idDb", nullable=true, updatable=true)})
    private Set<MiriamData> miriamDataSet = new HashSet<MiriamData>();
    @ManyToOne(fetch=FetchType.LAZY)
    private ModelData model;

    public Reaction() {
    }

    public Reaction(Reaction original) {
        for (AbstractNode node : original.getNodes()) {
            this.addNode(node);
        }
        this.notes = original.getNotes();
        this.idReaction = original.getIdReaction();
        this.metaId = original.getMetaId();
        this.name = original.getName();
        this.reversible = original.reversible;
        this.kineticLaw = original.kineticLaw;
        this.miriamDataSet = new HashSet<MiriamData>();
        for (MiriamData md : original.getMiriamData()) {
            this.miriamDataSet.add(new MiriamData(md));
        }
        this.symbol = original.getSymbol();
        this.abbreviation = original.getAbbreviation();
        this.formula = original.getFormula();
        this.mechanicalConfidenceScore = original.getMechanicalConfidenceScore();
        this.lowerBound = original.getLowerBound();
        this.upperBound = original.getUpperBound();
        this.subsystem = original.getSubsystem();
        this.geneProteinReaction = original.getGeneProteinReaction();
        this.synonyms = new ArrayList<String>();
        for (String synonym : original.getSynonyms()) {
            this.synonyms.add(synonym);
        }
    }

    public void addNode(AbstractNode node) {
        node.setReaction(this);
        this.nodes.add(node);
    }

    public void addReactant(Reactant reactant) {
        this.addNode(reactant);
    }

    public void addProduct(Product product) {
        this.addNode(product);
    }

    public void addModifier(Modifier modifier) {
        this.addNode(modifier);
    }

    public List<Product> getProducts() {
        ArrayList<Product> result = new ArrayList<Product>();
        for (AbstractNode node : this.nodes) {
            if (!(node instanceof Product)) continue;
            result.add((Product)node);
        }
        return result;
    }

    public List<Reactant> getReactants() {
        ArrayList<Reactant> result = new ArrayList<Reactant>();
        for (AbstractNode node : this.nodes) {
            if (!(node instanceof Reactant)) continue;
            result.add((Reactant)node);
        }
        return result;
    }

    public List<Modifier> getModifiers() {
        ArrayList<Modifier> result = new ArrayList<Modifier>();
        for (AbstractNode node : this.nodes) {
            if (!(node instanceof Modifier)) continue;
            result.add((Modifier)node);
        }
        return result;
    }

    public double getDistanceFromPoint(Point2D point) {
        LineTransformation lt = new LineTransformation();
        double dist = Double.MAX_VALUE;
        List<Line2D> lines = this.getLines();
        for (Line2D line : lines) {
            double d2 = lt.distBetweenPointAndLineSegment(line, point);
            if (!(d2 < dist)) continue;
            dist = d2;
        }
        return dist;
    }

    public List<Line2D> getLines() {
        ArrayList<Line2D> result = new ArrayList<Line2D>();
        for (AbstractNode node : this.nodes) {
            result.addAll(node.getLine().getLines());
        }
        return result;
    }

    public Point2D getClosestPointTo(Point2D point) {
        LineTransformation lt = new LineTransformation();
        double dist = Double.MAX_VALUE;
        List<Line2D> lines = this.getLines();
        Point2D result = null;
        for (Line2D line : lines) {
            double d2 = lt.distBetweenPointAndLineSegment(line, point);
            if (!(d2 < dist)) continue;
            dist = d2;
            result = lt.closestPointOnSegmentLineToPoint(line, point);
        }
        return result;
    }

    public String getStringType() {
        logger.error("Not implemented");
        return null;
    }

    public int getVisibilityLevel() {
        int level = 0;
        for (AbstractNode abstractNode : this.getReactionNodes()) {
            level = Math.max(level, ((ReactionNode)abstractNode).getAlias().getVisibilityLevel());
        }
        return level;
    }

    public List<ReactionNode> getReactionNodes() {
        ArrayList<ReactionNode> result = new ArrayList<ReactionNode>();
        for (AbstractNode node : this.nodes) {
            if (!(node instanceof ReactionNode)) continue;
            result.add((ReactionNode)node);
        }
        return result;
    }

    public Line2D getCenterLine() {
        AbstractNode firstOperator;
        Product product = this.getProducts().get(0);
        Reactant reactant = this.getReactants().get(0);
        Point2D startPoint = reactant.getLine().getPoints().get(reactant.getLine().getPoints().size() - 2);
        Point2D endPoint = product.getLine().getPoints().get(1);
        if (this instanceof TwoReactantReactionInterface) {
            firstOperator = null;
            for (NodeOperator operator : this.getOperators()) {
                if (!operator.isReactantOperator() || firstOperator != null) continue;
                firstOperator = operator;
            }
            if (firstOperator != null) {
                startPoint = firstOperator.getLine().getPoints().get(firstOperator.getLine().getPoints().size() - 2);
            }
        }
        if (this instanceof TwoProductReactionInterface) {
            firstOperator = null;
            for (NodeOperator operator : this.getOperators()) {
                if (!operator.isProductOperator() || firstOperator != null) continue;
                firstOperator = operator;
            }
            if (firstOperator != null) {
                endPoint = firstOperator.getLine().getPoints().get(firstOperator.getLine().getPoints().size() - 2);
            }
        }
        return new Line2D.Double(startPoint, endPoint);
    }

    public void removeModifier(Modifier modifier) {
        this.nodes.remove(modifier);
    }

    public ReactionRect getReactionRect() {
        return null;
    }

    public Point2D getCenterPoint() {
        Line2D line2D = this.getCenterLine();
        if (line2D == null) {
            return null;
        }
        return new Point2D.Double((line2D.getX1() + line2D.getX2()) / 2.0, (line2D.getY1() + line2D.getY2()) / 2.0);
    }

    public boolean containsElement(Element element) {
        for (ReactionNode node : this.getReactionNodes()) {
            if (!node.getElement().equals(element)) continue;
            return true;
        }
        return false;
    }

    public List<Line2D> getLinesForNodes(Set<Element> elements) {
        ArrayList<Line2D> result = new ArrayList<Line2D>();
        for (Element element : elements) {
            result.addAll(this.getLinesForElement(element));
        }
        return result;
    }

    private List<Line2D> getLinesForElement(Element element) {
        boolean input = false;
        boolean output = false;
        HashSet<AbstractNode> nodes = new HashSet<AbstractNode>();
        for (ReactionNode reactionNode : this.getReactionNodes()) {
            if (!reactionNode.getElement().equals(element)) continue;
            nodes.add(reactionNode);
            if (reactionNode instanceof Reactant) {
                input = true;
                continue;
            }
            if (reactionNode instanceof Modifier) {
                input = true;
                continue;
            }
            if (!(reactionNode instanceof Product)) continue;
            output = true;
        }
        int size = 0;
        do {
            size = nodes.size();
            for (NodeOperator operator : this.getOperators()) {
                if (input) {
                    for (AbstractNode abstractNode : operator.getInputs()) {
                        if (!nodes.contains(abstractNode)) continue;
                        nodes.add(operator);
                    }
                }
                if (!output) continue;
                for (AbstractNode abstractNode : operator.getOutputs()) {
                    if (!nodes.contains(abstractNode)) continue;
                    nodes.add(operator);
                }
            }
        } while (size != nodes.size());
        ArrayList<Line2D> arrayList = new ArrayList<Line2D>();
        for (AbstractNode abstractNode : nodes) {
            if (abstractNode instanceof NodeOperator) {
                arrayList.addAll(((NodeOperator)abstractNode).getLine().getLines());
                continue;
            }
            if (abstractNode instanceof ReactionNode) {
                arrayList.addAll(((ReactionNode)abstractNode).getLine().getLines());
                continue;
            }
            throw new InvalidArgumentException("Invalid class type: " + abstractNode.getClass());
        }
        return arrayList;
    }

    public Reaction copy() {
        if (this.getClass() == Reaction.class) {
            return new Reaction(this);
        }
        throw new InvalidStateException("Method copy() should be overriden in class " + this.getClass());
    }

    public List<NodeOperator> getOperators() {
        ArrayList<NodeOperator> result = new ArrayList<NodeOperator>();
        for (AbstractNode node : this.getNodes()) {
            if (!(node instanceof NodeOperator)) continue;
            result.add((NodeOperator)node);
        }
        return result;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public List<AbstractNode> getNodes() {
        return this.nodes;
    }

    public void setNodes(List<AbstractNode> nodes) {
        this.nodes = nodes;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public String getIdReaction() {
        return this.idReaction;
    }

    public void setIdReaction(String idReaction) {
        this.idReaction = idReaction;
    }

    public String getMetaId() {
        return this.metaId;
    }

    public void setMetaId(String metaId) {
        this.metaId = metaId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isReversible() {
        return this.reversible;
    }

    public void setReversible(boolean reversible) {
        this.reversible = reversible;
    }

    public boolean isKineticLaw() {
        return this.kineticLaw;
    }

    public void setKineticLaw(boolean kineticLaw) {
        this.kineticLaw = kineticLaw;
    }

    public Set<MiriamData> getMiriamData() {
        return this.miriamDataSet;
    }

    @Override
    public void addMiriamData(Set<MiriamData> miriamData, List<String> warnings) {
        if (miriamData != null) {
            for (MiriamData md : miriamData) {
                this.addMiriamData(md, warnings);
            }
        }
    }

    public ModelData getModelData() {
        return this.model;
    }

    public void setModelData(ModelData model) {
        this.model = model;
    }

    @Override
    public void addMiriamData(MiriamData md, List<String> warnings) {
        if (this.miriamDataSet.contains(md)) {
            String warning = "Miriam data (" + (Object)((Object)md.getDataType()) + ": " + md.getResource() + ") for " + this.getIdReaction() + " already exists. Ignoring...";
            if (warnings != null) {
                warnings.add(warning);
            } else {
                logger.warn(warning);
            }
        } else {
            this.miriamDataSet.add(md);
        }
        this.miriamDataSet.add(md);
    }

    public void setModel(Model model2) {
        this.model = model2.getModelData();
    }

    @XmlTransient
    public Model getModel() {
        return this.model.getModel();
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public void setAbbreviation(String abbreviation) {
        this.abbreviation = abbreviation;
    }

    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public Integer getMechanicalConfidenceScore() {
        return this.mechanicalConfidenceScore;
    }

    public void setMechanicalConfidenceScore(Integer mechanicalConfidenceScore) {
        this.mechanicalConfidenceScore = mechanicalConfidenceScore;
    }

    public Double getLowerBound() {
        return this.lowerBound;
    }

    public void setLowerBound(Double lowerBound) {
        this.lowerBound = lowerBound;
    }

    public Double getUpperBound() {
        return this.upperBound;
    }

    public void setUpperBound(Double upperBound) {
        this.upperBound = upperBound;
    }

    public String getSubsystem() {
        return this.subsystem;
    }

    public void setSubsystem(String subsystem) {
        this.subsystem = subsystem;
    }

    public String getGeneProteinReaction() {
        return this.geneProteinReaction;
    }

    public void setGeneProteinReaction(String geneProteinReaction) {
        this.geneProteinReaction = geneProteinReaction;
    }

    public List<String> getSynonyms() {
        return this.synonyms;
    }

    public void setSynonyms(List<String> synonyms) {
        this.synonyms = synonyms;
    }
}

