/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.map.reaction;

import java.util.Comparator;
import lcsb.mapviewer.common.comparator.IntegerComparator;
import lcsb.mapviewer.common.exception.InvalidClassException;
import lcsb.mapviewer.model.map.reaction.AbstractNode;
import lcsb.mapviewer.model.map.reaction.AbstractNodeComparator;
import lcsb.mapviewer.model.map.reaction.NodeOperator;
import org.apache.log4j.Logger;

public class NodeOperatorComparator
implements Comparator<NodeOperator> {
    private Logger logger = Logger.getLogger(NodeOperatorComparator.class);
    private double epsilon;

    public NodeOperatorComparator(double epsilon) {
        this.epsilon = epsilon;
    }

    public NodeOperatorComparator() {
        this(1.0E-6);
    }

    @Override
    public int compare(NodeOperator arg0, NodeOperator arg1) {
        if (arg0 == null) {
            if (arg1 == null) {
                return 0;
            }
            return 1;
        }
        if (arg1 == null) {
            return -1;
        }
        if (arg0.getClass().equals(arg1.getClass())) {
            if (arg0 instanceof NodeOperator) {
                return this.internalCompare(arg0, arg1);
            }
            throw new InvalidClassException("Don't know how to compare classes: " + arg0.getClass());
        }
        this.logger.debug("Different classes.");
        return -1;
    }

    private int internalCompare(NodeOperator arg0, NodeOperator arg1) {
        int tmpStatus;
        AbstractNode node2;
        int j;
        int status;
        AbstractNode node1;
        int i;
        AbstractNodeComparator anComparator = new AbstractNodeComparator(this.epsilon);
        int result = anComparator.internalCompare(arg0, arg1);
        if (result != 0) {
            this.logger.debug("Different Abstract Nodes: " + arg0 + ", " + arg1);
            return result;
        }
        IntegerComparator integerComparator = new IntegerComparator();
        if (integerComparator.compare(arg0.getInputs().size(), arg1.getInputs().size()) != 0) {
            this.logger.debug("Different input size: " + arg0.getInputs().size() + ", " + arg1.getInputs().size());
            return integerComparator.compare(arg0.getInputs().size(), arg1.getInputs().size());
        }
        if (integerComparator.compare(arg0.getOutputs().size(), arg1.getOutputs().size()) != 0) {
            this.logger.debug("Different output size: " + arg0.getOutputs().size() + ", " + arg1.getOutputs().size());
            return integerComparator.compare(arg0.getOutputs().size(), arg1.getOutputs().size());
        }
        for (i = 0; i < arg0.getInputs().size(); ++i) {
            node1 = arg0.getInputs().get(i);
            status = -1;
            for (j = 0; j < arg1.getInputs().size(); ++j) {
                node2 = arg1.getInputs().get(j);
                tmpStatus = anComparator.compare(node1, node2);
                if (tmpStatus != 0) continue;
                status = 0;
                break;
            }
            if (status == 0) continue;
            this.logger.debug("Can't find match in inputs.");
            return status;
        }
        for (i = 0; i < arg0.getOutputs().size(); ++i) {
            node1 = arg0.getOutputs().get(i);
            status = -1;
            for (j = 0; j < arg1.getOutputs().size(); ++j) {
                node2 = arg1.getOutputs().get(j);
                tmpStatus = anComparator.compare(node1, node2);
                if (tmpStatus != 0) continue;
                status = 0;
                break;
            }
            if (status == 0) continue;
            this.logger.debug("Can't find match in outputs.");
            return status;
        }
        return 0;
    }
}

