/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.map.model;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import lcsb.mapviewer.model.map.model.Model;
import lcsb.mapviewer.model.map.model.ModelData;
import lcsb.mapviewer.model.map.model.SubmodelType;
import org.apache.log4j.Logger;

@Entity
@Table(name="submodel_connection_table")
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name="submodel_connections_type_db", discriminatorType=DiscriminatorType.STRING)
@DiscriminatorValue(value="SUBMODEL_CONNECTION")
public abstract class SubmodelConnection {
    private static Logger logger = Logger.getLogger(SubmodelConnection.class);
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="idDb", unique=true, nullable=false)
    private int id;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private ModelData submodel;
    private String name;
    private SubmodelType type;

    public SubmodelConnection() {
    }

    public SubmodelConnection(ModelData submodel, SubmodelType type) {
        this.setSubmodel(submodel);
        this.setType(type);
    }

    public SubmodelConnection(SubmodelConnection original) {
        this.setSubmodel(original.getSubmodel());
        this.setName(original.getName());
        this.setType(original.getType());
    }

    public SubmodelConnection(Model submodel, SubmodelType type, String name) {
        this.setSubmodel(submodel);
        this.setName(name);
        this.setType(type);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SubmodelType getType() {
        return this.type;
    }

    public void setType(SubmodelType type) {
        this.type = type;
    }

    public ModelData getSubmodel() {
        return this.submodel;
    }

    public void setSubmodel(ModelData submodel) {
        if (this.submodel != null) {
            this.submodel.getParentModels().remove(this);
        }
        this.submodel = submodel;
        submodel.getParentModels().add(this);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setSubmodel(Model submodel) {
        this.setSubmodel(submodel.getModelData());
    }

    public abstract SubmodelConnection copy();

    protected void assignValuesFromOriginal(SubmodelConnection original) {
        this.submodel = original.getSubmodel();
        this.name = original.getName();
        this.type = original.getType();
    }
}

