/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.map.layout.graphics;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import lcsb.mapviewer.common.exception.InvalidStateException;
import org.apache.log4j.Logger;

@Entity
public class LayerText {
    private static final double DEFAULT_LAYER_FONT_SIZE = 11.0;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="idDb", unique=true, nullable=false)
    private int id;
    private static Logger logger = Logger.getLogger(LayerText.class);
    private Color color = Color.BLACK;
    private Double x = 0.0;
    private Double y = 0.0;
    private Double width = 0.0;
    private Double height = 0.0;
    private String notes;
    private Double fontSize = 11.0;

    public LayerText() {
    }

    public LayerText(Rectangle2D bound, String text) {
        this.setX(bound.getX());
        this.setY(bound.getY());
        this.setWidth(bound.getWidth());
        this.setHeight(bound.getHeight());
        this.setNotes(text);
    }

    public LayerText(LayerText layerText) {
        this.color = layerText.getColor();
        this.x = layerText.getX();
        this.y = layerText.getY();
        this.width = layerText.getWidth();
        this.height = layerText.getHeight();
        this.notes = layerText.getNotes();
        this.fontSize = layerText.getFontSize();
    }

    public void setX(String param) {
        try {
            this.x = Double.parseDouble(param);
        }
        catch (Exception e) {
            logger.error("Invalid x value: " + param);
        }
    }

    public void setY(String param) {
        try {
            this.y = Double.parseDouble(param);
        }
        catch (Exception e) {
            logger.error("Invalid y value: " + param);
        }
    }

    public void setWidth(String param) {
        try {
            this.width = Double.parseDouble(param);
        }
        catch (Exception e) {
            logger.error("Invalid width value: " + param);
        }
    }

    public void setHeight(String param) {
        try {
            this.height = Double.parseDouble(param);
        }
        catch (Exception e) {
            logger.error("Invalid height value: " + param);
        }
    }

    public void setFontSize(String param) {
        try {
            this.fontSize = Double.parseDouble(param);
        }
        catch (Exception e) {
            logger.error("Invalid fontSize value: " + param);
        }
    }

    public LayerText copy() {
        if (this.getClass() == LayerText.class) {
            return new LayerText(this);
        }
        throw new InvalidStateException("Method copy() should be overriden in class " + this.getClass());
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Double getX() {
        return this.x;
    }

    public void setX(Double x) {
        this.x = x;
    }

    public Double getY() {
        return this.y;
    }

    public void setY(Double y) {
        this.y = y;
    }

    public Double getWidth() {
        return this.width;
    }

    public void setWidth(Double width) {
        this.width = width;
    }

    public Double getHeight() {
        return this.height;
    }

    public void setHeight(Double height) {
        this.height = height;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public Double getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(Double fontSize) {
        this.fontSize = fontSize;
    }
}

