/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.map.layout.graphics;

import java.util.Comparator;
import lcsb.mapviewer.common.comparator.BooleanComparator;
import lcsb.mapviewer.common.comparator.IntegerComparator;
import lcsb.mapviewer.common.comparator.StringComparator;
import lcsb.mapviewer.common.exception.InvalidClassException;
import lcsb.mapviewer.model.graphics.PolylineDataComparator;
import lcsb.mapviewer.model.map.layout.graphics.Layer;
import lcsb.mapviewer.model.map.layout.graphics.LayerOvalComparator;
import lcsb.mapviewer.model.map.layout.graphics.LayerRectComparator;
import lcsb.mapviewer.model.map.layout.graphics.LayerTextComparator;

public class LayerComparator
implements Comparator<Layer> {
    private double epsilon;

    public LayerComparator(double epsilon) {
        this.epsilon = epsilon;
    }

    public LayerComparator() {
        this(1.0E-6);
    }

    @Override
    public int compare(Layer arg0, Layer arg1) {
        if (arg0 == null) {
            if (arg1 == null) {
                return 0;
            }
            return 1;
        }
        if (arg1 == null) {
            return -1;
        }
        if (arg0.getClass().equals(arg1.getClass())) {
            if (arg0 instanceof Layer) {
                return this.internalCompare(arg0, arg1);
            }
            throw new InvalidClassException("Don't know how to compare classes: " + arg0.getClass());
        }
        return -1;
    }

    private int internalCompare(Layer arg0, Layer arg1) {
        StringComparator stringComparator = new StringComparator();
        BooleanComparator booleanComparator = new BooleanComparator();
        IntegerComparator integerComparator = new IntegerComparator();
        if (stringComparator.compare(arg0.getLayerId(), arg1.getLayerId()) != 0) {
            return stringComparator.compare(arg0.getLayerId(), arg1.getLayerId());
        }
        if (stringComparator.compare(arg0.getName(), arg1.getName()) != 0) {
            return stringComparator.compare(arg0.getName(), arg1.getName());
        }
        if (booleanComparator.compare(arg0.isVisible(), arg1.isVisible()) != 0) {
            return booleanComparator.compare(arg0.isVisible(), arg1.isVisible());
        }
        if (booleanComparator.compare(arg0.isLocked(), arg1.isLocked()) != 0) {
            return booleanComparator.compare(arg0.isLocked(), arg1.isLocked());
        }
        if (integerComparator.compare(arg0.getTexts().size(), arg1.getTexts().size()) != 0) {
            return integerComparator.compare(arg0.getTexts().size(), arg1.getTexts().size());
        }
        if (integerComparator.compare(arg0.getLines().size(), arg1.getLines().size()) != 0) {
            return integerComparator.compare(arg0.getLines().size(), arg1.getLines().size());
        }
        if (integerComparator.compare(arg0.getRectangles().size(), arg1.getRectangles().size()) != 0) {
            return integerComparator.compare(arg0.getRectangles().size(), arg1.getRectangles().size());
        }
        if (integerComparator.compare(arg0.getOvals().size(), arg1.getOvals().size()) != 0) {
            return integerComparator.compare(arg0.getOvals().size(), arg1.getOvals().size());
        }
        LayerTextComparator textComparator = new LayerTextComparator(this.epsilon);
        for (int i = 0; i < arg0.getTexts().size(); ++i) {
            int status = textComparator.compare(arg0.getTexts().get(i), arg1.getTexts().get(i));
            if (status == 0) continue;
            return status;
        }
        LayerOvalComparator ovalComparator = new LayerOvalComparator(this.epsilon);
        for (int i = 0; i < arg0.getOvals().size(); ++i) {
            int status = ovalComparator.compare(arg0.getOvals().get(i), arg1.getOvals().get(i));
            if (status == 0) continue;
            return status;
        }
        LayerRectComparator rectComparator = new LayerRectComparator(this.epsilon);
        for (int i = 0; i < arg0.getRectangles().size(); ++i) {
            int status = rectComparator.compare(arg0.getRectangles().get(i), arg1.getRectangles().get(i));
            if (status == 0) continue;
            return status;
        }
        PolylineDataComparator lineComparator = new PolylineDataComparator(this.epsilon);
        for (int i = 0; i < arg0.getLines().size(); ++i) {
            int status = lineComparator.compare(arg0.getLines().get(i), arg1.getLines().get(i));
            if (status == 0) continue;
            return status;
        }
        return 0;
    }
}

