/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.map.layout.alias;

import java.util.Comparator;
import lcsb.mapviewer.common.comparator.BooleanComparator;
import lcsb.mapviewer.common.comparator.DoubleComparator;
import lcsb.mapviewer.common.exception.InvalidClassException;
import lcsb.mapviewer.model.map.layout.alias.AliasComparator;
import lcsb.mapviewer.model.map.layout.alias.ComplexAlias;
import lcsb.mapviewer.model.map.layout.alias.ComplexAliasComparator;
import lcsb.mapviewer.model.map.layout.alias.SpeciesAlias;
import lcsb.mapviewer.model.map.species.SpeciesComparator;
import org.apache.log4j.Logger;

public class SpeciesAliasComparator
implements Comparator<SpeciesAlias> {
    private Logger logger = Logger.getLogger(SpeciesAliasComparator.class);
    private double epsilon;

    public SpeciesAliasComparator(double epsilon) {
        this.epsilon = epsilon;
    }

    public SpeciesAliasComparator() {
        this(1.0E-6);
    }

    @Override
    public int compare(SpeciesAlias arg0, SpeciesAlias arg1) {
        if (arg0 == null) {
            if (arg1 == null) {
                return 0;
            }
            return 1;
        }
        if (arg1 == null) {
            return -1;
        }
        if (arg0.getClass().equals(arg1.getClass())) {
            if (arg0 instanceof ComplexAlias) {
                ComplexAliasComparator caComparator = new ComplexAliasComparator(this.epsilon);
                return caComparator.compare((ComplexAlias)arg0, (ComplexAlias)arg1);
            }
            if (arg0.getClass().equals(SpeciesAlias.class)) {
                return this.internalCompare(arg0, arg1);
            }
            throw new InvalidClassException("Don't know how to compare classes: " + arg0.getClass());
        }
        return -1;
    }

    int internalCompare(SpeciesAlias arg0, SpeciesAlias arg1) {
        AliasComparator aliasComparator = new AliasComparator(this.epsilon);
        int result = aliasComparator.internalCompare(arg0, arg1);
        if (result != 0) {
            return result;
        }
        DoubleComparator doubleComparator = new DoubleComparator(this.epsilon);
        BooleanComparator booleanComparator = new BooleanComparator();
        SpeciesComparator speciesComparator = new SpeciesComparator(this.epsilon);
        if (speciesComparator.compare(arg0.getSpecies(), arg1.getSpecies()) != 0) {
            this.logger.debug("Species different: " + arg0.getSpecies().getIdSpecies() + ", " + arg1.getSpecies().getIdSpecies());
            return speciesComparator.compare(arg0.getSpecies(), arg1.getSpecies());
        }
        if (booleanComparator.compare(arg0.getActivity(), arg1.getActivity()) != 0) {
            this.logger.debug("activity different: " + arg0.getActivity() + ", " + arg1.getActivity());
            return booleanComparator.compare(arg0.getActivity(), arg1.getActivity());
        }
        if (doubleComparator.compare(arg0.getLineWidth(), arg1.getLineWidth()) != 0) {
            this.logger.debug("line width different: " + arg0.getLineWidth() + ", " + arg1.getLineWidth());
            return doubleComparator.compare(arg0.getLineWidth(), arg1.getLineWidth());
        }
        return 0;
    }
}

