/*
 * Decompiled with CFR 0.152.
 */
package lcsb.mapviewer.model.map.layout.alias;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import lcsb.mapviewer.common.exception.InvalidStateException;
import lcsb.mapviewer.model.map.layout.alias.Alias;
import org.apache.log4j.Logger;

@Entity
@Table(name="search_index_table")
public class SearchIndex {
    private static Logger logger = Logger.getLogger(Alias.class);
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="idDb", unique=true, nullable=false)
    private int id;
    @ManyToOne
    private Alias source;
    private String value;
    private Integer weight;

    public SearchIndex() {
    }

    public SearchIndex(String value, int weight) {
        this.value = value;
        this.weight = weight;
    }

    public SearchIndex(String value) {
        this.value = value;
        this.weight = 1;
    }

    public SearchIndex(SearchIndex searchIndex) {
        this.source = searchIndex.getSource();
        this.value = searchIndex.getValue();
        this.weight = searchIndex.getWeight();
    }

    public SearchIndex copy() {
        if (this.getClass() == SearchIndex.class) {
            return new SearchIndex(this);
        }
        throw new InvalidStateException("Method copy() should be overriden in class " + this.getClass());
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Alias getSource() {
        return this.source;
    }

    public void setSource(Alias source) {
        this.source = source;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Integer getWeight() {
        return this.weight;
    }

    public void setWeight(Integer weight) {
        this.weight = weight;
    }
}

